/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.genericutil;

import com.ibm.wala.demandpa.genericutil.Util;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableStack<T> {
    private static final ImmutableStack<Object> EMPTY = new ImmutableStack<Object>(new Object[0]);
    private static final int MAX_SIZE = Integer.MAX_VALUE;
    private final T[] entries;
    private final int cachedHashCode;

    public static int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public static final <T> ImmutableStack<T> emptyStack() {
        return EMPTY;
    }

    protected ImmutableStack(T[] entries) {
        this.entries = entries;
        this.cachedHashCode = Util.hashArray(entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof ImmutableStack) {
            ImmutableStack other = (ImmutableStack)o;
            return Arrays.equals(this.entries, other.entries);
        }
        return false;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public ImmutableStack<T> push(T entry) {
        assert (entry != null);
        int size = this.entries.length + 1;
        Object[] tmpEntries = null;
        if (size <= Integer.MAX_VALUE) {
            tmpEntries = this.makeInternalArray(size);
            System.arraycopy(this.entries, 0, tmpEntries, 0, this.entries.length);
            tmpEntries[size - 1] = entry;
        } else {
            tmpEntries = this.makeInternalArray(Integer.MAX_VALUE);
            System.arraycopy(this.entries, 1, tmpEntries, 0, this.entries.length - 1);
            tmpEntries[0x7FFFFFFE] = entry;
        }
        return this.makeStack(tmpEntries);
    }

    protected T[] makeInternalArray(int size) {
        return new Object[size];
    }

    protected ImmutableStack<T> makeStack(T[] tmpEntries) {
        return new ImmutableStack<T>(tmpEntries);
    }

    public T peek() {
        assert (this.entries.length != 0);
        return this.entries[this.entries.length - 1];
    }

    public ImmutableStack<T> pop() {
        assert (this.entries.length != 0);
        int size = this.entries.length - 1;
        T[] tmpEntries = this.makeInternalArray(size);
        System.arraycopy(this.entries, 0, tmpEntries, 0, size);
        return this.makeStack(tmpEntries);
    }

    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    public int size() {
        return this.entries.length;
    }

    public T get(int i) {
        return this.entries[i];
    }

    public String toString() {
        String objArrayToString = Util.objArrayToString(this.entries);
        assert (this.entries.length <= Integer.MAX_VALUE) : objArrayToString;
        return objArrayToString;
    }

    public boolean contains(T entry) {
        return Util.arrayContains(this.entries, entry, this.entries.length);
    }

    public boolean topMatches(ImmutableStack<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        if (other.size() > this.size()) {
            return false;
        }
        int i = other.size() - 1;
        int j = this.size() - 1;
        while (i >= 0) {
            if (!other.get(i).equals(this.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    public ImmutableStack<T> reverse() {
        Object[] tmpEntries = new Object[this.entries.length];
        int i = this.entries.length - 1;
        int j = 0;
        while (i >= 0) {
            tmpEntries[j] = this.entries[i];
            --i;
            ++j;
        }
        return new ImmutableStack<Object>(tmpEntries);
    }

    public ImmutableStack<T> popAll(ImmutableStack<T> other) {
        assert (this.topMatches(other));
        int size = this.entries.length - other.entries.length;
        Object[] tmpEntries = new Object[size];
        System.arraycopy(this.entries, 0, tmpEntries, 0, size);
        return new ImmutableStack<Object>(tmpEntries);
    }

    public ImmutableStack<T> pushAll(ImmutableStack<T> other) {
        int size = this.entries.length + other.entries.length;
        Object[] tmpEntries = null;
        if (size <= Integer.MAX_VALUE) {
            tmpEntries = new Object[size];
            System.arraycopy(this.entries, 0, tmpEntries, 0, this.entries.length);
            System.arraycopy(other.entries, 0, tmpEntries, this.entries.length, other.entries.length);
        } else {
            tmpEntries = new Object[Integer.MAX_VALUE];
            int numFromThis = Integer.MAX_VALUE - other.entries.length;
            System.arraycopy(this.entries, this.entries.length - numFromThis, tmpEntries, 0, numFromThis);
            System.arraycopy(other.entries, 0, tmpEntries, numFromThis, other.entries.length);
        }
        return new ImmutableStack<Object>(tmpEntries);
    }
}

