/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.genericutil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Predicate<T> {
    public static final Predicate FALSE = new Predicate(){

        public boolean test(Object obj_) {
            return false;
        }
    };
    public static final Predicate TRUE = FALSE.not();

    public static <T> Predicate<T> truePred() {
        return TRUE;
    }

    public static <T> Predicate<T> falsePred() {
        return FALSE;
    }

    public abstract boolean test(T var1);

    public Predicate<T> not() {
        final Predicate originalPredicate = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T obj_) {
                return !originalPredicate.test(obj_);
            }
        };
    }

    public Predicate<T> and(final Predicate<T> conjunct_) {
        final Predicate originalPredicate = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T obj_) {
                return originalPredicate.test(obj_) && conjunct_.test(obj_);
            }
        };
    }

    public Predicate<T> or(final Predicate<T> disjunct_) {
        final Predicate originalPredicate = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T obj_) {
                return originalPredicate.test(obj_) || disjunct_.test(obj_);
            }
        };
    }
}

