/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.genericutil;

import com.ibm.wala.demandpa.genericutil.Mapper;
import com.ibm.wala.demandpa.genericutil.ObjectVisitor;
import com.ibm.wala.demandpa.genericutil.Predicate;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.security.Permission;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final BitSet EMPTY_BITSET = new BitSet();
    public static final boolean FULLY_QUALIFIED_NAMES = false;

    public static String str(int[] ints) throws IllegalArgumentException {
        if (ints == null) {
            throw new IllegalArgumentException("ints == null");
        }
        StringBuffer s = new StringBuffer();
        s.append("[");
        int i = 0;
        while (i < ints.length) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(ints[i]);
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    public static String objArrayToString(Object[] o) {
        return Util.objArrayToString(o, "[", "]", ", ");
    }

    public static String objArrayToString(Object[] o, String start, String end, String sep) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException("o == null");
        }
        StringBuffer s = new StringBuffer();
        s.append(start);
        int i = 0;
        while (i < o.length) {
            if (o[i] != null) {
                if (i > 0) {
                    s.append(sep);
                }
                s.append(o[i].toString());
            }
            ++i;
        }
        s.append(end);
        return s.toString();
    }

    public static String str(Throwable thrown) throws IllegalArgumentException {
        if (thrown == null) {
            throw new IllegalArgumentException("thrown == null");
        }
        ByteArrayOutputStream traceDump = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(traceDump);
        thrown.printStackTrace(w);
        w.close();
        return traceDump.toString();
    }

    public static <T> boolean forSome(Collection<T> c, Predicate<T> p) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        for (T t : c) {
            if (!p.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> T find(Collection<T> c, Predicate<T> p) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        for (T obj : c) {
            if (!p.test(obj)) continue;
            return obj;
        }
        return null;
    }

    public static <T> Collection<T> findAll(Collection<T> c, Predicate<T> p) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        LinkedList<T> result = new LinkedList<T>();
        for (T obj : c) {
            if (!p.test(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public static <T> boolean forAll(Collection<T> c, Predicate<T> p) throws NullPointerException {
        for (T t : c) {
            if (p.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> void doForAll(Collection<T> c, ObjectVisitor<T> v) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        Iterator<T> iter = c.iterator();
        while (iter.hasNext()) {
            v.visit(iter.next());
        }
    }

    public static <T, U> List<U> map(List<T> srcList, Mapper<T, U> mapper) throws IllegalArgumentException {
        if (srcList == null) {
            throw new IllegalArgumentException("srcList == null");
        }
        ArrayList<U> result = new ArrayList<U>();
        Iterator<T> srcIter = srcList.iterator();
        while (srcIter.hasNext()) {
            result.add(mapper.map(srcIter.next()));
        }
        return result;
    }

    public static <T> List<T> filter(Collection<T> src, Predicate<T> pred) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T curElem : src) {
            if (!pred.test(curElem)) continue;
            result.add(curElem);
        }
        return result;
    }

    public static <T> void filter(Collection<T> src, Predicate<T> pred, List<T> result) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        for (T t : src) {
            if (!pred.test(t)) continue;
            result.add(t);
        }
    }

    public static <T, U> Set<U> mapToSet(Collection<T> srcSet, Mapper<T, U> mapper) throws IllegalArgumentException {
        if (srcSet == null) {
            throw new IllegalArgumentException("srcSet == null");
        }
        HashSet<U> result = new HashSet<U>();
        Iterator<T> srcIter = srcSet.iterator();
        while (srcIter.hasNext()) {
            result.add(mapper.map(srcIter.next()));
        }
        return result;
    }

    public static int[] realloc(int[] data, int newSize) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        if (data.length < newSize) {
            int[] newData = new int[newSize];
            System.arraycopy(data, 0, newData, 0, data.length);
            return newData;
        }
        return data;
    }

    public static void clear(BitSet bitSet) throws IllegalArgumentException {
        if (bitSet == null) {
            throw new IllegalArgumentException("bitSet == null");
        }
        bitSet.and(EMPTY_BITSET);
    }

    public static String replaceAll(String str, String sub, String newSub) throws IllegalArgumentException {
        int idx;
        if (str == null) {
            throw new IllegalArgumentException("str == null");
        }
        if (str.indexOf(sub) == -1) {
            return str;
        }
        int subLen = sub.length();
        StringBuffer result = new StringBuffer(str);
        while ((idx = result.toString().indexOf(sub)) >= 0) {
            result.replace(idx, idx + subLen, newSub);
        }
        return result.toString();
    }

    public static String removeAll(String str, String sub) {
        return Util.replaceAll(str, sub, "");
    }

    public static String objectFieldsToString(Object obj) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException("obj == null");
        }
        SecurityManager oldsecurity = System.getSecurityManager();
        System.setSecurityManager(new SecurityManager(){

            public void checkPermission(Permission perm) {
            }
        });
        Class<?> c = obj.getClass();
        StringBuffer buf = new StringBuffer(Util.removePackageName(c.getName()));
        while (c != Object.class) {
            Field[] fields = c.getDeclaredFields();
            if (fields.length > 0) {
                buf = buf.append(" (");
            }
            int i = 0;
            while (i < fields.length) {
                fields[i].setAccessible(true);
                try {
                    Class<?> type = fields[i].getType();
                    String name = fields[i].getName();
                    Object value = fields[i].get(obj);
                    buf = buf.append(name);
                    buf = buf.append("=");
                    buf = buf.append(value == null ? "null" : value.toString());
                    buf = buf.append(" : ");
                    buf = buf.append(Util.removePackageName(type.getName()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                buf = buf.append(i + 1 >= fields.length ? ")" : ",");
                ++i;
            }
            c = c.getSuperclass();
        }
        System.setSecurityManager(oldsecurity);
        return buf.toString();
    }

    public static String removePackageName(String fully_qualified_name_) {
        if (fully_qualified_name_ == null) {
            return null;
        }
        int lastdot = fully_qualified_name_.lastIndexOf(46);
        if (lastdot < 0) {
            return "";
        }
        return fully_qualified_name_.substring(lastdot + 1);
    }

    public static int hashArray(Object[] objs) throws IllegalArgumentException {
        if (objs == null) {
            throw new IllegalArgumentException("objs == null");
        }
        int ret = 1;
        int i = 0;
        while (i < objs.length) {
            ret = 31 * ret + (objs[i] == null ? 0 : objs[i].hashCode());
            ++i;
        }
        return ret;
    }

    public static boolean arrayContains(Object[] arr, Object obj, int size) {
        assert (obj != null);
        int i = 0;
        while (i < size) {
            if (arr[i] != null && arr[i].equals(obj)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String toStringNull(Object o) {
        return o == null ? "" : "[" + o.toString() + "]";
    }

    public static <T> boolean intersecting(Set<T> s1, final Set<T> s2) {
        return Util.forSome(s1, new Predicate<T>(){

            @Override
            public boolean test(T obj) {
                return s2.contains(obj);
            }
        });
    }

    public static int getInt(Integer i) {
        return i == null ? 0 : i;
    }

    public static String topLevelTypeString(String typeStr) throws IllegalArgumentException {
        if (typeStr == null) {
            throw new IllegalArgumentException("typeStr == null");
        }
        int dollarIndex = typeStr.indexOf(36);
        String topLevelTypeStr = dollarIndex == -1 ? typeStr : typeStr.substring(0, dollarIndex);
        return topLevelTypeStr;
    }

    public static <T> void addIfNotNull(T val, Collection<T> vals) {
        if (val != null) {
            vals.add(val);
        }
    }

    public static <T> List<T> pickNAtRandom(List<T> vals, int n, long seed) throws IllegalArgumentException {
        if (vals == null) {
            throw new IllegalArgumentException("vals == null");
        }
        if (vals.size() <= n) {
            return vals;
        }
        HashSet<T> elems = new HashSet<T>();
        Random rand = new Random(seed);
        int i = 0;
        while (i < n) {
            int randIndex;
            boolean added = true;
            while (!(added = elems.add(vals.get(randIndex = rand.nextInt(n))))) {
            }
            ++i;
        }
        return new ArrayList(elems);
    }
}

