/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.util;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.ArrayLoadInstruction;
import com.ibm.wala.shrikeBT.ArrayStoreInstruction;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ShrikeUtil;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryAccessMap {
    private final Map<IField, Set<MemoryAccess>> readMap = HashMapFactory.make();
    private final Map<IField, Set<MemoryAccess>> writeMap = HashMapFactory.make();
    private final Set<MemoryAccess> arrayReads = HashSetFactory.make();
    private final Set<MemoryAccess> arrayWrites = HashSetFactory.make();
    private final IClassHierarchy cha;
    private final boolean includePrimOps;

    public MemoryAccessMap(CallGraph cg, boolean includePrimOps) {
        this.cha = cg.getClassHierarchy();
        this.includePrimOps = includePrimOps;
        this.populate(cg);
    }

    private void populate(CallGraph cg) {
        for (CGNode n : cg) {
            this.populate(n);
        }
    }

    private void populate(CGNode n) {
        if (n.getMethod().isSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)n.getMethod();
            SSAInstruction[] statements = sm.getStatements();
            SSAMemoryAccessVisitor v = new SSAMemoryAccessVisitor(n);
            int i = 0;
            while (i < statements.length) {
                SSAInstruction s = statements[i];
                if (s != null) {
                    v.setInstructionIndex(i);
                    s.visit(v);
                }
                ++i;
            }
        } else {
            ShrikeCTMethod sm = (ShrikeCTMethod)n.getMethod();
            MemoryAccessVisitor v = new MemoryAccessVisitor(n.getMethod().getReference().getDeclaringClass().getClassLoader(), n);
            try {
                Instruction[] statements = sm.getInstructions();
                if (statements == null) {
                    return;
                }
                int i = 0;
                while (i < statements.length) {
                    Instruction s = statements[i];
                    if (s != null) {
                        v.setInstructionIndex(i);
                        s.visit(v);
                    }
                    ++i;
                }
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }
    }

    public Collection<MemoryAccess> getFieldReads(IField field) {
        Collection result = this.readMap.get(field);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    public Collection<MemoryAccess> getFieldWrites(IField field) {
        Collection result = this.writeMap.get(field);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    public Collection<MemoryAccess> getArrayReads() {
        return this.arrayReads;
    }

    public Collection<MemoryAccess> getArrayWrites() {
        return this.arrayWrites;
    }

    public String toString() {
        Iterator<MemoryAccess> it2;
        StringBuffer result = new StringBuffer();
        HashSet allFields = new HashSet();
        allFields.addAll(this.readMap.keySet());
        allFields.addAll(this.writeMap.keySet());
        for (IField f : allFields) {
            Collection<MemoryAccess> writes;
            result.append("FIELD ").append(f).append(":\n");
            Collection<MemoryAccess> reads = this.getFieldReads(f);
            if (!reads.isEmpty()) {
                result.append("  reads:\n");
                Iterator<MemoryAccess> it22 = reads.iterator();
                while (it22.hasNext()) {
                    result.append("  ").append(it22.next()).append("\n");
                }
            }
            if ((writes = this.getFieldWrites(f)).isEmpty()) continue;
            result.append("  writes:\n");
            Iterator<MemoryAccess> it23 = writes.iterator();
            while (it23.hasNext()) {
                result.append("  ").append(it23.next()).append("\n");
            }
        }
        result.append("ARRAY CONTENTS:\n");
        if (!this.arrayReads.isEmpty()) {
            result.append("  reads:\n");
            it2 = this.arrayReads.iterator();
            while (it2.hasNext()) {
                result.append("  ").append(it2.next()).append("\n");
            }
        }
        if (!this.arrayWrites.isEmpty()) {
            result.append("  writes:\n");
            it2 = this.arrayWrites.iterator();
            while (it2.hasNext()) {
                result.append("  ").append(it2.next()).append("\n");
            }
        }
        return result.toString();
    }

    private class MemoryAccessVisitor
    extends Instruction.Visitor {
        int instructionIndex;
        final ClassLoaderReference loader;
        final CGNode node;

        public MemoryAccessVisitor(ClassLoaderReference loader, CGNode node) {
            this.loader = loader;
            this.node = node;
        }

        protected int getInstructionIndex() {
            return this.instructionIndex;
        }

        protected void setInstructionIndex(int instructionIndex) {
            this.instructionIndex = instructionIndex;
        }

        public void visitNew(NewInstruction instruction) {
            TypeReference tr = ShrikeUtil.makeTypeReference(this.loader, instruction.getType());
            if (tr.isArrayType() && tr.getArrayElementType().isArrayType()) {
                MemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
            }
        }

        public void visitArrayLoad(ArrayLoadInstruction instruction) {
            TypeReference tr;
            if (!MemoryAccessMap.this.includePrimOps && (tr = ShrikeUtil.makeTypeReference(this.loader, instruction.getType())).isPrimitiveType()) {
                return;
            }
            MemoryAccessMap.this.arrayReads.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        public void visitArrayStore(ArrayStoreInstruction instruction) {
            TypeReference tr;
            if (!MemoryAccessMap.this.includePrimOps && (tr = ShrikeUtil.makeTypeReference(this.loader, instruction.getType())).isPrimitiveType()) {
                return;
            }
            MemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        public void visitGet(GetInstruction instruction) {
            FieldReference fr = FieldReference.findOrCreate(this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
            if (!MemoryAccessMap.this.includePrimOps && fr.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = MemoryAccessMap.this.cha.resolveField(fr);
            if (f == null) {
                return;
            }
            Set s = MapUtil.findOrCreateSet(MemoryAccessMap.this.readMap, f);
            MemoryAccess fa = new MemoryAccess(this.instructionIndex, this.node);
            s.add(fa);
        }

        public void visitPut(PutInstruction instruction) {
            FieldReference fr = FieldReference.findOrCreate(this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
            if (!MemoryAccessMap.this.includePrimOps && fr.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = MemoryAccessMap.this.cha.resolveField(fr);
            if (f == null) {
                return;
            }
            Set s = MapUtil.findOrCreateSet(MemoryAccessMap.this.writeMap, f);
            MemoryAccess fa = new MemoryAccess(this.instructionIndex, this.node);
            s.add(fa);
        }
    }

    private class SSAMemoryAccessVisitor
    extends SSAInstruction.Visitor {
        private final CGNode node;
        private int instructionIndex;

        public SSAMemoryAccessVisitor(CGNode n) {
            this.node = n;
        }

        public void setInstructionIndex(int i) {
            this.instructionIndex = i;
        }

        public void visitNew(SSANewInstruction instruction) {
            TypeReference declaredType = instruction.getNewSite().getDeclaredType();
            if (declaredType.isArrayType() && declaredType.getArrayElementType().isArrayType()) {
                MemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
            }
        }

        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            if (!MemoryAccessMap.this.includePrimOps && instruction.typeIsPrimitive()) {
                return;
            }
            MemoryAccessMap.this.arrayReads.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            if (!MemoryAccessMap.this.includePrimOps && instruction.typeIsPrimitive()) {
                return;
            }
            MemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        public void visitGet(SSAGetInstruction instruction) {
            if (!MemoryAccessMap.this.includePrimOps && instruction.getDeclaredFieldType().isPrimitiveType()) {
                return;
            }
            FieldReference fr = instruction.getDeclaredField();
            IField f = MemoryAccessMap.this.cha.resolveField(fr);
            if (f == null) {
                return;
            }
            Set s = MapUtil.findOrCreateSet(MemoryAccessMap.this.readMap, f);
            MemoryAccess fa = new MemoryAccess(this.instructionIndex, this.node);
            s.add(fa);
        }

        public void visitPut(SSAPutInstruction instruction) {
            if (!MemoryAccessMap.this.includePrimOps && instruction.getDeclaredFieldType().isPrimitiveType()) {
                return;
            }
            FieldReference fr = instruction.getDeclaredField();
            IField f = MemoryAccessMap.this.cha.resolveField(fr);
            if (f == null) {
                return;
            }
            Set s = MapUtil.findOrCreateSet(MemoryAccessMap.this.writeMap, f);
            MemoryAccess fa = new MemoryAccess(this.instructionIndex, this.node);
            s.add(fa);
        }
    }
}

