/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.util;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.Trace;
import com.ibm.wala.util.warnings.WalaException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class WalaUtil {
    public static void initializeTraceFile() {
        Properties prop = null;
        try {
            prop = WalaProperties.loadProperties();
        }
        catch (WalaException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
        String outputDir = prop.getProperty("output_dir");
        String fileName = String.valueOf(outputDir) + File.separator + "trace.txt";
        Trace.setTraceFile(fileName);
    }

    public static void dumpAllIR(CallGraph cg, String benchName, Properties p) throws IllegalArgumentException, IllegalArgumentException {
        if (cg == null) {
            throw new IllegalArgumentException("cg == null");
        }
        if (p == null) {
            throw new IllegalArgumentException("p == null");
        }
        System.err.print("dumping ir...");
        String irFile = String.valueOf(p.getProperty("output_dir")) + File.separatorChar + benchName + "-ir.txt";
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(irFile)));
            for (CGNode node : cg) {
                IR ir = node.getIR();
                if (ir == null) continue;
                writer.println(node);
                writer.println("+++++++++++++++++++++++++++++++++");
                writer.println(ir);
                writer.println("");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.err.println("done");
    }
}

