/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dynamic;

import com.ibm.wala.dynamic.Launcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLauncher
extends Launcher {
    private String programArgs;
    private final String mainClass;
    private final boolean inheritClasspath;
    private boolean enableAssertions;
    private final List<String> xtraClasspath = new ArrayList<String>();
    private Thread stdOutDrain;
    private Thread stdErrDrain;

    public static JavaLauncher make(String programArgs, String mainClass, List<String> classpathEntries) {
        return new JavaLauncher(programArgs, mainClass, true, classpathEntries, false, false);
    }

    public static JavaLauncher make(String programArgs, String mainClass, boolean inheritClasspath, List<String> classpathEntries, boolean captureOutput, boolean captureErr) {
        return new JavaLauncher(programArgs, mainClass, inheritClasspath, classpathEntries, captureOutput, captureErr);
    }

    private JavaLauncher(String programArgs, String mainClass, boolean inheritClasspath, List<String> xtraClasspath, boolean captureOutput, boolean captureErr) {
        super(captureOutput, captureErr);
        this.programArgs = programArgs;
        this.mainClass = mainClass;
        this.inheritClasspath = inheritClasspath;
        if (xtraClasspath != null) {
            this.xtraClasspath.addAll(xtraClasspath);
        }
    }

    public void setProgramArgs(String s) {
        this.programArgs = s;
    }

    public String getProgramArgs() {
        return this.programArgs;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<String> getXtraClassPath() {
        return this.xtraClasspath;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (programArgs: ");
        result.append(this.programArgs);
        result.append(", mainClass: ");
        result.append(this.mainClass);
        result.append(", xtraClasspath: ");
        result.append(this.xtraClasspath);
        result.append(')');
        return result.toString();
    }

    protected String getJavaExe() {
        String java = String.valueOf(System.getProperty("java.home")) + File.separatorChar + "bin" + File.separatorChar + "java";
        return java;
    }

    public Process start() throws IllegalArgumentException, IOException {
        System.err.println(System.getProperty("user.dir"));
        String cp = this.makeClasspath();
        String heap = " -Xmx800M ";
        String ea = this.enableAssertions ? " -ea " : "";
        String cmd = String.valueOf(this.getJavaExe()) + heap + cp + " " + this.makeLibPath() + " " + ea + this.getMainClass() + " " + this.getProgramArgs();
        Process p = this.spawnProcess(cmd);
        this.stdErrDrain = this.isCaptureErr() ? this.captureStdErr(p) : this.drainStdErr(p);
        this.stdOutDrain = this.isCaptureOutput() ? this.captureStdOut(p) : this.drainStdOut(p);
        return p;
    }

    private String makeLibPath() {
        String libPath = System.getProperty("java.library.path");
        if (libPath == null) {
            return "";
        }
        return "-Djava.library.path=" + libPath;
    }

    public void join() {
        Launcher.Drainer d;
        try {
            this.stdOutDrain.join();
            this.stdErrDrain.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new InternalError("Internal error in JavaLauncher.join()");
        }
        if (this.isCaptureErr()) {
            d = (Launcher.Drainer)this.stdErrDrain;
            this.setStdErr(d.getCapture().toByteArray());
        }
        if (this.isCaptureOutput()) {
            d = (Launcher.Drainer)this.stdOutDrain;
            this.setStdOut(d.getCapture().toByteArray());
        }
    }

    private String makeClasspath() {
        String cp;
        String string = cp = this.inheritClasspath ? System.getProperty("java.class.path") : "";
        if (this.getXtraClassPath() == null || this.getXtraClassPath().isEmpty()) {
            return " -classpath " + this.quoteStringIfNeeded(cp);
        }
        Iterator<String> it = this.getXtraClassPath().iterator();
        while (it.hasNext()) {
            cp = String.valueOf(cp) + File.pathSeparatorChar;
            cp = String.valueOf(cp) + it.next();
        }
        return " -classpath " + this.quoteStringIfNeeded(cp);
    }

    private String quoteStringIfNeeded(String s) {
        if ((s = s.trim()).indexOf(32) == -1) {
            return s;
        }
        if (s.charAt(s.length() - 1) == '\\' && s.charAt(s.length() - 2) != '\\') {
            s = String.valueOf(s) + '\\';
        }
        return String.valueOf('\"') + s + '\"';
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }
}

