/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dynamic;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;

public abstract class Launcher {
    protected File workingDir = null;
    protected Map env = null;
    protected byte[] stdOut = null;
    protected byte[] stdErr = null;
    private byte[] input = null;
    private final boolean captureOutput;
    private final boolean captureErr;

    protected Launcher() {
        this.captureOutput = false;
        this.captureErr = false;
    }

    protected Launcher(boolean captureOutput, boolean captureErr) {
        this.captureOutput = captureOutput;
        this.captureErr = true;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File newWorkingDir) {
        this.workingDir = newWorkingDir;
    }

    public Map getEnv() {
        return this.env;
    }

    public void setEnv(Map newEnv) {
        this.env = newEnv;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (workingDir: ");
        result.append(this.workingDir);
        result.append(", env: ");
        result.append(this.env);
        result.append(')');
        return result.toString();
    }

    protected Process spawnProcess(String cmd) throws IllegalArgumentException, IOException {
        if (cmd == null) {
            throw new IllegalArgumentException("cmd cannot be null");
        }
        System.out.println("spawning process " + cmd);
        String[] ev = this.getEnv() == null ? null : this.buildEnv(this.getEnv());
        Process p = Runtime.getRuntime().exec(cmd, ev, this.getWorkingDir());
        return p;
    }

    private String[] buildEnv(Map ev) {
        String[] result = new String[ev.size()];
        int i = 0;
        for (Map.Entry e : ev.entrySet()) {
            result[i++] = e.getKey() + "=" + e.getValue();
        }
        return result;
    }

    protected Thread drainStdOut(Process p) {
        final BufferedInputStream out = new BufferedInputStream(p.getInputStream());
        Drainer result = new Drainer(p){

            void drain() throws IOException {
                Launcher.this.drainAndPrint(out, System.out);
            }
        };
        result.start();
        return result;
    }

    protected Drainer captureStdOut(Process p) {
        final BufferedInputStream out = new BufferedInputStream(p.getInputStream());
        final ByteArrayOutputStream b = new ByteArrayOutputStream();
        Drainer result = new Drainer(p){

            void drain() throws IOException {
                Launcher.this.drainAndCatch(out, b);
            }
        };
        result.setCapture(b);
        result.start();
        return result;
    }

    protected Thread drainStdErr(Process p) {
        final BufferedInputStream err = new BufferedInputStream(p.getErrorStream());
        Drainer result = new Drainer(p){

            void drain() throws IOException {
                Launcher.this.drainAndPrint(err, System.err);
            }
        };
        result.start();
        return result;
    }

    protected Drainer captureStdErr(Process p) {
        final BufferedInputStream out = new BufferedInputStream(p.getErrorStream());
        final ByteArrayOutputStream b = new ByteArrayOutputStream();
        Drainer result = new Drainer(p){

            void drain() throws IOException {
                Launcher.this.drainAndCatch(out, b);
            }
        };
        result.setCapture(b);
        result.start();
        return result;
    }

    private void drainAndPrint(BufferedInputStream s, PrintStream p) throws IOException {
        while (s.available() > 0) {
            byte[] data = new byte[s.available()];
            s.read(data);
            p.print(new String(data));
        }
    }

    private void drainAndCatch(BufferedInputStream s, ByteArrayOutputStream b) throws IOException {
        while (s.available() > 0) {
            byte[] data = new byte[s.available()];
            int nRead = s.read(data);
            b.write(data, 0, nRead);
        }
    }

    public boolean isCaptureOutput() {
        return this.captureOutput;
    }

    public boolean isCaptureErr() {
        return this.captureErr;
    }

    public byte[] getStdOut() {
        return this.stdOut;
    }

    public byte[] getStderr() {
        return this.stdErr;
    }

    protected void setStdOut(byte[] newOutput) {
        this.stdOut = newOutput;
    }

    protected void setStdErr(byte[] newErr) {
        this.stdErr = newErr;
    }

    public byte[] getInput() {
        return this.input;
    }

    public void setInput(byte[] input) {
        this.input = input;
    }

    abstract class Drainer
    extends Thread {
        private final Process p;
        private ByteArrayOutputStream capture;

        abstract void drain() throws IOException;

        Drainer(Process p) {
            this.p = p;
        }

        public void run() {
            try {
                boolean repeat = true;
                while (repeat) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.drain();
                    try {
                        this.p.exitValue();
                        repeat = false;
                        this.drain();
                        System.out.println("process terminated with exit code " + this.p.exitValue());
                    }
                    catch (IllegalThreadStateException e) {
                        repeat = true;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public ByteArrayOutputStream getCapture() {
            return this.capture;
        }

        public void setCapture(ByteArrayOutputStream capture) {
            this.capture = capture;
        }
    }
}

