/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.eclipse;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.eclipse.util.EclipseProjectPath;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaAnalysisAction
implements IObjectActionDelegate,
IRunnableWithProgress {
    private ISelection currentSelection;
    private final AnalysisCache cache;

    public AbstractJavaAnalysisAction(AnalysisCache cache) {
        this.cache = cache;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected AnalysisScope computeScope() throws JavaModelException, IOException {
        IStructuredSelection selection = (IStructuredSelection)this.currentSelection;
        Collection projectPaths = HashSetFactory.make();
        for (Object object : selection) {
            if (object instanceof IJavaElement) {
                IJavaElement e = (IJavaElement)object;
                IJavaProject jp = e.getJavaProject();
                projectPaths.add(EclipseProjectPath.make(ResourcesPlugin.getWorkspace().getRoot().getLocation(), jp));
                continue;
            }
            Assertions.UNREACHABLE(object.getClass());
        }
        AnalysisScope scope = this.mergeProjectPaths(projectPaths);
        return scope;
    }

    protected Collection<IJavaProject> computeJavaProjects() {
        IStructuredSelection selection = (IStructuredSelection)this.currentSelection;
        Collection projects = HashSetFactory.make();
        for (Object object : selection) {
            if (object instanceof IJavaElement) {
                IJavaElement e = (IJavaElement)object;
                IJavaProject jp = e.getJavaProject();
                projects.add(jp);
                continue;
            }
            Assertions.UNREACHABLE(object.getClass());
        }
        return projects;
    }

    private AnalysisScope mergeProjectPaths(Collection<EclipseProjectPath> projectPaths) {
        AnalysisScope scope = AnalysisScope.createAnalysisScope(Collections.singleton(Language.JAVA));
        Collection seen = HashSetFactory.make();
        this.buildScope(ClassLoaderReference.Application, projectPaths, scope, seen);
        this.buildScope(ClassLoaderReference.Extension, projectPaths, scope, seen);
        this.buildScope(ClassLoaderReference.Primordial, projectPaths, scope, seen);
        return scope;
    }

    private void buildScope(ClassLoaderReference loader, Collection<EclipseProjectPath> projectPaths, AnalysisScope scope, Collection<Module> seen) {
        for (EclipseProjectPath path : projectPaths) {
            AnalysisScope pScope = path.toAnalysisScope(null);
            for (Module m : pScope.getModules(loader)) {
                if (seen.contains(m)) continue;
                seen.add(m);
                scope.addToScope(loader, m);
            }
        }
    }

    public void run(IAction action) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.busyCursorWhile((IRunnableWithProgress)this);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    public ISelection getCurrentSelection() {
        return this.currentSelection;
    }

    public AnalysisCache getAnalysisCache() {
        return this.cache;
    }
}

