/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.eclipse.util;

import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseProjectPath {
    public static final Atom SOURCE = Atom.findOrCreateUnicodeAtom("Source");
    public static final ClassLoaderReference SOURCE_REF = new ClassLoaderReference(SOURCE, ClassLoaderReference.Java);
    private final IPath workspaceRootPath;
    private final IJavaProject project;
    private final Map<Loader, Set<Module>> binaryModules = HashMapFactory.make();
    private final Map<Loader, Set<Module>> sourceModules = HashMapFactory.make();
    private final Collection<IClasspathEntry> alreadyResolved = HashSetFactory.make();

    private EclipseProjectPath(IPath workspaceRootPath, IJavaProject project) throws JavaModelException, IOException {
        this.workspaceRootPath = workspaceRootPath;
        this.project = project;
        assert (workspaceRootPath != null);
        assert (project != null);
        Loader[] loaderArray = Loader.values();
        int n = loaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Loader loader = loaderArray[n2];
            MapUtil.findOrCreateSet(this.binaryModules, loader);
            MapUtil.findOrCreateSet(this.sourceModules, loader);
            ++n2;
        }
        this.resolveProjectClasspathEntries();
    }

    public static EclipseProjectPath make(IPath workspaceRootPath, IJavaProject project) throws JavaModelException, IOException {
        if (workspaceRootPath == null) {
            throw new IllegalArgumentException("workspaceRootPath is null");
        }
        return new EclipseProjectPath(workspaceRootPath, project);
    }

    private void resolveClasspathEntry(IClasspathEntry entry, Loader loader, String fileExtension) throws JavaModelException, IOException {
        IClasspathEntry e = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        if (this.alreadyResolved.contains(e)) {
            return;
        }
        this.alreadyResolved.add(e);
        if (e.getEntryKind() == 5) {
            IClasspathContainer cont = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)this.project);
            IClasspathEntry[] entries = cont.getClasspathEntries();
            this.resolveClasspathEntries(entries, cont.getKind() == 1 ? loader : Loader.PRIMORDIAL, fileExtension);
        } else if (e.getEntryKind() == 1) {
            JarFile j;
            File file = this.makeAbsolute(e.getPath()).toFile();
            try {
                j = new JarFile(file);
            }
            catch (ZipException z) {
                return;
            }
            Set<Module> s = MapUtil.findOrCreateSet(this.binaryModules, loader);
            s.add(file.isDirectory() ? new BinaryDirectoryTreeModule(file) : new JarFileModule(j));
        } else if (e.getEntryKind() == 3) {
            File file = this.makeAbsolute(e.getPath()).toFile();
            Set<Module> s = MapUtil.findOrCreateSet(this.sourceModules, Loader.SOURCE);
            s.add(new SourceDirectoryTreeModule(file, fileExtension));
            if (e.getOutputLocation() != null) {
                File output = this.makeAbsolute(e.getOutputLocation()).toFile();
                s = MapUtil.findOrCreateSet(this.binaryModules, loader);
                s.add(new BinaryDirectoryTreeModule(output));
            }
        } else if (e.getEntryKind() == 2) {
            IPath projectPath = this.makeAbsolute(e.getPath());
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = ws.getRoot();
            IProject project = (IProject)root.getContainerForLocation(projectPath);
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    this.resolveClasspathEntries(javaProject.getRawClasspath(), loader, fileExtension);
                    File output = this.makeAbsolute(javaProject.getOutputLocation()).toFile();
                    Set<Module> s = MapUtil.findOrCreateSet(this.binaryModules, loader);
                    s.add(new BinaryDirectoryTreeModule(output));
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
                Assertions.UNREACHABLE();
            }
        } else {
            throw new RuntimeException("unexpected entry " + e);
        }
    }

    protected void resolveClasspathEntries(IClasspathEntry[] entries, Loader loader, String fileExtension) throws JavaModelException, IOException {
        int i = 0;
        while (i < entries.length) {
            this.resolveClasspathEntry(entries[i], loader, fileExtension);
            ++i;
        }
    }

    protected IPath makeAbsolute(IPath p) {
        if (p.toFile().exists()) {
            return p;
        }
        return this.workspaceRootPath.append(p);
    }

    public void resolveProjectClasspathEntries() throws JavaModelException, IOException {
        this.resolveClasspathEntries(this.project.getRawClasspath(), Loader.EXTENSION, null);
    }

    public void resolveProjectClasspathEntries(String fileExtension) throws JavaModelException, IOException {
        this.resolveClasspathEntries(this.project.getRawClasspath(), Loader.EXTENSION, fileExtension);
    }

    public AnalysisScope toAnalysisScope(ClassLoader classLoader, File exclusionsFile) {
        try {
            Set<Module> s = MapUtil.findOrCreateSet(this.binaryModules, Loader.APPLICATION);
            s.add(new BinaryDirectoryTreeModule(this.makeAbsolute(this.project.getOutputLocation()).toFile()));
            AnalysisScope scope = AnalysisScopeReader.read("SyntheticJ2SEModel.txt", exclusionsFile, classLoader);
            Loader[] loaderArray = Loader.values();
            int n = loaderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Loader loader = loaderArray[n2];
                for (Module m : this.binaryModules.get((Object)loader)) {
                    scope.addToScope(loader.ref, m);
                }
                for (Module m : this.sourceModules.get((Object)loader)) {
                    scope.addToScope(loader.ref, m);
                }
                ++n2;
            }
            return scope;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public AnalysisScope toAnalysisScope(File exclusionsFile) {
        return this.toAnalysisScope(this.getClass().getClassLoader(), exclusionsFile);
    }

    public Collection<Module> getModules(Loader loader, boolean binary) {
        if (binary) {
            return Collections.unmodifiableCollection((Collection)this.binaryModules.get((Object)loader));
        }
        return Collections.unmodifiableCollection((Collection)this.sourceModules.get((Object)loader));
    }

    public String toString() {
        return this.toAnalysisScope(null).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Loader {
        APPLICATION(ClassLoaderReference.Application),
        EXTENSION(ClassLoaderReference.Extension),
        PRIMORDIAL(ClassLoaderReference.Primordial),
        SOURCE(SOURCE_REF);

        private ClassLoaderReference ref;

        private Loader(ClassLoaderReference ref) {
            this.ref = ref;
        }
    }
}

