/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.eclipse.util;

import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtUtil {
    public static String getFilePath(IJavaElement javaElt) {
        if (javaElt == null) {
            throw new IllegalArgumentException("javaElt is null");
        }
        String filePath = javaElt.getPath().toString();
        return filePath;
    }

    public static String getPackageName(ICompilationUnit cu) {
        if (cu == null) {
            throw new IllegalArgumentException("cu is null");
        }
        try {
            IPackageDeclaration[] pkgDecl = cu.getPackageDeclarations();
            if (pkgDecl != null && pkgDecl.length > 0) {
                String packageName = pkgDecl[0].getElementName();
                return packageName;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return "";
    }

    public static String getFullyQualifiedClassName(IType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        ICompilationUnit cu = (ICompilationUnit)type.getParent();
        String packageName = JdtUtil.getPackageName(cu);
        String className = type.getElementName();
        String fullyQName = String.valueOf(packageName) + "." + className;
        return fullyQName;
    }

    public static String getClassName(IType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        String className = type.getElementName();
        return className;
    }

    public static String getJdtHandleString(IJavaElement javaElt) {
        if (javaElt == null) {
            throw new IllegalArgumentException("javaElt is null");
        }
        return javaElt.getHandleIdentifier();
    }

    public static IJavaElement createJavaElementFromJdtHandle(String jdtHandle) {
        return JavaCore.create((String)jdtHandle);
    }

    public static IType[] getClasses(ICompilationUnit cu) {
        if (cu == null) {
            throw new IllegalArgumentException("cu is null");
        }
        try {
            return cu.getAllTypes();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IJavaProject getProject(IJavaElement javaElt) {
        if (javaElt == null) {
            throw new IllegalArgumentException("javaElt is null");
        }
        IJavaProject javaProject = javaElt.getJavaProject();
        return javaProject;
    }

    public static String getProjectName(IJavaProject javaProject) {
        if (javaProject == null) {
            throw new IllegalArgumentException("javaProject is null");
        }
        return javaProject.getElementName();
    }

    public static String getHumanReadableType(String typeSignature) {
        String simpleName = Signature.getSignatureSimpleName((String)typeSignature);
        return simpleName;
    }

    public static IJavaProject getJavaProject(IFile appJar) {
        if (appJar == null) {
            throw new IllegalArgumentException("appJar is null");
        }
        String projectName = appJar.getProject().getName();
        return JdtUtil.getJavaProject(projectName);
    }

    public static IJavaProject getJavaProject(String projectName) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
        IJavaProject javaProject = javaModel.getJavaProject(projectName);
        return javaProject;
    }

    public static Collection<IJavaProject> getWorkspaceJavaProjects() {
        Collection result = HashSetFactory.make();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            try {
                IJavaProject jp;
                if (p.hasNature("org.eclipse.jdt.core.javanature") && (jp = JavaCore.create((IProject)p)) != null) {
                    result.add(jp);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return result;
    }

    public static IType findJavaClassInProjects(String fullyQualifiedName, Collection<IJavaProject> projects) throws IllegalArgumentException {
        if (projects == null) {
            throw new IllegalArgumentException("projects == null");
        }
        for (IJavaProject project : projects) {
            try {
                IType t = project.findType(fullyQualifiedName);
                if (t == null) continue;
                return t;
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        System.err.println("failed to find " + fullyQualifiedName);
        return null;
    }

    public static IType findJavaClassInResources(String className, Collection<IResource> resources) {
        Collection projects = HashSetFactory.make();
        for (IResource r : resources) {
            projects.add(JavaCore.create((IResource)r).getJavaProject());
        }
        return JdtUtil.findJavaClassInProjects(className, projects);
    }

    public static IMethod findJavaMethodInProjects(String klass, String selector, Collection<IJavaProject> projects) {
        String[] paramTypes;
        IType type = null;
        try {
            type = JdtUtil.findJavaClassInProjects(klass, projects);
        }
        catch (Throwable t) {
            return null;
        }
        if (type == null) {
            return null;
        }
        String name = JdtUtil.parseForName(selector, type);
        IMethod m = type.getMethod(name, paramTypes = JdtUtil.parseForParameterTypes(selector));
        IMethod[] methods = type.findMethods(m);
        if (methods != null && methods.length == 1) {
            return methods[0];
        }
        try {
            ArrayList<IMethod> matches = new ArrayList<IMethod>();
            Collection<String> typeParameterNames = JdtUtil.getTypeParameterNames(type);
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    IMethod x = iMethodArray[n2];
                    if (x.getElementName().equals(name) && x.getParameterTypes().length == paramTypes.length) {
                        int i = 0;
                        while (i < x.getParameterTypes().length) {
                            String s1 = Signature.getTypeErasure((String)Signature.getSignatureSimpleName((String)x.getParameterTypes()[i]));
                            String s2 = Signature.getTypeErasure((String)Signature.getSignatureSimpleName((String)paramTypes[i]));
                            if (typeParameterNames.contains(s1) || s1.equals(s2)) {
                                ++i;
                                continue;
                            }
                            break block11;
                        }
                        matches.add(x);
                    }
                }
                ++n2;
            }
            if (matches.size() == 1) {
                return (IMethod)matches.get(0);
            }
            System.err.println("findJavaMethodInWorkspace FAILED TO MATCH " + m);
            return null;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Collection<String> getTypeParameterNames(IType type) throws IllegalArgumentException, JavaModelException {
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        ITypeParameter[] tp = type.getTypeParameters();
        Collection typeParameterNames = HashSetFactory.make(tp.length);
        ITypeParameter[] iTypeParameterArray = tp;
        int n = tp.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeParameter p = iTypeParameterArray[n2];
            typeParameterNames.add(p.getElementName());
            ++n2;
        }
        return typeParameterNames;
    }

    public static String parseForName(String selector, IType type) {
        if (selector == null) {
            throw new IllegalArgumentException("selector is null");
        }
        String result = selector.substring(0, selector.indexOf(40));
        if (result.equals("<init>")) {
            return type.getElementName();
        }
        return result;
    }

    public static final String[] parseForParameterTypes(String selector) throws IllegalArgumentException {
        try {
            if (selector == null) {
                throw new IllegalArgumentException("selector is null");
            }
            String d = selector.substring(selector.indexOf(40));
            if (d.length() <= 2) {
                throw new IllegalArgumentException("invalid descriptor: " + d);
            }
            if (d.charAt(0) != '(') {
                throw new IllegalArgumentException("invalid descriptor: " + d);
            }
            ArrayList<String> sigs = new ArrayList<String>(10);
            int i = 1;
            block15: while (true) {
                char c;
                int off;
                switch (d.charAt(i++)) {
                    case 'V': {
                        sigs.add(TypeReference.VoidName.toString());
                        continue block15;
                    }
                    case 'Z': {
                        sigs.add(TypeReference.BooleanName.toString());
                        continue block15;
                    }
                    case 'B': {
                        sigs.add(TypeReference.ByteName.toString());
                        continue block15;
                    }
                    case 'S': {
                        sigs.add(TypeReference.ShortName.toString());
                        continue block15;
                    }
                    case 'I': {
                        sigs.add(TypeReference.IntName.toString());
                        continue block15;
                    }
                    case 'J': {
                        sigs.add(TypeReference.LongName.toString());
                        continue block15;
                    }
                    case 'F': {
                        sigs.add(TypeReference.FloatName.toString());
                        continue block15;
                    }
                    case 'D': {
                        sigs.add(TypeReference.DoubleName.toString());
                        continue block15;
                    }
                    case 'C': {
                        sigs.add(TypeReference.CharName.toString());
                        continue block15;
                    }
                    case '[': {
                        off = i - 1;
                        while (d.charAt(i) == '[') {
                            ++i;
                        }
                        if (d.charAt(i++) == 'L') {
                            while (d.charAt(i++) != ';') {
                            }
                            sigs.add(d.substring(off, i).replaceAll("/", "."));
                            continue block15;
                        }
                        sigs.add(d.substring(off, i));
                        continue block15;
                    }
                    case ')': {
                        return JdtUtil.toArray(sigs);
                    }
                }
                off = i - 1;
                while ((c = d.charAt(i++)) != ',' && c != ')') {
                }
                sigs.add("L" + d.substring(off, i - 1) + ";");
                if (c == ')') break;
            }
            return JdtUtil.toArray(sigs);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("error parsing selector " + selector);
        }
    }

    private static String[] toArray(ArrayList<String> sigs) {
        int size = sigs.size();
        if (size == 0) {
            return new String[0];
        }
        Iterator<String> it = sigs.iterator();
        String[] result = new String[size];
        int j = 0;
        while (j < size) {
            result[j] = it.next();
            ++j;
        }
        return result;
    }

    @Deprecated
    public static IMethod findJavaMethodInWorkspaceBrokenForInnerClasses(String methodSig) {
        System.err.println("Search for " + methodSig);
        SearchPattern p = SearchPattern.createPattern((String)methodSig, (int)1, (int)0, (int)0);
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        SearchEngine engine = new SearchEngine();
        final Collection kludge = HashSetFactory.make();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                kludge.add((IJavaElement)match.getElement());
            }
        };
        try {
            engine.search(p, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (kludge.size() == 1) {
            return (IMethod)kludge.iterator().next();
        }
        System.err.println("RETURNED " + kludge.size() + " " + kludge);
        return null;
    }

    public static Collection<IMethod> findMethods(IJavaElement elt) {
        if (elt instanceof ICompilationUnit) {
            Collection result = HashSetFactory.make();
            IType[] iTypeArray = JdtUtil.getClasses((ICompilationUnit)elt);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                try {
                    IMethod[] iMethodArray = type.getMethods();
                    int n3 = iMethodArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMethod m = iMethodArray[n4];
                        result.add(m);
                        ++n4;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            return result;
        }
        final Collection result = HashSetFactory.make();
        SearchPattern p = SearchPattern.createPattern((String)"*", (int)1, (int)0, (int)2);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{elt}, (int)1);
        SearchEngine engine = new SearchEngine();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                result.add((IMethod)match.getElement());
            }
        };
        try {
            engine.search(p, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }
}

