/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.eclipse.util;

import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressMaster
implements IProgressMonitor {
    private final IProgressMonitor delegate;
    private volatile boolean timedOut = false;
    private int msPerWorkItem = -1;
    private Timeout currentNanny;

    private ProgressMaster(IProgressMonitor monitor) {
        this.delegate = monitor;
    }

    public static ProgressMaster make(IProgressMonitor monitor) {
        assert (monitor != null);
        return new ProgressMaster(monitor);
    }

    public void beginTask(String name, int totalWork) {
        this.delegate.beginTask(name, totalWork);
        this.startNanny();
    }

    private synchronized void startNanny() {
        this.killNanny();
        if (this.msPerWorkItem >= 1) {
            this.currentNanny = new Timeout(this.msPerWorkItem);
            this.currentNanny.start();
        }
    }

    public void reset() {
        this.killNanny();
        this.setCanceled(false);
        this.timedOut = false;
    }

    public boolean lastItemTimedOut() {
        return this.timedOut;
    }

    public void done() {
        this.killNanny();
        this.delegate.done();
    }

    private synchronized void killNanny() {
        if (this.currentNanny != null) {
            this.currentNanny.interrupt();
            try {
                this.currentNanny.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.currentNanny = null;
        }
    }

    public void internalWorked(double work) {
        this.delegate.internalWorked(work);
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled() || this.timedOut;
    }

    public void setCanceled(boolean value) {
        this.killNanny();
    }

    public void setTaskName(String name) {
        this.delegate.setTaskName(name);
    }

    public void subTask(String name) {
        this.delegate.subTask(name);
    }

    public void worked(int work) {
        this.killNanny();
        this.delegate.worked(work);
        this.startNanny();
    }

    public int getMillisPerWorkItem() {
        return this.msPerWorkItem;
    }

    public void setMillisPerWorkItem(int msPerWorkItem) {
        this.msPerWorkItem = msPerWorkItem;
    }

    private class Timeout
    extends Thread {
        private final int sleepMillis;

        public void run() {
            try {
                Thread.sleep(this.sleepMillis);
                if (this.isInterrupted()) {
                    return;
                }
                ProgressMaster.this.timedOut = true;
            }
            catch (InterruptedException e) {
                return;
            }
        }

        Timeout(int sleepMillis) {
            assert (sleepMillis >= 1);
            this.sleepMillis = sleepMillis;
        }
    }
}

