/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.escape;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.escape.LocalLiveRangeAnalysis;
import com.ibm.wala.escape.TrivialMethodEscape;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.graph.traverse.DFSDiscoverTimeIterator;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.warnings.WalaException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FILiveObjectAnalysis
implements ILiveObjectAnalysis {
    private final CallGraph callGraph;
    private final HeapGraph heapGraph;
    private final Map<InstanceKey, Set> liveNodes = HashMapFactory.make();
    private final Set<InstanceKey> liveEverywhere = HashSetFactory.make();
    private final boolean expensiveIntraproceduralAnalysis;

    public FILiveObjectAnalysis(CallGraph callGraph, HeapGraph heapGraph, boolean expensiveIntraproceduralAnalysis) {
        this.callGraph = callGraph;
        this.heapGraph = heapGraph;
        this.expensiveIntraproceduralAnalysis = expensiveIntraproceduralAnalysis;
    }

    public boolean mayBeLive(CGNode allocMethod, int allocPC, CGNode m, int instructionIndex) throws IllegalArgumentException, WalaException {
        if (allocMethod == null) {
            throw new IllegalArgumentException("allocMethod == null");
        }
        NewSiteReference site = TrivialMethodEscape.findAlloc(allocMethod, allocPC);
        InstanceKey ik = this.heapGraph.getHeapModel().getInstanceKeyForAllocation(allocMethod, site);
        return this.mayBeLive(ik, m, instructionIndex);
    }

    public boolean mayBeLive(InstanceKey ik, CGNode m, int instructionIndex) {
        if (this.liveEverywhere.contains(ik)) {
            return true;
        }
        Set live = this.liveNodes.get(ik);
        if (live != null) {
            if (live.contains(m)) {
                if (instructionIndex == -1) {
                    return true;
                }
                if (this.mayBeLiveInSomeCaller(ik, m)) {
                    return true;
                }
                if (this.expensiveIntraproceduralAnalysis) {
                    return this.mayBeLiveIntraprocedural(ik, m, instructionIndex);
                }
                return true;
            }
            return false;
        }
        live = this.computeLiveNodes(ik);
        this.liveNodes.put(ik, live);
        return this.mayBeLive(ik, m, instructionIndex);
    }

    private boolean mayBeLiveInSomeCaller(InstanceKey ik, CGNode m) {
        Iterator<CGNode> it = this.callGraph.getPredNodes(m);
        while (it.hasNext()) {
            CGNode n = it.next();
            if (!this.mayBeLive(ik, n, -1)) continue;
            return true;
        }
        return false;
    }

    private boolean mayBeLiveIntraprocedural(InstanceKey ik, CGNode m, int instructionIndex) {
        IR ir = m.getIR();
        DefUse du = m.getDU();
        DFSDiscoverTimeIterator it = DFS.iterateDiscoverTime(GraphInverter.invert(this.heapGraph), ik);
        while (it.hasNext()) {
            LocalPointerKey lpk;
            Object p = it.next();
            if (!(p instanceof LocalPointerKey) || !(lpk = (LocalPointerKey)p).getNode().equals(m) || !LocalLiveRangeAnalysis.isLive(lpk.getValueNumber(), instructionIndex, ir, du)) continue;
            return true;
        }
        return false;
    }

    private Set computeLiveNodes(InstanceKey ik) {
        Set localRootNodes = HashSetFactory.make();
        DFSDiscoverTimeIterator it = DFS.iterateDiscoverTime(GraphInverter.invert(this.heapGraph), ik);
        while (it.hasNext()) {
            Object node = it.next();
            if (node instanceof StaticFieldKey) {
                this.liveEverywhere.add(ik);
                return Collections.EMPTY_SET;
            }
            if (node instanceof AbstractLocalPointerKey) {
                AbstractLocalPointerKey local = (AbstractLocalPointerKey)node;
                localRootNodes.add(local.getNode());
                continue;
            }
            if (!(node instanceof PropagationCallGraphBuilder.TypedPointerKey)) continue;
            PropagationCallGraphBuilder.TypedPointerKey t = (PropagationCallGraphBuilder.TypedPointerKey)node;
            if ((node = t.getBase()) instanceof AbstractLocalPointerKey) {
                AbstractLocalPointerKey local = (AbstractLocalPointerKey)node;
                localRootNodes.add(local.getNode());
                continue;
            }
            Assertions.UNREACHABLE("unexpected base of TypedPointerKey: " + node.getClass() + " " + node);
        }
        return DFS.getReachableNodes(this.callGraph, localRootNodes);
    }

    public boolean mayBeLive(InstanceKey ik, CGNode m, IntSet instructionIndices) {
        if (instructionIndices == null) {
            throw new IllegalArgumentException("instructionIndices is null");
        }
        IntIterator it = instructionIndices.intIterator();
        while (it.hasNext()) {
            int i = it.next();
            if (!this.mayBeLive(ik, m, i)) continue;
            return true;
        }
        return false;
    }
}

