/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.escape;

import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalLiveRangeAnalysis {
    public static boolean isLive(int v, int instructionIndex, IR ir, DefUse du) {
        if (du == null) {
            throw new IllegalArgumentException("du is null");
        }
        if (du.getNumberOfUses(v) == 0) {
            return false;
        }
        if (instructionIndex < 0) {
            Assertions.UNREACHABLE();
        }
        ISSABasicBlock queryBlock = LocalLiveRangeAnalysis.findBlock(ir, instructionIndex);
        SSAInstruction def = du.getDef(v);
        final SSACFG.BasicBlock defBlock = def == null ? null : LocalLiveRangeAnalysis.findBlock(ir, def);
        Collection<SSACFG.BasicBlock> uses = LocalLiveRangeAnalysis.findBlocks(ir, du.getUses(v));
        Filter notDef = new Filter(){

            public boolean accepts(Object o) {
                return defBlock == null || !defBlock.equals(o);
            }
        };
        if (defBlock != null && defBlock.equals(queryBlock)) {
            return true;
        }
        Collection<ISSABasicBlock> reached = DFS.getReachableNodes(ir.getControlFlowGraph(), (Collection)Collections.singleton(queryBlock), notDef);
        uses.retainAll(reached);
        if (uses.isEmpty()) {
            return false;
        }
        if (uses.size() == 1 && uses.iterator().next().equals(queryBlock)) {
            if (instructionIndex == queryBlock.getLastInstructionIndex()) {
                return ir.getInstructions()[instructionIndex] instanceof SSAReturnInstruction;
            }
            return true;
        }
        return true;
    }

    private static Collection<SSACFG.BasicBlock> findBlocks(IR ir, Iterator<SSAInstruction> statements) {
        Collection s = Iterator2Collection.toCollection(statements);
        Collection result = HashSetFactory.make();
        block0: for (SSACFG.BasicBlock b : ir.getControlFlowGraph()) {
            for (SSAInstruction x : b) {
                if (!s.contains(x)) continue;
                result.add(b);
                continue block0;
            }
        }
        if (result.isEmpty()) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    private static SSACFG.BasicBlock findBlock(IR ir, SSAInstruction s) {
        if (s == null) {
            Assertions.UNREACHABLE();
        }
        for (SSACFG.BasicBlock b : ir.getControlFlowGraph()) {
            for (SSAInstruction x : b) {
                if (!s.equals(x)) continue;
                return b;
            }
        }
        Assertions.UNREACHABLE("no block for " + s + " in IR " + ir);
        return null;
    }

    private static ISSABasicBlock findBlock(IR ir, int i) {
        for (SSACFG.BasicBlock b : ir.getControlFlowGraph()) {
            if (i < b.getFirstInstructionIndex() || i > b.getLastInstructionIndex()) continue;
            return b;
        }
        Assertions.UNREACHABLE("no block for " + i + " in IR " + ir);
        return null;
    }
}

