/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.fixedpoint.impl;

import com.ibm.wala.fixedpoint.impl.AbstractOperator;
import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixedpoint.impl.BasicNullaryStatement;
import com.ibm.wala.fixedpoint.impl.GeneralStatement;
import com.ibm.wala.fixedpoint.impl.NullaryOperator;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.fixedpoint.impl.UnaryStatement;
import com.ibm.wala.fixedpoint.impl.Worklist;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.fixpoint.IFixedPointSolver;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.util.debug.Trace;
import com.ibm.wala.util.debug.VerboseAction;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFixedPointSolver<T extends IVariable>
implements IFixedPointSolver<T>,
FixedPointConstants,
VerboseAction {
    static final boolean DEBUG = false;
    public static final boolean verbose = "true".equals(System.getProperty("com.ibm.wala.fixedpoint.impl.verbose"));
    public static final int DEFAULT_VERBOSE_INTERVAL = 100000;
    static final boolean MORE_VERBOSE = true;
    public static final int DEFAULT_PERIODIC_MAINTENANCE_INTERVAL = 100000;
    private int minSizeForTopSort = 0;
    private double topologicalGrowthFactor = 0.1;
    private int maxEvalBetweenTopo = 500000;
    private int evaluationsAtLastOrdering = 0;
    int topologicalCounter = 0;
    int nextOrderNumber = 1;
    private int nEvaluated = 0;
    private int nCreated = 0;
    protected Worklist workList = new Worklist();
    private boolean firstSolve = true;

    public void initForFirstSolve() {
        this.orderStatements();
        this.initializeVariables();
        this.initializeWorkList();
        this.firstSolve = false;
    }

    public boolean emptyWorkList() {
        return this.workList.isEmpty();
    }

    @Override
    public boolean solve() {
        boolean globalChange = false;
        if (this.firstSolve) {
            this.initForFirstSolve();
        }
        while (!this.workList.isEmpty()) {
            this.orderStatements();
            AbstractStatement s = this.workList.takeStatement();
            byte code = s.evaluate();
            if (verbose) {
                ++this.nEvaluated;
                if (this.nEvaluated % this.getVerboseInterval() == 0) {
                    this.performVerboseAction();
                }
                if (this.nEvaluated % this.getPeriodicMaintainInterval() == 0) {
                    this.periodicMaintenance();
                }
            }
            if (AbstractFixedPointSolver.isChanged(code)) {
                globalChange = true;
                this.updateWorkList(s);
            }
            if (!AbstractFixedPointSolver.isFixed(code)) continue;
            this.removeStatement(s);
        }
        return globalChange;
    }

    @Override
    public void performVerboseAction() {
        System.err.println("Evaluated " + this.nEvaluated);
        System.err.println("Created   " + this.nCreated);
        System.err.println("Worklist  " + this.workList.size());
        AbstractStatement s = this.workList.takeStatement();
        System.err.println("Peek      " + AbstractFixedPointSolver.lineBreak(s.toString(), 132));
        if (s instanceof VerboseAction) {
            ((VerboseAction)((Object)s)).performVerboseAction();
        }
        this.workList.insertStatement(s);
        Trace.println("BEGIN VERBOSE ACTION");
        Trace.println("Evaluated " + this.nEvaluated);
        Trace.println("Created   " + this.nCreated);
        Trace.println("Worklist  " + this.workList.size());
    }

    public static String lineBreak(String string, int wrap) {
        if (string == null) {
            throw new IllegalArgumentException("string is null");
        }
        if (string.length() > wrap) {
            StringBuffer result = new StringBuffer();
            int start = 0;
            while (start < string.length()) {
                int end = Math.min(start + wrap, string.length());
                result.append(string.substring(start, end));
                result.append("\n  ");
                start = end;
            }
            return result.toString();
        }
        return string;
    }

    public void removeStatement(AbstractStatement<T, ?> s) {
        this.getFixedPointSystem().removeStatement(s);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Fixed Point Sytem:\n");
        Iterator it = this.getStatements();
        while (it.hasNext()) {
            result.append(it.next()).append("\n");
        }
        return result.toString();
    }

    public Iterator getStatements() {
        return this.getFixedPointSystem().getStatements();
    }

    public void addToWorkList(AbstractStatement s) {
        this.workList.insertStatement(s);
    }

    public void addAllStatementsToWorkList() {
        Iterator i = this.getStatements();
        while (i.hasNext()) {
            AbstractStatement eq = (AbstractStatement)i.next();
            this.addToWorkList(eq);
        }
    }

    public void changedVariable(T v) {
        Iterator it = this.getFixedPointSystem().getStatementsThatUse(v);
        while (it.hasNext()) {
            AbstractStatement s = (AbstractStatement)it.next();
            this.addToWorkList(s);
        }
    }

    public void newStatement(T lhs, NullaryOperator<T> operator, boolean toWorkList, boolean eager) {
        if (lhs == null) {
            throw new IllegalArgumentException("lhs is null");
        }
        lhs.setOrderNumber(this.nextOrderNumber++);
        BasicNullaryStatement<T> s = new BasicNullaryStatement<T>(lhs, operator);
        if (this.getFixedPointSystem().containsStatement(s)) {
            return;
        }
        ++this.nCreated;
        this.getFixedPointSystem().addStatement(s);
        this.incorporateNewStatement(toWorkList, eager, s);
        ++this.topologicalCounter;
    }

    private void incorporateNewStatement(boolean toWorkList, boolean eager, AbstractStatement s) {
        if (eager) {
            byte code = s.evaluate();
            if (verbose) {
                ++this.nEvaluated;
                if (this.nEvaluated % this.getVerboseInterval() == 0) {
                    this.performVerboseAction();
                }
                if (this.nEvaluated % this.getPeriodicMaintainInterval() == 0) {
                    this.periodicMaintenance();
                }
            }
            if (AbstractFixedPointSolver.isChanged(code)) {
                this.updateWorkList(s);
            }
            if (AbstractFixedPointSolver.isFixed(code)) {
                this.removeStatement(s);
            }
        } else if (toWorkList) {
            this.addToWorkList(s);
        }
    }

    public boolean newStatement(T lhs, UnaryOperator<T> operator, T rhs, boolean toWorkList, boolean eager) {
        if (operator == null) {
            throw new IllegalArgumentException("operator is null");
        }
        UnaryStatement<T> s = operator.makeEquation(lhs, rhs);
        if (this.getFixedPointSystem().containsStatement(s)) {
            return false;
        }
        if (lhs != null) {
            lhs.setOrderNumber(this.nextOrderNumber++);
        }
        ++this.nCreated;
        this.getFixedPointSystem().addStatement(s);
        this.incorporateNewStatement(toWorkList, eager, s);
        ++this.topologicalCounter;
        return true;
    }

    public void newStatement(T lhs, AbstractOperator<T> operator, T op1, T op2, boolean toWorkList, boolean eager) {
        GeneralStatement<T> s = new GeneralStatement<T>(lhs, operator, op1, op2);
        if (this.getFixedPointSystem().containsStatement(s)) {
            return;
        }
        if (lhs != null) {
            lhs.setOrderNumber(this.nextOrderNumber++);
        }
        ++this.nCreated;
        this.getFixedPointSystem().addStatement(s);
        this.incorporateNewStatement(toWorkList, eager, s);
        ++this.topologicalCounter;
    }

    public void newStatement(T lhs, AbstractOperator<T> operator, T op1, T op2, T op3, boolean toWorkList, boolean eager) {
        if (lhs == null) {
            throw new IllegalArgumentException("lhs is null");
        }
        lhs.setOrderNumber(this.nextOrderNumber++);
        GeneralStatement<T> s = new GeneralStatement<T>(lhs, operator, op1, op2, op3);
        if (this.getFixedPointSystem().containsStatement(s)) {
            --this.nextOrderNumber;
            return;
        }
        ++this.nCreated;
        this.getFixedPointSystem().addStatement(s);
        this.incorporateNewStatement(toWorkList, eager, s);
        ++this.topologicalCounter;
    }

    public void newStatement(T lhs, AbstractOperator<T> operator, IVariable[] rhs, boolean toWorkList, boolean eager) {
        if (lhs != null) {
            lhs.setOrderNumber(this.nextOrderNumber++);
        }
        GeneralStatement<T> s = new GeneralStatement<T>(lhs, operator, rhs);
        if (this.getFixedPointSystem().containsStatement(s)) {
            --this.nextOrderNumber;
            return;
        }
        ++this.nCreated;
        this.getFixedPointSystem().addStatement(s);
        this.incorporateNewStatement(toWorkList, eager, s);
        ++this.topologicalCounter;
    }

    protected abstract void initializeVariables();

    protected abstract void initializeWorkList();

    private void updateWorkList(AbstractStatement<T, ?> s) {
        Object v = s.getLHS();
        if (v == null) {
            return;
        }
        this.changedVariable(v);
    }

    private void orderStatementsInternal() {
        if (verbose && this.nEvaluated > 0) {
            System.err.println("Reorder " + this.nEvaluated + " " + this.nCreated);
        }
        this.reorder();
        if (verbose && this.nEvaluated > 0) {
            System.err.println("Reorder finished " + this.nEvaluated + " " + this.nCreated);
        }
        this.topologicalCounter = 0;
        this.evaluationsAtLastOrdering = this.nEvaluated;
    }

    public void orderStatements() {
        if (this.nextOrderNumber > this.minSizeForTopSort && (double)this.topologicalCounter / (double)this.nextOrderNumber > this.topologicalGrowthFactor) {
            this.orderStatementsInternal();
            return;
        }
        if (this.nEvaluated - this.evaluationsAtLastOrdering > this.maxEvalBetweenTopo) {
            this.orderStatementsInternal();
            return;
        }
    }

    private void reorder() {
        LinkedList<AbstractStatement> temp = new LinkedList<AbstractStatement>();
        while (!this.workList.isEmpty()) {
            AbstractStatement eq = this.workList.takeStatement();
            temp.add(eq);
        }
        this.workList = new Worklist();
        this.getFixedPointSystem().reorder();
        for (AbstractStatement s : temp) {
            this.workList.insertStatement(s);
        }
    }

    public static boolean isChanged(byte code) {
        return (code & 1) != 0;
    }

    public static boolean isSideEffect(byte code) {
        return (code & 4) != 0;
    }

    public static boolean isFixed(byte code) {
        return (code & 2) != 0;
    }

    public int getMinSizeForTopSort() {
        return this.minSizeForTopSort;
    }

    public void setMinEquationsForTopSort(int i) {
        this.minSizeForTopSort = i;
    }

    public int getMaxEvalBetweenTopo() {
        return this.maxEvalBetweenTopo;
    }

    public double getTopologicalGrowthFactor() {
        return this.topologicalGrowthFactor;
    }

    public void setMaxEvalBetweenTopo(int i) {
        this.maxEvalBetweenTopo = i;
    }

    public void setTopologicalGrowthFactor(double d) {
        this.topologicalGrowthFactor = d;
    }

    public int getNumberOfEvaluations() {
        return this.nEvaluated;
    }

    public void incNumberOfEvaluations() {
        ++this.nEvaluated;
    }

    protected void periodicMaintenance() {
    }

    protected int getVerboseInterval() {
        return 100000;
    }

    protected int getPeriodicMaintainInterval() {
        return 100000;
    }
}

