/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.fixedpoint.impl;

import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixedpoint.impl.GeneralStatement;
import com.ibm.wala.fixedpoint.impl.NullaryStatement;
import com.ibm.wala.fixedpoint.impl.UnaryStatement;
import com.ibm.wala.fixpoint.IFixedPointStatement;
import com.ibm.wala.fixpoint.IFixedPointSystem;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.ReverseIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphIntegrity;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.impl.SparseNumberedGraph;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFixedPointSystem<T extends IVariable>
implements IFixedPointSystem<T> {
    static final boolean DEBUG = false;
    private final NumberedGraph<INodeWithNumber> graph;
    private final Set<GeneralStatement> equations = HashSetFactory.make();
    private final Set<IVariable> variables = HashSetFactory.make();

    public DefaultFixedPointSystem(int expectedOut) {
        this.graph = new SparseNumberedGraph<INodeWithNumber>(expectedOut);
    }

    public DefaultFixedPointSystem() {
        this(1);
    }

    public boolean equals(Object obj) {
        return this.graph.equals(obj);
    }

    public int hashCode() {
        return this.graph.hashCode();
    }

    public String toString() {
        return this.graph.toString();
    }

    @Override
    public void removeStatement(IFixedPointStatement s) {
        this.graph.removeNodeAndEdges(s);
    }

    @Override
    public Iterator<AbstractStatement> getStatements() {
        return new FilterIterator<AbstractStatement>(this.graph.iterator(), new Filter(){

            public boolean accepts(Object x) {
                return x instanceof AbstractStatement;
            }
        });
    }

    @Override
    public void addStatement(IFixedPointStatement statement) throws IllegalArgumentException, UnimplementedError {
        if (statement == null) {
            throw new IllegalArgumentException("statement == null");
        }
        if (statement instanceof UnaryStatement) {
            this.addStatement((UnaryStatement)statement);
        } else if (statement instanceof NullaryStatement) {
            this.addStatement((NullaryStatement)statement);
        } else if (statement instanceof GeneralStatement) {
            this.addStatement((GeneralStatement)statement);
        } else {
            Assertions.UNREACHABLE("unexpected: " + statement.getClass());
        }
    }

    public void addStatement(GeneralStatement s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        IVariable[] rhs = s.getRHS();
        Object lhs = s.getLHS();
        this.equations.add(s);
        this.graph.addNode(s);
        if (lhs != null) {
            this.variables.add((IVariable)lhs);
            this.graph.addNode((INodeWithNumber)lhs);
            this.graph.addEdge(s, (INodeWithNumber)lhs);
        }
        int i = 0;
        while (i < rhs.length) {
            IVariable v = rhs[i];
            IVariable variable = v;
            if (variable != null) {
                this.variables.add(variable);
                this.graph.addNode(variable);
                this.graph.addEdge(variable, s);
            }
            ++i;
        }
    }

    public void addStatement(UnaryStatement s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        Object lhs = s.getLHS();
        Object rhs = s.getRightHandSide();
        this.graph.addNode(s);
        if (lhs != null) {
            this.variables.add((IVariable)lhs);
            this.graph.addNode((INodeWithNumber)lhs);
            this.graph.addEdge(s, (INodeWithNumber)lhs);
        }
        this.variables.add((IVariable)rhs);
        this.graph.addNode((INodeWithNumber)rhs);
        this.graph.addEdge((INodeWithNumber)rhs, s);
    }

    public void addStatement(NullaryStatement s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        Object lhs = s.getLHS();
        this.graph.addNode(s);
        if (lhs != null) {
            this.variables.add((IVariable)lhs);
            this.graph.addNode((INodeWithNumber)lhs);
            this.graph.addEdge(s, (INodeWithNumber)lhs);
        }
    }

    public void addVariable(IVariable v) {
        this.variables.add(v);
        this.graph.addNode(v);
    }

    public AbstractStatement getStep(int number) {
        return (AbstractStatement)this.graph.getNode(number);
    }

    @Override
    public void reorder() {
        Iterator<INodeWithNumber> order = DefaultFixedPointSystem.makeSCCTopOrder(this.graph);
        int number = 0;
        while (order.hasNext()) {
            INodeWithNumber elt = order.next();
            if (!(elt instanceof IVariable)) continue;
            IVariable v = (IVariable)elt;
            v.setOrderNumber(number++);
        }
    }

    public static <T> Iterator<T> makeSCCTopOrder(Graph<T> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("graph == null");
        }
        Iterator finishTime = DFS.iterateFinishTime(graph);
        Iterator rev = ReverseIterator.reverse(finishTime);
        finishTime = null;
        Graph<T> G_T = GraphInverter.invert(graph);
        Iterator order = DFS.iterateFinishTime(G_T, rev);
        return order;
    }

    private void checkGraph() {
        try {
            GraphIntegrity.check(this.graph);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    @Override
    public Iterator getStatementsThatUse(IVariable v) {
        return this.graph.containsNode(v) ? this.graph.getSuccNodes(v) : (Iterator<INodeWithNumber>)EmptyIterator.instance();
    }

    @Override
    public Iterator getStatementsThatDef(IVariable v) {
        return this.graph.containsNode(v) ? this.graph.getPredNodes(v) : (Iterator<INodeWithNumber>)EmptyIterator.instance();
    }

    public IVariable getVariable(int n) {
        return (IVariable)this.graph.getNode(n);
    }

    @Override
    public int getNumberOfStatementsThatUse(IVariable v) {
        return this.graph.containsNode(v) ? this.graph.getSuccNodeCount(v) : 0;
    }

    @Override
    public int getNumberOfStatementsThatDef(IVariable v) {
        return this.graph.containsNode(v) ? this.graph.getPredNodeCount(v) : 0;
    }

    @Override
    public Iterator<IVariable> getVariables() {
        return new FilterIterator<IVariable>(this.graph.iterator(), new Filter(){

            public boolean accepts(Object x) {
                return x instanceof IVariable;
            }
        });
    }

    public int getNumberOfNodes() {
        return this.graph.getNumberOfNodes();
    }

    public Iterator<? extends INodeWithNumber> getPredNodes(INodeWithNumber n) {
        return this.graph.getPredNodes(n);
    }

    public int getPredNodeCount(INodeWithNumber n) {
        return this.graph.getPredNodeCount(n);
    }

    @Override
    public boolean containsStatement(IFixedPointStatement s) {
        return this.equations.contains(s);
    }

    @Override
    public boolean containsVariable(IVariable v) {
        return this.variables.contains(v);
    }
}

