/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.fixedpoint.impl;

import com.ibm.wala.fixedpoint.impl.AbstractOperator;
import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixpoint.IVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralStatement<T extends IVariable>
extends AbstractStatement<T, AbstractOperator<T>> {
    protected final T lhs;
    protected final IVariable[] rhs;
    private final int hashCode;
    private final AbstractOperator<T> operator;
    private static final int[] primes = new int[]{331, 337, 347, 1277};

    @Override
    public byte evaluate() {
        return this.operator.evaluate(this.lhs, this.rhs);
    }

    @Override
    public T getLHS() {
        return this.lhs;
    }

    @Override
    public boolean hasVariable(IVariable cell) {
        if (this.lhs == cell) {
            return true;
        }
        int i = 0;
        while (i < this.rhs.length) {
            if (this.rhs[i] == cell) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public GeneralStatement(T lhs, AbstractOperator<T> operator) {
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = null;
        this.hashCode = this.makeHashCode();
    }

    public GeneralStatement(T lhs, AbstractOperator<T> operator, T op1, T op2) {
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = new IVariable[2];
        this.rhs[0] = op1;
        this.rhs[1] = op2;
        this.hashCode = this.makeHashCode();
    }

    public GeneralStatement(T lhs, AbstractOperator<T> operator, T op1, T op2, T op3) {
        this.operator = operator;
        this.rhs = new IVariable[3];
        this.lhs = lhs;
        this.rhs[0] = op1;
        this.rhs[1] = op2;
        this.rhs[2] = op3;
        this.hashCode = this.makeHashCode();
    }

    public GeneralStatement(T lhs, AbstractOperator<T> operator, IVariable[] rhs) {
        if (rhs == null) {
            throw new IllegalArgumentException("rhs is null");
        }
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = (IVariable[])rhs.clone();
        this.hashCode = this.makeHashCode();
    }

    private int makeHashCode() {
        int result = this.operator.hashCode();
        if (this.lhs != null) {
            result += this.lhs.hashCode() * primes[0];
        }
        int i = 0;
        while (i < Math.min(this.rhs.length, 2)) {
            if (this.rhs[i] != null) {
                result += primes[i + 1] * this.rhs[i].hashCode();
            }
            ++i;
        }
        return result;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass().equals(o.getClass())) {
            GeneralStatement other = (GeneralStatement)o;
            if (this.hashCode == other.hashCode) {
                if (this.lhs == null || other.lhs == null ? other.lhs != this.lhs : !this.lhs.equals(other.lhs)) {
                    return false;
                }
                if (this.operator.equals(other.operator) && this.rhs.length == other.rhs.length) {
                    int i = 0;
                    while (i < this.rhs.length) {
                        if (this.rhs[i] == null || other.rhs[i] == null ? other.rhs[i] != this.rhs[i] : !this.rhs[i].equals(other.rhs[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public AbstractOperator<T> getOperator() {
        return this.operator;
    }

    @Override
    public IVariable[] getRHS() {
        return this.rhs;
    }
}

