/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.classLoader.ArrayClassLoader;
import com.ibm.wala.classLoader.ClassFileModule;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.ImmutableByteArray;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisScope {
    private static final int DEBUG_LEVEL = 0;
    public static final Atom PRIMORDIAL = Atom.findOrCreateUnicodeAtom("Primordial");
    public static final Atom EXTENSION = Atom.findOrCreateUnicodeAtom("Extension");
    public static final Atom APPLICATION = Atom.findOrCreateUnicodeAtom("Application");
    public static final Atom SYNTHETIC = Atom.findOrCreateUnicodeAtom("Synthetic");
    private SetOfClasses exclusions;
    protected final LinkedHashMap<Atom, ClassLoaderReference> loadersByName = new LinkedHashMap();
    private final ArrayClassLoader arrayClassLoader = new ArrayClassLoader();
    private final Map<ClassLoaderReference, Set<Module>> moduleMap = HashMapFactory.make(3);
    private final Collection<Language> languages;
    private final HashMap<ClassLoaderReference, String> loaderImplByRef = HashMapFactory.make();

    public static AnalysisScope createAnalysisScope(Set<Language> languages) {
        return new AnalysisScope(languages);
    }

    protected AnalysisScope(Collection<Language> languages) {
        this.languages = languages;
        ClassLoaderReference primordial = new ClassLoaderReference(PRIMORDIAL, ClassLoaderReference.Java);
        ClassLoaderReference extension = new ClassLoaderReference(EXTENSION, ClassLoaderReference.Java);
        ClassLoaderReference application = new ClassLoaderReference(APPLICATION, ClassLoaderReference.Java);
        ClassLoaderReference synthetic = new ClassLoaderReference(SYNTHETIC, ClassLoaderReference.Java);
        extension.setParent(primordial);
        application.setParent(extension);
        synthetic.setParent(application);
        this.setLoaderImpl(synthetic, "com.ibm.wala.ipa.summaries.BypassSyntheticClassLoader");
        this.loadersByName.put(PRIMORDIAL, primordial);
        this.loadersByName.put(EXTENSION, extension);
        this.loadersByName.put(APPLICATION, application);
        this.loadersByName.put(SYNTHETIC, synthetic);
    }

    public ClassLoaderReference getPrimordialLoader() {
        return this.getLoader(PRIMORDIAL);
    }

    public ClassLoaderReference getExtensionLoader() {
        return this.getLoader(EXTENSION);
    }

    public ClassLoaderReference getApplicationLoader() {
        return this.getLoader(APPLICATION);
    }

    public ClassLoaderReference getSyntheticLoader() {
        return this.getLoader(SYNTHETIC);
    }

    public Collection<Language> getLanguages() {
        return Collections.unmodifiableCollection(this.languages);
    }

    public Set<Language> getBaseLanguages() {
        HashSet<Language> result = new HashSet<Language>();
        for (Language language : this.languages) {
            if (language.getBaseLanguage() != null) continue;
            result.add(language);
        }
        return result;
    }

    public void addSourceFileToScope(ClassLoaderReference loader, File file, String fileName) throws IllegalArgumentException {
        Set<Module> s = MapUtil.findOrCreateSet(this.moduleMap, loader);
        s.add(new SourceFileModule(file, fileName));
    }

    public void addClassFileToScope(ClassLoaderReference loader, File file) throws IllegalArgumentException {
        Set<Module> s = MapUtil.findOrCreateSet(this.moduleMap, loader);
        s.add(new ClassFileModule(file));
    }

    public void addToScope(ClassLoaderReference loader, JarFile file) {
        Set<Module> s = MapUtil.findOrCreateSet(this.moduleMap, loader);
        s.add(new JarFileModule(file));
    }

    public void addToScope(ClassLoaderReference loader, Module m) {
        Assertions._assert(m != null);
        Set<Module> s = MapUtil.findOrCreateSet(this.moduleMap, loader);
        s.add(m);
    }

    public ClassLoaderReference getLoader(Atom name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("empty atom is not a legal class loader name");
        }
        if (name.getVal(0) > 90) {
            Assertions._assert(name.getVal(0) <= 90, "Classloader name improperly capitalised?  (" + name + ")");
        }
        return this.loadersByName.get(name);
    }

    protected ClassLoaderReference classLoaderName2Ref(String clName) {
        return this.getLoader(Atom.findOrCreateUnicodeAtom(clName));
    }

    public String getLoaderImpl(ClassLoaderReference ref) {
        return this.loaderImplByRef.get(ref);
    }

    public void setLoaderImpl(ClassLoaderReference ref, String implClass) {
        this.loaderImplByRef.put(ref, implClass);
    }

    public Collection<ClassLoaderReference> getLoaders() {
        return Collections.unmodifiableCollection(this.loadersByName.values());
    }

    public int getNumberOfLoaders() {
        return this.loadersByName.values().size();
    }

    public SetOfClasses getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(SetOfClasses classes) {
        this.exclusions = classes;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (ClassLoaderReference loader : this.loadersByName.values()) {
            result.append(loader.getName());
            result.append("\n");
            for (Module m : this.getModules(loader)) {
                result.append(" ");
                result.append(m);
                result.append("\n");
            }
        }
        result.append(this.getExclusionString());
        result.append("\n");
        return result.toString();
    }

    protected Object getExclusionString() {
        return "Exclusions: " + this.exclusions;
    }

    public MethodReference findMethod(Atom loader, String klass, Atom name, ImmutableByteArray desc) {
        ClassLoaderReference clr = this.getLoader(loader);
        Descriptor ddesc = Descriptor.findOrCreate(desc);
        TypeReference type = TypeReference.findOrCreate(clr, TypeName.string2TypeName(klass));
        return MethodReference.findOrCreate(type, name, ddesc);
    }

    public Set<Module> getModules(ClassLoaderReference loader) {
        Set<Module> result = this.moduleMap.get(loader);
        Set empty = Collections.emptySet();
        return result == null ? empty : result;
    }

    public ArrayClassLoader getArrayClassLoader() {
        return this.arrayClassLoader;
    }

    private JarFile getRtJar() {
        for (Module M : this.getModules(this.getPrimordialLoader())) {
            if (!(M instanceof JarFileModule)) continue;
            JarFile JF = ((JarFileModule)M).getJarFile();
            if (JF.getName().endsWith(String.valueOf(File.separator) + "rt.jar")) {
                return JF;
            }
            if (JF.getName().endsWith(String.valueOf(File.separator) + "core.jar")) {
                return JF;
            }
            if (!JF.getName().equals("/System/Library/Frameworks/JavaVM.framework/Classes/classes.jar")) continue;
            return JF;
        }
        return null;
    }

    public String getJavaLibraryVersion() throws IllegalStateException {
        JarFile rtJar = this.getRtJar();
        if (rtJar == null) {
            throw new IllegalStateException("cannot find runtime libraries");
        }
        try {
            Manifest man = rtJar.getManifest();
            Assertions._assert(man != null, "runtime library has no manifest!");
            String result = man.getMainAttributes().getValue("Specification-Version");
            if (result == null) {
                Attributes att = man.getMainAttributes();
                System.err.println("main attributes:" + att);
                Assertions.UNREACHABLE("Manifest for " + rtJar.getName() + " has no value for Specification-Version");
            }
            return result;
        }
        catch (IOException e) {
            Assertions.UNREACHABLE("error getting rt.jar manifest!");
            return null;
        }
    }

    public boolean isJava16Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.6");
    }

    public boolean isJava15Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.5");
    }

    public boolean isJava14Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.4");
    }
}

