/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraphStats {
    public static String getStats(CallGraph cg) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Set<CGNode> reachableNodes = DFS.getReachableNodes(cg, (Collection)Collections.singleton(cg.getFakeRootNode()));
        int nNodes = 0;
        int nEdges = 0;
        for (CGNode n : reachableNodes) {
            ++nNodes;
            nEdges += cg.getSuccNodeCount(n);
        }
        StringBuffer result = new StringBuffer();
        result.append("Call graph stats:");
        result.append("\n");
        result.append("  Nodes: " + nNodes);
        result.append("\n");
        result.append("  Edges: " + nEdges);
        result.append("\n");
        result.append("  Methods: " + CallGraphStats.collectMethods(cg).size());
        result.append("\n");
        result.append("  Bytecode Bytes: " + CallGraphStats.countBytecodeBytes(cg));
        result.append("\n");
        return result.toString();
    }

    public static int countBytecodeBytes(CallGraph cg) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        int ret = 0;
        HashSet counted = HashSetFactory.make();
        for (CGNode node : cg) {
            byte[] bytecodes;
            IMethod method = node.getMethod();
            if (!counted.add(method) || !(method instanceof ShrikeCTMethod) || (bytecodes = ((ShrikeCTMethod)method).getBytecodes()) == null) continue;
            ret += bytecodes.length;
        }
        return ret;
    }

    public static Set<MethodReference> collectMethods(CallGraph cg) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        HashSet<MethodReference> result = HashSetFactory.make();
        for (CGNode N : cg) {
            result.add(N.getMethod().getReference());
        }
        return result;
    }
}

