/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeRootClass;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractRootMethod
extends SyntheticMethod {
    protected final ArrayList<SSAInstruction> statements = new ArrayList();
    private int valueNumberForConstantOne = -1;
    protected int nextLocal = 2;
    protected final IClassHierarchy cha;
    private final AnalysisOptions options;
    protected final AnalysisCache cache;

    public AbstractRootMethod(MethodReference method, IClass declaringClass, IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache) {
        super(method, declaringClass, true, false);
        this.cha = cha;
        this.options = options;
        this.cache = cache;
        assert (cache != null);
    }

    public AbstractRootMethod(MethodReference method, IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache) {
        this(method, new FakeRootClass(cha), cha, options, cache);
    }

    public SSAInstruction[] getStatements(SSAOptions options) {
        SSAInstruction[] result = new SSAInstruction[this.statements.size()];
        int i = 0;
        Iterator<SSAInstruction> it = this.statements.iterator();
        while (it.hasNext()) {
            result[i++] = it.next();
        }
        return result;
    }

    public IR makeIR(SSAOptions options) {
        SSAInstruction[] instrs = this.getStatements(options);
        Map constants = null;
        if (this.valueNumberForConstantOne > -1) {
            constants = HashMapFactory.make(1);
            constants.put(new Integer(this.valueNumberForConstantOne), new ConstantValue(new Integer(1)));
        }
        return new SyntheticIR(this, Everywhere.EVERYWHERE, this.makeControlFlowGraph(), instrs, options, constants);
    }

    public int addLocal() {
        return this.nextLocal++;
    }

    public SSAInvokeInstruction addInvocation(int[] params, CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        CallSiteReference newSite = CallSiteReference.make(this.statements.size(), site.getDeclaredTarget(), site.getInvocationCode());
        SSAInvokeInstruction s = null;
        s = newSite.getDeclaredTarget().getReturnType().equals(TypeReference.Void) ? new SSAInvokeInstruction(params, this.nextLocal++, newSite) : new SSAInvokeInstruction(this.nextLocal++, params, this.nextLocal++, newSite);
        this.statements.add(s);
        this.cache.invalidate(this, Everywhere.EVERYWHERE);
        return s;
    }

    public SSANewInstruction addAllocation(TypeReference T) {
        if (T == null) {
            throw new IllegalArgumentException("T is null");
        }
        int instance = this.nextLocal++;
        SSANewInstruction result = null;
        if (T.isReferenceType()) {
            IMethod ctor;
            NewSiteReference ref = NewSiteReference.make(this.statements.size(), T);
            if (T.isArrayType()) {
                this.initValueNumberForConstantOne();
                int[] sizes = new int[T.getDimensionality()];
                Arrays.fill(sizes, this.valueNumberForConstantOne);
                result = new SSANewInstruction(instance, ref, sizes);
            } else {
                result = new SSANewInstruction(instance, ref);
            }
            this.statements.add(result);
            IClass klass = this.cha.lookupClass(T);
            if (klass == null) {
                Warnings.add(AllocationFailure.create(T));
                return null;
            }
            if (klass.isArrayClass()) {
                int arrayRef = result.getDef();
                TypeReference e = klass.getReference().getArrayElementType();
                while (e != null && !e.isPrimitiveType()) {
                    int alloc;
                    NewSiteReference n = NewSiteReference.make(this.statements.size(), e);
                    ++this.nextLocal;
                    SSANewInstruction ni = null;
                    if (e.isArrayType()) {
                        this.initValueNumberForConstantOne();
                        int[] sizes = new int[T.getDimensionality()];
                        Arrays.fill(sizes, this.valueNumberForConstantOne);
                        ni = new SSANewInstruction(alloc, n, sizes);
                    } else {
                        ni = new SSANewInstruction(alloc, n);
                    }
                    this.statements.add(ni);
                    SSAArrayStoreInstruction store = new SSAArrayStoreInstruction(arrayRef, 0, alloc, e);
                    this.statements.add(store);
                    e = e.isArrayType() ? e.getArrayElementType() : null;
                    arrayRef = alloc;
                }
            }
            if ((ctor = this.cha.resolveMethod(klass, MethodReference.initSelector)) != null) {
                this.addInvocation(new int[]{instance}, CallSiteReference.make(this.statements.size(), ctor.getReference(), IInvokeInstruction.Dispatch.SPECIAL));
            }
        }
        this.cache.invalidate(this, Everywhere.EVERYWHERE);
        return result;
    }

    private void initValueNumberForConstantOne() {
        if (this.valueNumberForConstantOne == -1) {
            this.valueNumberForConstantOne = this.nextLocal++;
        }
    }

    public int addPhi(int[] values) {
        int result = this.nextLocal++;
        SSAPhiInstruction phi = new SSAPhiInstruction(result, values);
        this.statements.add(phi);
        return result;
    }

    public int addGetInstance(FieldReference ref, int object) {
        int result = this.nextLocal++;
        this.statements.add(new SSAGetInstruction(result, object, ref));
        return result;
    }

    public int addGetStatic(FieldReference ref) {
        int result = this.nextLocal++;
        this.statements.add(new SSAGetInstruction(result, ref));
        return result;
    }

    public int addCheckcast(TypeReference type, int rv) {
        int lv = this.nextLocal++;
        this.statements.add(SSAInstructionFactory.CheckCastInstruction(lv, rv, type));
        return lv;
    }

    public RTAContextInterpreter getInterpreter() {
        return new RTAContextInterpreter(){

            @Override
            public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
                ArrayList<NewSiteReference> result = new ArrayList<NewSiteReference>();
                SSAInstruction[] statements = AbstractRootMethod.this.getStatements(AbstractRootMethod.this.options.getSSAOptions());
                int i = 0;
                while (i < statements.length) {
                    if (statements[i] instanceof SSANewInstruction) {
                        SSANewInstruction s = (SSANewInstruction)statements[i];
                        result.add(s.getNewSite());
                    }
                    ++i;
                }
                return result.iterator();
            }

            public Iterator<SSAInstruction> getInvokeStatements() {
                ArrayList<SSAInstruction> result = new ArrayList<SSAInstruction>();
                SSAInstruction[] statements = AbstractRootMethod.this.getStatements(AbstractRootMethod.this.options.getSSAOptions());
                int i = 0;
                while (i < statements.length) {
                    if (statements[i] instanceof SSAInvokeInstruction) {
                        result.add(statements[i]);
                    }
                    ++i;
                }
                return result.iterator();
            }

            @Override
            public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
                final Iterator<SSAInstruction> I = this.getInvokeStatements();
                return new Iterator<CallSiteReference>(){

                    @Override
                    public boolean hasNext() {
                        return I.hasNext();
                    }

                    @Override
                    public CallSiteReference next() {
                        SSAInvokeInstruction s = (SSAInvokeInstruction)I.next();
                        return s.getCallSite();
                    }

                    @Override
                    public void remove() {
                        Assertions.UNREACHABLE();
                    }
                };
            }

            @Override
            public boolean understands(CGNode node) {
                return node.getMethod().getDeclaringClass().getReference().equals(FakeRootClass.FAKE_ROOT_CLASS);
            }

            @Override
            public boolean recordFactoryType(CGNode node, IClass klass) {
                return false;
            }

            @Override
            public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
                return EmptyIterator.instance();
            }

            @Override
            public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
                return EmptyIterator.instance();
            }
        };
    }

    private static class AllocationFailure
    extends Warning {
        final TypeReference t;

        AllocationFailure(TypeReference t) {
            super((byte)2);
            this.t = t;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.t;
        }

        public static AllocationFailure create(TypeReference t) {
            return new AllocationFailure(t);
        }
    }
}

