/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.ArgumentTypeEntrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllApplicationEntrypoints
extends HashSet<Entrypoint> {
    private static final boolean DEBUG = false;

    public AllApplicationEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        for (IClass klass : cha) {
            if (klass.isInterface() || !this.isApplicationClass(scope, klass)) continue;
            for (IMethod method : klass.getDeclaredMethods()) {
                if (method.isAbstract()) continue;
                this.add(new ArgumentTypeEntrypoint(method, cha));
            }
        }
    }

    private boolean isApplicationClass(AnalysisScope scope, IClass klass) {
        return scope.getApplicationLoader().equals(klass.getClassLoader().getReference());
    }
}

