/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicCallGraph
extends AbstractNumberedGraph<CGNode>
implements CallGraph {
    private static final boolean DEBUG = false;
    private final DelegatingNumberedNodeManager<CGNode> nodeManager = new DelegatingNumberedNodeManager();
    private CGNode fakeRoot;
    private CGNode fakeWorldClinit;
    private SSAContextInterpreter interpreter;
    private final Set<CGNode> entrypointNodes = HashSetFactory.make();
    private final Map<Key, CGNode> nodes = HashMapFactory.make();
    private final Map<MethodReference, Set<CGNode>> mr2Nodes = HashMapFactory.make();

    public void init() {
        this.fakeRoot = this.makeFakeRootNode();
        Key k = new Key(this.fakeRoot.getMethod(), this.fakeRoot.getContext());
        this.registerNode(k, this.fakeRoot);
        this.fakeWorldClinit = this.makeFakeWorldClinitNode();
        k = new Key(this.fakeWorldClinit.getMethod(), this.fakeWorldClinit.getContext());
        this.registerNode(k, this.fakeWorldClinit);
        CallSiteReference site = CallSiteReference.make(1, this.fakeWorldClinit.getMethod().getReference(), IInvokeInstruction.Dispatch.STATIC);
        site = ((AbstractRootMethod)this.fakeRoot.getMethod()).addInvocation(null, site).getCallSite();
        this.fakeRoot.addTarget(site, this.fakeWorldClinit);
    }

    protected abstract CGNode makeFakeRootNode();

    protected abstract CGNode makeFakeWorldClinitNode();

    public abstract CGNode findOrCreateNode(IMethod var1, Context var2);

    protected void registerNode(Key K, CGNode N) {
        this.nodes.put(K, N);
        this.addNode(N);
        Set<CGNode> s = this.findOrCreateMr2Nodes(K.m);
        s.add(N);
    }

    private Set<CGNode> findOrCreateMr2Nodes(IMethod method) {
        Set result = this.mr2Nodes.get(method.getReference());
        if (result == null) {
            result = HashSetFactory.make(3);
            this.mr2Nodes.put(method.getReference(), result);
        }
        return result;
    }

    protected NodeImpl getNode(Key K) {
        return (NodeImpl)this.nodes.get(K);
    }

    @Override
    public CGNode getFakeRootNode() {
        return this.fakeRoot;
    }

    public CGNode getFakeWorldClinitNode() {
        return this.fakeWorldClinit;
    }

    public void registerEntrypoint(CGNode node) {
        this.entrypointNodes.add(node);
    }

    @Override
    public Collection<CGNode> getEntrypointNodes() {
        return this.entrypointNodes;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("");
        Iterator<CGNode> i = DFS.iterateDiscoverTime(this, new NonNullSingletonIterator<CGNode>(this.getFakeRootNode()));
        while (i.hasNext()) {
            CGNode n = i.next();
            result.append(n + "\n");
            if (n.getMethod() == null) continue;
            Iterator<CallSiteReference> sites = n.iterateCallSites();
            while (sites.hasNext()) {
                CallSiteReference site = sites.next();
                Iterator<CGNode> targets = this.getPossibleTargets(n, site).iterator();
                if (targets.hasNext()) {
                    result.append(" - " + site + "\n");
                }
                while (targets.hasNext()) {
                    CGNode target = targets.next();
                    result.append("     -> " + target + "\n");
                }
            }
        }
        return result.toString();
    }

    @Override
    public void removeNodeAndEdges(CGNode N) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public CGNode getNode(IMethod method, Context C) {
        Key key = new Key(method, C);
        return this.getNode(key);
    }

    @Override
    public Set<CGNode> getNodes(MethodReference m) {
        IMethod im = this.getClassHierarchy().resolveMethod(m);
        if (im == null) {
            return Collections.emptySet();
        }
        Set<CGNode> result = this.mr2Nodes.get(im.getReference());
        Set empty = Collections.emptySet();
        return result == null ? empty : result;
    }

    protected SSAContextInterpreter getInterpreter(CGNode node) {
        return this.interpreter;
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    @Override
    public Iterator<CGNode> iterator() {
        return this.nodes.values().iterator();
    }

    @Override
    public boolean containsNode(CGNode N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        return this.getNode(N.getMethod(), N.getContext()) != null;
    }

    public void setInterpreter(SSAContextInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    protected NodeManager<CGNode> getNodeManager() {
        return this.nodeManager;
    }

    protected static final class Key {
        private final IMethod m;
        private final Context C;

        public Key(IMethod m, Context C) {
            Assertions._assert(m != null, "null method");
            Assertions._assert(C != null, "null context");
            this.m = m;
            this.C = C;
        }

        public int hashCode() {
            return 17 * this.m.hashCode() + this.C.hashCode();
        }

        public boolean equals(Object o) {
            Assertions._assert(o instanceof Key);
            Key other = (Key)o;
            return this.m.equals(other.m) && this.C.equals(other.C);
        }

        public String toString() {
            return "{" + this.m + "," + this.C + "}";
        }
    }

    public abstract class NodeImpl
    extends NodeWithNumber
    implements CGNode {
        protected final IMethod method;
        private final Context context;

        protected NodeImpl(IMethod method, Context C) {
            this.method = method;
            this.context = C;
            if (method != null && !method.isSynthetic() && method.isAbstract()) {
                Assertions._assert(!method.isAbstract(), "Abstract method " + method);
            }
            Assertions._assert(C != null);
        }

        public IMethod getMethod() {
            return this.method;
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        public String toString() {
            return "Node: " + this.method.toString() + " Context: " + this.context.toString();
        }

        public Context getContext() {
            return this.context;
        }

        public abstract boolean addTarget(CallSiteReference var1, CGNode var2);

        public IClassHierarchy getClassHierarchy() {
            return this.method.getClassHierarchy();
        }
    }
}

