/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.ResolutionFailure;
import com.ibm.wala.util.warnings.Warnings;

public class ClassHierarchyMethodTargetSelector
implements MethodTargetSelector {
    private final IClassHierarchy classHierarchy;

    public ClassHierarchyMethodTargetSelector(IClassHierarchy cha) {
        this.classHierarchy = cha;
    }

    public IMethod getCalleeTarget(CGNode caller, CallSiteReference call, IClass receiver) {
        IMethod target;
        IClass klass;
        if (call == null) {
            throw new IllegalArgumentException("call is null");
        }
        TypeReference targetType = call.getDeclaredTarget().getDeclaringClass();
        if (call.isDispatch()) {
            if (receiver == null) {
                Assertions._assert(receiver != null, "null receiver for " + call);
            }
            klass = receiver;
        } else if (call.isFixed()) {
            klass = this.classHierarchy.lookupClass(targetType);
            if (klass == null) {
                Warnings.add(ResolutionFailure.create(caller, targetType));
                return null;
            }
        } else {
            return null;
        }
        IMethod iMethod = target = ClassHierarchyMethodTargetSelector.feasibleChaResolution(this.classHierarchy, call, klass) ? this.classHierarchy.resolveMethod(klass, call.getDeclaredTarget().getSelector()) : null;
        if (target == null) {
            Warnings.add(ResolutionFailure.create(caller, call.getDeclaredTarget().getSelector()));
            return null;
        }
        return target;
    }

    public static boolean feasibleChaResolution(IClassHierarchy cha, CallSiteReference site, IClass dispatchType) {
        if (dispatchType == null) {
            return false;
        }
        if (dispatchType.isInterface()) {
            return site.getDeclaredTarget().getSelector().equals(MethodReference.clinitSelector);
        }
        TypeReference targetType = site.getDeclaredTarget().getDeclaringClass();
        IClass resolvedType = cha.lookupClass(targetType);
        if (resolvedType == null) {
            return false;
        }
        if (resolvedType.isInterface()) {
            return cha.implementsInterface(dispatchType, resolvedType);
        }
        return cha.isSubclassOf(dispatchType, resolvedType);
    }

    public boolean mightReturnSyntheticMethod(CGNode caller, CallSiteReference site) {
        return false;
    }

    public boolean mightReturnSyntheticMethod(MethodReference declaredTarget) {
        return false;
    }
}

