/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.BasicCallGraph;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.util.IntFunction;
import com.ibm.wala.util.IntMapIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import com.ibm.wala.util.intset.SparseVector;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitCallGraph
extends BasicCallGraph
implements BytecodeConstants {
    private static final boolean DEBUG = false;
    protected final IClassHierarchy cha;
    protected final AnalysisOptions options;
    private final AnalysisCache cache;
    private final ExplicitEdgeManager edgeManager = this.makeEdgeManger();

    public ExplicitCallGraph(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache) {
        this.cha = cha;
        this.options = options;
        this.cache = cache;
        assert (cache != null);
    }

    protected ExplicitNode makeNode(IMethod method, Context context) {
        return new ExplicitNode(method, context);
    }

    @Override
    protected CGNode makeFakeRootNode() {
        return this.findOrCreateNode(new FakeRootMethod(this.cha, this.options, this.cache), Everywhere.EVERYWHERE);
    }

    @Override
    protected CGNode makeFakeWorldClinitNode() {
        return this.findOrCreateNode(new FakeWorldClinitMethod(this.cha, this.options, this.cache), Everywhere.EVERYWHERE);
    }

    @Override
    public CGNode findOrCreateNode(IMethod method, Context C) {
        BasicCallGraph.Key k;
        BasicCallGraph.NodeImpl result;
        if (method == null || C == null) {
            Assertions._assert(method != null, "null method");
            Assertions._assert(C != null, "null context for method " + method);
        }
        if ((result = this.getNode(k = new BasicCallGraph.Key(method, C))) == null) {
            result = this.makeNode(method, C);
            this.registerNode(k, result);
        }
        return result;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public EdgeManager<CGNode> getEdgeManager() {
        return this.edgeManager;
    }

    protected ExplicitEdgeManager makeEdgeManger() {
        return new ExplicitEdgeManager();
    }

    @Override
    public int getNumberOfTargets(CGNode node, CallSiteReference site) {
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("node not in callgraph " + node);
        }
        assert (node instanceof ExplicitNode);
        ExplicitNode n = (ExplicitNode)node;
        return n.getNumberOfTargets(site);
    }

    @Override
    public Iterator<CallSiteReference> getPossibleSites(CGNode src, CGNode target) {
        if (!this.containsNode(src)) {
            throw new IllegalArgumentException("node not in callgraph " + src);
        }
        if (!this.containsNode(target)) {
            throw new IllegalArgumentException("node not in callgraph " + target);
        }
        assert (src instanceof ExplicitNode);
        ExplicitNode n = (ExplicitNode)src;
        return n.getPossibleSites(target);
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site) {
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("node not in callgraph " + node);
        }
        assert (node instanceof ExplicitNode);
        ExplicitNode n = (ExplicitNode)node;
        return n.getPossibleTargets(site);
    }

    public IntSet getPossibleTargetNumbers(CGNode node, CallSiteReference site) {
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("node not in callgraph " + node);
        }
        assert (node instanceof ExplicitNode);
        ExplicitNode n = (ExplicitNode)node;
        return n.getPossibleTargetNumbers(site);
    }

    public AnalysisCache getAnalysisCache() {
        return this.cache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExplicitEdgeManager
    implements NumberedEdgeManager<CGNode> {
        final IntFunction<CGNode> toNode = new IntFunction<CGNode>(){

            @Override
            public CGNode apply(int i) {
                CGNode result = (CGNode)ExplicitCallGraph.this.getNode(i);
                return result;
            }
        };
        final IBinaryNaturalRelation predecessors = new BasicNaturalRelation(new byte[]{2}, 0);

        protected ExplicitEdgeManager() {
        }

        @Override
        public IntSet getSuccNodeNumbers(CGNode node) {
            ExplicitNode n = (ExplicitNode)node;
            return n.getAllTargetNumbers();
        }

        @Override
        public IntSet getPredNodeNumbers(CGNode node) {
            ExplicitNode n = (ExplicitNode)node;
            int y = ExplicitCallGraph.this.getNumber(n);
            return this.predecessors.getRelated(y);
        }

        @Override
        public Iterator<CGNode> getPredNodes(CGNode N) {
            IntSet s = this.getPredNodeNumbers(N);
            if (s == null) {
                return EmptyIterator.instance();
            }
            return new IntMapIterator<CGNode>(s.intIterator(), this.toNode);
        }

        @Override
        public int getPredNodeCount(CGNode N) {
            ExplicitNode n = (ExplicitNode)N;
            int y = ExplicitCallGraph.this.getNumber(n);
            return this.predecessors.getRelatedCount(y);
        }

        @Override
        public Iterator<CGNode> getSuccNodes(CGNode N) {
            ExplicitNode n = (ExplicitNode)N;
            return new IntMapIterator<CGNode>(n.getAllTargetNumbers().intIterator(), this.toNode);
        }

        @Override
        public int getSuccNodeCount(CGNode N) {
            ExplicitNode n = (ExplicitNode)N;
            return n.getAllTargetNumbers().size();
        }

        @Override
        public void addEdge(CGNode src, CGNode dst) {
            int x = ExplicitCallGraph.this.getNumber(src);
            int y = ExplicitCallGraph.this.getNumber(dst);
            this.predecessors.add(y, x);
        }

        @Override
        public void removeEdge(CGNode src, CGNode dst) {
            int x = ExplicitCallGraph.this.getNumber(src);
            int y = ExplicitCallGraph.this.getNumber(dst);
            this.predecessors.remove(y, x);
        }

        @Override
        protected void addEdge(int x, int y) {
            this.predecessors.add(y, x);
        }

        @Override
        public void removeAllIncidentEdges(CGNode node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeIncomingEdges(CGNode node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeOutgoingEdges(CGNode node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public boolean hasEdge(CGNode src, CGNode dst) {
            int x = ExplicitCallGraph.this.getNumber(src);
            int y = ExplicitCallGraph.this.getNumber(dst);
            return this.predecessors.contains(y, x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExplicitNode
    extends BasicCallGraph.NodeImpl {
        protected final SparseVector<Object> targets;
        private final MutableSharedBitVectorIntSet allTargets;

        protected ExplicitNode(IMethod method, Context C) {
            super(ExplicitCallGraph.this, method, C);
            this.targets = new SparseVector();
            this.allTargets = new MutableSharedBitVectorIntSet();
        }

        protected Set<CGNode> getPossibleTargets(CallSiteReference site) {
            Object result = this.targets.get(site.getProgramCounter());
            if (result == null) {
                return Collections.emptySet();
            }
            if (result instanceof CGNode) {
                Set<CGNode> s = Collections.singleton((CGNode)result);
                return s;
            }
            IntSet s = (IntSet)result;
            HashSet<CGNode> h = HashSetFactory.make(s.size());
            IntIterator it = s.intIterator();
            while (it.hasNext()) {
                h.add((CGNode)this.getCallGraph().getNode(it.next()));
            }
            return h;
        }

        protected IntSet getPossibleTargetNumbers(CallSiteReference site) {
            Object t = this.targets.get(site.getProgramCounter());
            if (t == null) {
                return null;
            }
            if (t instanceof CGNode) {
                return SparseIntSet.singleton(this.getCallGraph().getNumber((CGNode)t));
            }
            return (IntSet)t;
        }

        protected Iterator<CallSiteReference> getPossibleSites(CGNode to) {
            final int n = this.getCallGraph().getNumber(to);
            return new FilterIterator<CallSiteReference>(this.iterateCallSites(), new Filter(){

                public boolean accepts(Object o) {
                    IntSet s = ExplicitNode.this.getPossibleTargetNumbers((CallSiteReference)o);
                    return s == null ? false : s.contains(n);
                }
            });
        }

        protected int getNumberOfTargets(CallSiteReference site) {
            Object result = this.targets.get(site.getProgramCounter());
            if (result == null) {
                return 0;
            }
            if (result instanceof CGNode) {
                return 1;
            }
            return ((IntSet)result).size();
        }

        @Override
        public boolean addTarget(CallSiteReference site, CGNode tNode) {
            return this.addTarget(site.getProgramCounter(), tNode);
        }

        protected boolean addTarget(int pc, CGNode tNode) {
            this.allTargets.add(this.getCallGraph().getNumber(tNode));
            Object S = this.targets.get(pc);
            if (S == null) {
                S = tNode;
                this.targets.set(pc, S);
                this.getCallGraph().addEdge(this, tNode);
                return true;
            }
            if (S instanceof CGNode) {
                if (S.equals(tNode)) {
                    return false;
                }
                MutableSharedBitVectorIntSet s = new MutableSharedBitVectorIntSet();
                s.add(this.getCallGraph().getNumber((CGNode)S));
                s.add(this.getCallGraph().getNumber(tNode));
                this.getCallGraph().addEdge(this, tNode);
                this.targets.set(pc, s);
                return true;
            }
            MutableIntSet s = (MutableIntSet)S;
            int n = this.getCallGraph().getNumber(tNode);
            if (!s.contains(n)) {
                s.add(n);
                this.getCallGraph().addEdge(this, tNode);
                return true;
            }
            return false;
        }

        public void removeTarget(CGNode target) {
            this.allTargets.remove(this.getCallGraph().getNumber(target));
            IntIterator it = this.targets.safeIterateIndices();
            while (it.hasNext()) {
                int pc = it.next();
                Object value = this.targets.get(pc);
                if (value instanceof CGNode) {
                    if (!value.equals(target)) continue;
                    this.targets.remove(pc);
                    continue;
                }
                MutableIntSet s = (MutableIntSet)value;
                int n = this.getCallGraph().getNumber(target);
                if (s.size() > 2) {
                    s.remove(n);
                    continue;
                }
                Assertions._assert(s.size() == 2);
                if (!s.contains(n)) continue;
                s.remove(n);
                int i = s.intIterator().next();
                this.targets.set(pc, this.getCallGraph().getNode(i));
            }
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return this.getMethod().hashCode() * 8681 + this.getContext().hashCode();
        }

        protected MutableSharedBitVectorIntSet getAllTargetNumbers() {
            return this.allTargets;
        }

        public void clearAllTargets() {
            this.targets.clear();
            this.allTargets.clear();
        }

        @Override
        public IR getIR() {
            return this.getCallGraph().getInterpreter(this).getIR(this);
        }

        @Override
        public DefUse getDU() {
            return this.getCallGraph().getInterpreter(this).getDU(this);
        }

        public ExplicitCallGraph getCallGraph() {
            return ExplicitCallGraph.this;
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites() {
            return this.getCallGraph().getInterpreter(this).iterateCallSites(this);
        }

        @Override
        public Iterator<NewSiteReference> iterateNewSites() {
            return this.getCallGraph().getInterpreter(this).iterateNewSites(this);
        }

        public ControlFlowGraph<ISSABasicBlock> getCFG() {
            return this.getCallGraph().getInterpreter(this).getCFG(this);
        }
    }
}

