/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.util.graph.impl.DelegatingGraph;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialCallGraph
extends DelegatingGraph<CGNode>
implements CallGraph {
    protected final CallGraph cg;
    protected final Collection<CGNode> partialRoots;

    protected PartialCallGraph(CallGraph cg, Collection<CGNode> partialRoots, Graph<CGNode> partialGraph) {
        super(partialGraph);
        this.cg = cg;
        this.partialRoots = partialRoots;
    }

    public static PartialCallGraph make(CallGraph cg, Collection<CGNode> partialRoots, final Collection<CGNode> nodes) {
        Graph<CGNode> partialGraph = GraphSlicer.prune(cg, new Filter<CGNode>(){

            @Override
            public boolean accepts(CGNode o) {
                return nodes.contains(o);
            }
        });
        return new PartialCallGraph(cg, partialRoots, partialGraph);
    }

    public static PartialCallGraph make(CallGraph cg, Collection<CGNode> partialRoots) {
        final Set<CGNode> nodes = DFS.getReachableNodes(cg, partialRoots);
        Graph<CGNode> partialGraph = GraphSlicer.prune(cg, new Filter<CGNode>(){

            @Override
            public boolean accepts(CGNode o) {
                return nodes.contains(o);
            }
        });
        return new PartialCallGraph(cg, partialRoots, partialGraph);
    }

    @Override
    public CGNode getFakeRootNode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<CGNode> getEntrypointNodes() {
        return this.partialRoots;
    }

    @Override
    public CGNode getNode(IMethod method, Context C) {
        CGNode x = this.cg.getNode(method, C);
        if (x == null) {
            return null;
        }
        return this.containsNode(x) ? x : null;
    }

    @Override
    public Set<CGNode> getNodes(MethodReference m) {
        Set result = HashSetFactory.make();
        for (CGNode x : this.cg.getNodes(m)) {
            if (!this.containsNode(x)) continue;
            result.add(x);
        }
        return result;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cg.getClassHierarchy();
    }

    @Override
    public Iterator<CGNode> iterateNodes(IntSet nodes) {
        return new FilterIterator<CGNode>(this.cg.iterateNodes(nodes), new Filter(){

            public boolean accepts(Object o) {
                return PartialCallGraph.this.containsNode((CGNode)o);
            }
        });
    }

    @Override
    public int getMaxNumber() {
        return this.cg.getMaxNumber();
    }

    @Override
    public CGNode getNode(int index) {
        CGNode n = (CGNode)this.cg.getNode(index);
        return this.containsNode(n) ? n : null;
    }

    @Override
    public int getNumber(CGNode n) {
        return this.containsNode(n) ? this.cg.getNumber(n) : -1;
    }

    @Override
    public IntSet getSuccNodeNumbers(CGNode node) {
        Assertions._assert(this.containsNode(node));
        MutableIntSet x = IntSetUtil.make();
        Iterator<CGNode> ns = this.getSuccNodes(node);
        while (ns.hasNext()) {
            CGNode succ = ns.next();
            if (!this.containsNode(succ)) continue;
            x.add(this.getNumber(succ));
        }
        return x;
    }

    @Override
    public IntSet getPredNodeNumbers(CGNode node) {
        Assertions._assert(this.containsNode(node));
        MutableIntSet x = IntSetUtil.make();
        Iterator<CGNode> ns = this.getPredNodes(node);
        while (ns.hasNext()) {
            CGNode pred = ns.next();
            if (!this.containsNode(pred)) continue;
            x.add(this.getNumber(pred));
        }
        return x;
    }

    @Override
    public int getNumberOfTargets(CGNode node, CallSiteReference site) {
        return this.containsNode(node) ? this.getPossibleTargets(node, site).size() : -1;
    }

    @Override
    public Iterator<CallSiteReference> getPossibleSites(CGNode src, CGNode target) {
        return this.containsNode(src) && this.containsNode(target) ? this.cg.getPossibleSites(src, target) : null;
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site) {
        if (!this.containsNode(node)) {
            return null;
        }
        Set result = HashSetFactory.make();
        for (CGNode target : this.cg.getPossibleTargets(node, site)) {
            if (!this.containsNode(target)) continue;
            result.add(target);
        }
        return result;
    }
}

