/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyClassTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyMethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.OneCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXContainerCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.rta.BasicRTABuilder;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.BypassClassTargetSelector;
import com.ibm.wala.ipa.summaries.BypassMethodTargetSelector;
import com.ibm.wala.ipa.summaries.XMLMethodSummaryReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.Trace;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.SlowDFSDiscoverTimeIterator;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final String nativeSpec = "natives.xml";

    public static void addDefaultSelectors(AnalysisOptions options, IClassHierarchy cha) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        options.setSelector(new ClassHierarchyMethodTargetSelector(cha));
        options.setSelector(new ClassHierarchyClassTargetSelector(cha));
    }

    public static <T> boolean areEqual(Graph<T> g1, Graph<T> g2) {
        Set n2;
        if (g2 == null) {
            throw new IllegalArgumentException("g2 is null");
        }
        if (g1 == null) {
            throw new IllegalArgumentException("g1 is null");
        }
        if (g1.getNumberOfNodes() != g2.getNumberOfNodes()) {
            return false;
        }
        Set n1 = Util.setify(g1.iterator());
        if (!n1.equals(n2 = Util.setify(g2.iterator()))) {
            return false;
        }
        for (Object x : n1) {
            Set s2;
            if (g1.getSuccNodeCount(x) != g2.getSuccNodeCount(x)) {
                return false;
            }
            Set s1 = Util.setify(g1.getSuccNodes(x));
            if (s1.equals(s2 = Util.setify(g2.getSuccNodes(x)))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isSubset(Graph<T> g1, Graph<T> g2) {
        if (g2 == null) {
            throw new IllegalArgumentException("g2 is null");
        }
        if (g1 == null) {
            throw new IllegalArgumentException("g1 is null");
        }
        if (g1.getNumberOfNodes() > g2.getNumberOfNodes()) {
            return false;
        }
        Set n1 = Util.setify(g1.iterator());
        Set n2 = Util.setify(g2.iterator());
        if (!n2.containsAll(n1)) {
            return false;
        }
        for (Object x : n1) {
            if (g1.getSuccNodeCount(x) > g2.getSuccNodeCount(x)) {
                return false;
            }
            Set s1 = Util.setify(g1.getSuccNodes(x));
            Set s2 = Util.setify(g2.getSuccNodes(x));
            if (s2.containsAll(s1)) continue;
            return false;
        }
        return true;
    }

    public static void addBypassLogic(AnalysisOptions options, AnalysisScope scope, ClassLoader cl, String xmlFile, IClassHierarchy cha) throws IllegalArgumentException {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("cl is null");
        }
        if (cha == null) {
            throw new IllegalArgumentException("cha cannot be null");
        }
        InputStream s = cl.getResourceAsStream(xmlFile);
        XMLMethodSummaryReader summary = new XMLMethodSummaryReader(s, scope);
        BypassMethodTargetSelector ms = new BypassMethodTargetSelector(options.getMethodTargetSelector(), summary.getSummaries(), summary.getIgnoredPackages(), cha);
        options.setSelector(ms);
        BypassClassTargetSelector cs = new BypassClassTargetSelector(options.getClassTargetSelector(), summary.getAllocatableClasses(), cha, cha.getLoader(scope.getLoader(Atom.findOrCreateUnicodeAtom("Synthetic"))));
        options.setSelector(cs);
    }

    public static Collection<CGNode> computeDarkEntrypointNodes(CallGraph cg, Collection<CGNode> entrypoints) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        HashSet<CGNode> result = HashSetFactory.make();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DarkIterator
        extends SlowDFSDiscoverTimeIterator<CGNode> {
            private static final long serialVersionUID = -7554905808017614372L;
            private final /* synthetic */ Collection val$entrypoints;

            DarkIterator(CallGraph callGraph, Collection collection) {
                this.val$entrypoints = collection;
                this.init(callGraph, Collections.singleton(callGraph.getFakeRootNode()).iterator());
            }

            @Override
            public Iterator<CGNode> getConnected(CGNode N) {
                HashSet result = HashSetFactory.make(5);
                Iterator<CGNode> it = super.getConnected(N);
                while (it.hasNext()) {
                    CGNode X = it.next();
                    if (this.val$entrypoints.contains(X)) continue;
                    result.add(X);
                }
                return result.iterator();
            }
        }
        DarkIterator D = new DarkIterator(cg, entrypoints);
        while (D.hasNext()) {
            CGNode N = (CGNode)D.next();
            result.add(N);
        }
        return result;
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        return Util.makeMainEntrypoints(scope.getApplicationLoader(), cha);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(ClassLoaderReference clr, IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        Atom mainMethod = Atom.findOrCreateAsciiAtom("main");
        final HashSet result = HashSetFactory.make();
        for (IClass klass : cha) {
            MethodReference mainRef;
            IMethod m;
            if (!klass.getClassLoader().getReference().equals(clr) || (m = klass.getMethod((mainRef = MethodReference.findOrCreate(klass.getReference(), mainMethod, Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V"))).getSelector())) == null) continue;
            result.add(new DefaultEntrypoint(m, cha));
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return result.iterator();
            }
        };
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope scope, IClassHierarchy cha, String className) {
        return Util.makeMainEntrypoints(scope, cha, new String[]{className});
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope scope, IClassHierarchy cha, String[] classNames) {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        return Util.makeMainEntrypoints(scope.getApplicationLoader(), cha, classNames);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(final ClassLoaderReference loaderRef, final IClassHierarchy cha, final String[] classNames) throws IllegalArgumentException, IllegalArgumentException, IllegalArgumentException {
        if (classNames == null) {
            throw new IllegalArgumentException("classNames == null");
        }
        if (classNames.length == 0) {
            throw new IllegalArgumentException("classNames.length == 0");
        }
        if (classNames[0] == null && classNames.length > 0) {
            throw new IllegalArgumentException("(0 < classNames.length) and (classNames[0] == null)");
        }
        int i = 0;
        while (i < classNames.length) {
            if (classNames[i].indexOf("L") != 0) {
                Assertions.productionAssertion(false, "Expected class name to start with L " + classNames[i]);
            }
            if (classNames[i].indexOf(".") > 0) {
                Assertions.productionAssertion(false, "Expected class name formatted with /, not . " + classNames[i]);
            }
            ++i;
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                final Atom mainMethod = Atom.findOrCreateAsciiAtom("main");
                return new Iterator<Entrypoint>(){
                    private int index = 0;

                    @Override
                    public void remove() {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < classNames.length;
                    }

                    @Override
                    public Entrypoint next() {
                        TypeReference T = TypeReference.findOrCreate(loaderRef, TypeName.string2TypeName(classNames[this.index++]));
                        MethodReference mainRef = MethodReference.findOrCreate(T, mainMethod, Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V"));
                        return new DefaultEntrypoint(mainRef, cha);
                    }
                };
            }
        };
    }

    public static Graph<MethodReference> squashCallGraph(final String name, final CallGraph cg) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        final Set nodes = HashSetFactory.make();
        Iterator nodesI = cg.iterator();
        while (nodesI.hasNext()) {
            nodes.add(((CGNode)nodesI.next()).getMethod().getReference());
        }
        return new Graph<MethodReference>(){

            public String toString() {
                StringBuffer result = new StringBuffer();
                result.append("squashed " + name + " call graph\n");
                result.append("Original graph:");
                result.append(cg.toString());
                return result.toString();
            }

            @Override
            public Iterator<MethodReference> iterator() {
                return nodes.iterator();
            }

            @Override
            public boolean containsNode(MethodReference N) {
                return nodes.contains(N);
            }

            @Override
            public int getNumberOfNodes() {
                return nodes.size();
            }

            @Override
            public Iterator<MethodReference> getPredNodes(MethodReference N) {
                Set pred = HashSetFactory.make(10);
                MethodReference methodReference = N;
                Iterator<CGNode> i = cg.getNodes(methodReference).iterator();
                while (i.hasNext()) {
                    Iterator<CGNode> ps = cg.getPredNodes(i.next());
                    while (ps.hasNext()) {
                        pred.add(ps.next().getMethod().getReference());
                    }
                }
                return pred.iterator();
            }

            @Override
            public int getPredNodeCount(MethodReference N) {
                int count = 0;
                Iterator<MethodReference> ps = this.getPredNodes(N);
                while (ps.hasNext()) {
                    ++count;
                    ps.next();
                }
                return count;
            }

            @Override
            public Iterator<MethodReference> getSuccNodes(MethodReference N) {
                Set succ = HashSetFactory.make(10);
                MethodReference methodReference = N;
                Iterator<CGNode> i = cg.getNodes(methodReference).iterator();
                while (i.hasNext()) {
                    Iterator<CGNode> ps = cg.getSuccNodes(i.next());
                    while (ps.hasNext()) {
                        succ.add(ps.next().getMethod().getReference());
                    }
                }
                return succ.iterator();
            }

            @Override
            public int getSuccNodeCount(MethodReference N) {
                int count = 0;
                Iterator<MethodReference> ps = this.getSuccNodes(N);
                while (ps.hasNext()) {
                    ++count;
                    ps.next();
                }
                return count;
            }

            @Override
            public void addNode(MethodReference n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeNode(MethodReference n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void addEdge(MethodReference src, MethodReference dst) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeEdge(MethodReference src, MethodReference dst) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeAllIncidentEdges(MethodReference node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeNodeAndEdges(MethodReference N) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeIncomingEdges(MethodReference node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeOutgoingEdges(MethodReference node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public boolean hasEdge(MethodReference src, MethodReference dst) {
                Assertions.UNREACHABLE();
                return false;
            }
        };
    }

    public static <T> Set<T> setify(Iterator<? extends T> x) {
        Set y = HashSetFactory.make();
        while (x.hasNext()) {
            y.add(x.next());
        }
        return y;
    }

    public static <T> void checkGraphSubset(Graph<T> supG, Graph<T> subG) {
        if (supG == null) {
            throw new IllegalArgumentException("supG is null");
        }
        if (subG == null) {
            throw new IllegalArgumentException("subG is null");
        }
        Set nodeDiff = Util.setify(subG.iterator());
        nodeDiff.removeAll(Util.setify(supG.iterator()));
        if (!nodeDiff.isEmpty()) {
            Trace.println("supergraph: ");
            Trace.println(supG.toString());
            Trace.println("subgraph: ");
            Trace.println(subG.toString());
            Trace.println("nodeDiff: ");
            Iterator it = nodeDiff.iterator();
            while (it.hasNext()) {
                Trace.println(it.next().toString());
            }
            Assertions.productionAssertion(nodeDiff.isEmpty(), "bad superset, see tracefile\n");
        }
        for (Object m : subG) {
            Set succDiff = Util.setify(subG.getSuccNodes(m));
            succDiff.removeAll(Util.setify(supG.getSuccNodes(m)));
            if (!succDiff.isEmpty()) {
                Assertions.productionAssertion(succDiff.isEmpty(), "bad superset for successors of " + m + ":" + succDiff);
            }
            Set predDiff = Util.setify(subG.getPredNodes(m));
            predDiff.removeAll(Util.setify(supG.getPredNodes(m)));
            if (predDiff.isEmpty()) continue;
            Trace.println("supergraph: ");
            Trace.println(supG.toString());
            Trace.println("subgraph: ");
            Trace.println(subG.toString());
            Trace.println("predDiff: ");
            Iterator it = predDiff.iterator();
            while (it.hasNext()) {
                Trace.println(it.next().toString());
            }
            Assertions.UNREACHABLE("bad superset for predecessors of " + m + ":" + predDiff);
        }
    }

    public static CallGraphBuilder makeRTABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        return new BasicRTABuilder(cha, options, cache, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeZeroCFABuilder(options, cache, cha, scope, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        return ZeroXCFABuilder.make(cha, options, cache, customSelector, customInterpreter, options.getReflectionSpec(), 0);
    }

    public static CallGraphBuilder makeOneCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, ClassLoader cl, AnalysisScope scope) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, cl, cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        OneCFABuilder builder = OneCFABuilder.make(cha, options, cache, appSelector, appInterpreter, options.getReflectionSpec());
        return builder;
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeZeroOneCFABuilder(options, cache, cha, scope, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        return ZeroXCFABuilder.make(cha, options, cache, customSelector, customInterpreter, options.getReflectionSpec(), 33);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeVanillaZeroOneCFABuilder(options, cache, cha, scope, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        return ZeroXCFABuilder.make(cha, options, cache, customSelector, customInterpreter, options.getReflectionSpec(), 31);
    }

    public static SSAPropagationCallGraphBuilder makeZeroContainerCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        return new ZeroXContainerCFABuilder(cha, options, cache, appSelector, appInterpreter, options.getReflectionSpec(), 0);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneContainerCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        return new ZeroXContainerCFABuilder(cha, options, cache, appSelector, appInterpreter, options.getReflectionSpec(), 31);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneContainerCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        options.setUseConstantSpecificKeys(true);
        return new ZeroXContainerCFABuilder(cha, options, cache, appSelector, appInterpreter, options.getReflectionSpec(), 1);
    }

    public static void addDefaultBypassLogic(AnalysisOptions options, AnalysisScope scope, ClassLoader cl, IClassHierarchy cha) {
        Util.addBypassLogic(options, scope, cl, nativeSpec, cha);
    }
}

