/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.analysis.reflection.Malleable;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.ResolutionFailure;
import com.ibm.wala.util.warnings.Warnings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBasedInstanceKeys
implements InstanceKeyFactory {
    private static final boolean DEBUG = false;
    private final AnalysisOptions options;
    private final IClassHierarchy cha;

    public ClassBasedInstanceKeys(AnalysisOptions options, IClassHierarchy cha) {
        this.cha = cha;
        this.options = options;
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) {
        if (allocation == null) {
            throw new IllegalArgumentException("allocation is null");
        }
        if (Malleable.isMalleable(allocation.getDeclaredType())) {
            return null;
        }
        if (this.options.getClassTargetSelector() == null) {
            throw new IllegalStateException("options did not specify class target selector");
        }
        IClass type = this.options.getClassTargetSelector().getAllocatedTarget(node, allocation);
        if (type == null) {
            Warnings.add(ResolutionFailure.create(node, allocation));
            return null;
        }
        ConcreteTypeKey key = new ConcreteTypeKey(type);
        return key;
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
        ArrayClass type = (ArrayClass)this.options.getClassTargetSelector().getAllocatedTarget(node, allocation);
        assert (type != null);
        if (type == null) {
            Assertions._assert(type != null, "null type for " + allocation);
        }
        int i = 0;
        while (i <= dim) {
            ++i;
            if (type == null) {
                Assertions.UNREACHABLE();
            }
            type = (ArrayClass)type.getElementClass();
        }
        if (type == null) {
            return null;
        }
        ConcreteTypeKey key = new ConcreteTypeKey(type);
        return key;
    }

    @Override
    public <T> InstanceKey getInstanceKeyForConstant(TypeReference type, T S) {
        if (type == null || this.cha.lookupClass(type) == null) {
            return null;
        }
        if (this.options.getUseConstantSpecificKeys()) {
            return new ConstantKey<T>(S, this.cha.lookupClass(type));
        }
        return new ConcreteTypeKey(this.cha.lookupClass(type));
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter peiLoc, TypeReference type) {
        return new ConcreteTypeKey(this.cha.lookupClass(type));
    }

    @Override
    public InstanceKey getInstanceKeyForClassObject(TypeReference type) {
        return new ConcreteTypeKey(this.cha.lookupClass(TypeReference.JavaLangClass));
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

