/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.analysis.reflection.CloneInterpreter;
import com.ibm.wala.analysis.reflection.Malleable;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverTypeContextSelector;

public class CloneContextSelector
implements ContextSelector {
    private final ReceiverTypeContextSelector selector = new ReceiverTypeContextSelector();

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey receiver) {
        if (receiver == null) {
            return null;
        }
        if (Malleable.isMalleable(receiver.getConcreteType().getReference())) {
            return null;
        }
        if (callee.getReference().equals(CloneInterpreter.CLONE)) {
            return this.selector.getCalleeTarget(caller, site, callee, receiver);
        }
        return null;
    }

    public int getBoundOnNumberOfTargets(CGNode caller, CallSiteReference reference, IMethod targetMethod) {
        return -1;
    }

    public boolean mayUnderstand(CGNode caller, CallSiteReference site, IMethod targetMethod, InstanceKey instance) {
        if (targetMethod == null) {
            throw new IllegalArgumentException("targetMethod is null");
        }
        return targetMethod.getReference().equals(CloneInterpreter.CLONE);
    }

    public boolean contextIsIrrelevant(CGNode node, CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        return !site.getDeclaredTarget().equals(CloneInterpreter.CLONE);
    }

    public boolean allSitesDispatchIdentically(CGNode node, CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        return !site.getDeclaredTarget().equals(CloneInterpreter.CLONE);
    }
}

