/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

public class ContainerUtil {
    private static final TypeName FreezableListName = TypeName.string2TypeName("Lcom/sun/corba/se/internal/ior/FreezableList");
    public static final TypeReference FreezableList = TypeReference.findOrCreate(ClassLoaderReference.Primordial, FreezableListName);
    private static final TypeName JarAttributesName = TypeName.string2TypeName("Ljava/util/jar/Attributes");
    public static final TypeReference JarAttributes = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JarAttributesName);
    private static final Collection<TypeReference> miscContainers = HashSetFactory.make();

    static {
        miscContainers.add(FreezableList);
        miscContainers.add(JarAttributes);
    }

    public static boolean isContainer(IClass c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (ClassLoaderReference.Primordial.equals(c.getClassLoader().getReference()) && TypeReference.JavaUtilCollection.getName().getPackage().equals(c.getReference().getName().getPackage())) {
            IClass collection = c.getClassHierarchy().lookupClass(TypeReference.JavaUtilCollection);
            IClass map = c.getClassHierarchy().lookupClass(TypeReference.JavaUtilMap);
            if (c.isInterface()) {
                Collection<IClass> s;
                Assertions._assert(collection != null);
                Assertions._assert(map != null);
                try {
                    s = c.getAllImplementedInterfaces();
                }
                catch (ClassHierarchyException e) {
                    return false;
                }
                if (s.contains(collection) || s.contains(map)) {
                    return true;
                }
            } else if (c.getClassHierarchy().implementsInterface(c, collection) || c.getClassHierarchy().implementsInterface(c, map)) {
                return true;
            }
        }
        if (miscContainers.contains(c.getReference())) {
            return true;
        }
        return c.isArrayClass() && ((ArrayClass)c).getElementClass() != null && ((ArrayClass)c).getElementClass().getReference().isReferenceType();
    }
}

