/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.util.debug.Assertions;

public class LocalPointerKey
extends AbstractLocalPointerKey {
    private final CGNode node;
    private final int valueNumber;

    public LocalPointerKey(CGNode node, int valueNumber) {
        this.node = node;
        this.valueNumber = valueNumber;
        if (valueNumber <= 0) {
            Assertions._assert(valueNumber > 0, "illegal value number: " + valueNumber);
        }
    }

    public final boolean equals(Object obj) {
        if (obj instanceof LocalPointerKey) {
            LocalPointerKey other = (LocalPointerKey)obj;
            return this.node.equals(other.node) && this.valueNumber == other.valueNumber;
        }
        return false;
    }

    public final int hashCode() {
        return this.node.hashCode() * 23 + this.valueNumber;
    }

    public String toString() {
        return "[" + this.node + ", v" + this.valueNumber + "]";
    }

    public final CGNode getNode() {
        return this.node;
    }

    public final int getValueNumber() {
        return this.valueNumber;
    }

    public final boolean isParameter() {
        return this.valueNumber <= this.node.getMethod().getNumberOfParameters();
    }
}

