/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractPointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointsToMap;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StringConstantCharArray;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointerAnalysisImpl
extends AbstractPointerAnalysis {
    private final PointsToMap pointsToMap;
    private final HeapModel H;
    private final PointerKeyFactory pointerKeys;
    private final InstanceKeyFactory iKeyFactory;
    private final PropagationCallGraphBuilder builder;

    public PointerAnalysisImpl(PropagationCallGraphBuilder builder, CallGraph cg, PointsToMap pointsToMap, MutableMapping<InstanceKey> instanceKeys, PointerKeyFactory pointerKeys, InstanceKeyFactory iKeyFactory) {
        super(cg, instanceKeys);
        this.builder = builder;
        this.pointerKeys = pointerKeys;
        this.iKeyFactory = iKeyFactory;
        this.pointsToMap = pointsToMap;
        Assertions._assert(iKeyFactory != null);
        this.H = this.makeHeapModel();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("PointerAnalysis:\n");
        Iterator<PointerKey> it = this.pointsToMap.iterateKeys();
        while (it.hasNext()) {
            PointerKey p = it.next();
            OrdinalSet<InstanceKey> O = this.getPointsToSet(p);
            result.append("  ").append(p).append(" ->\n");
            Iterator<InstanceKey> it2 = O.iterator();
            while (it2.hasNext()) {
                result.append("     ").append(it2.next()).append("\n");
            }
        }
        return result.toString();
    }

    private HeapModel makeHeapModel() {
        return new HModel();
    }

    @Override
    public OrdinalSet<InstanceKey> getPointsToSet(PointerKey key) {
        ConstantKey i;
        InstanceFieldKey ifk;
        if (this.pointsToMap.isImplicit(key)) {
            return this.computeImplicitPointsToSet(key);
        }
        if (key instanceof InstanceFieldKey && (ifk = (InstanceFieldKey)key).getInstanceKey() instanceof ConstantKey && (i = (ConstantKey)ifk.getInstanceKey()).getValue() instanceof String) {
            StringConstantCharArray contents = StringConstantCharArray.make(i);
            this.instanceKeys.add(contents);
            Collection singleton = HashSetFactory.make();
            singleton.add(contents);
            return OrdinalSet.toOrdinalSet(singleton, this.instanceKeys);
        }
        PointsToSetVariable v = this.pointsToMap.getPointsToSet(key);
        Assertions._assert(key != null);
        if (v == null) {
            return OrdinalSet.empty();
        }
        MutableIntSet S = v.getValue();
        return new OrdinalSet<InstanceKey>(S, this.instanceKeys);
    }

    @Override
    public boolean isFiltered(PointerKey key) {
        if (this.pointsToMap.isImplicit(key)) {
            return false;
        }
        PointsToSetVariable v = this.pointsToMap.getPointsToSet(key);
        if (v == null) {
            return false;
        }
        return v.getPointerKey() instanceof FilteredPointerKey;
    }

    protected ImplicitPointsToSetVisitor makeImplicitPointsToVisitor(LocalPointerKey lpk) {
        return new ImplicitPointsToSetVisitor(this, lpk);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSet(PointerKey key) {
        if (key instanceof LocalPointerKey) {
            LocalPointerKey lpk = (LocalPointerKey)key;
            CGNode node = lpk.getNode();
            IR ir = node.getIR();
            DefUse du = node.getDU();
            if (((SSAPropagationCallGraphBuilder)this.builder).contentsAreInvariant(ir.getSymbolTable(), du, lpk.getValueNumber())) {
                InstanceKey[] ik = ((SSAPropagationCallGraphBuilder)this.builder).getInvariantContents(ir.getSymbolTable(), du, node, lpk.getValueNumber(), this.H, true);
                return this.toOrdinalSet(ik);
            }
            SSAInstruction def = du.getDef(lpk.getValueNumber());
            if (def != null) {
                ImplicitPointsToSetVisitor v = this.makeImplicitPointsToVisitor(lpk);
                def.visit(v);
                if (v.pointsToSet != null) {
                    return v.pointsToSet;
                }
                Assertions.UNREACHABLE("saw " + key + ": time to implement for " + def.getClass());
                return null;
            }
            Assertions.UNREACHABLE("unexpected null def for " + key);
            return null;
        }
        Assertions.UNREACHABLE("unexpected implicit key " + key + " that's not a local pointer key");
        return null;
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtPi(CGNode node, SSAPiInstruction instruction) {
        MutableSparseIntSet S = MutableSparseIntSet.makeEmpty();
        int i = 0;
        while (i < instruction.getNumberOfUses()) {
            PointerKey lpk;
            OrdinalSet<InstanceKey> pointees;
            IntSet set;
            int vn = instruction.getUse(i);
            if (vn != -1 && (set = (pointees = this.getPointsToSet(lpk = this.pointerKeys.getPointerKeyForLocal(node, vn))).getBackingSet()) != null) {
                S.addAll(set);
            }
            ++i;
        }
        return new OrdinalSet<InstanceKey>(S, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtPhi(CGNode node, SSAPhiInstruction instruction) {
        MutableSparseIntSet S = MutableSparseIntSet.makeEmpty();
        int i = 0;
        while (i < instruction.getNumberOfUses()) {
            PointerKey lpk;
            OrdinalSet<InstanceKey> pointees;
            IntSet set;
            int vn = instruction.getUse(i);
            if (vn != -1 && (set = (pointees = this.getPointsToSet(lpk = this.pointerKeys.getPointerKeyForLocal(node, vn))).getBackingSet()) != null) {
                S.addAll(set);
            }
            ++i;
        }
        return new OrdinalSet<InstanceKey>(S, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtALoad(CGNode node, SSAArrayLoadInstruction instruction) {
        PointerKey arrayRef = this.pointerKeys.getPointerKeyForLocal(node, instruction.getArrayRef());
        MutableSparseIntSet S = MutableSparseIntSet.makeEmpty();
        OrdinalSet<InstanceKey> refs = this.getPointsToSet(arrayRef);
        for (InstanceKey ik : refs) {
            PointerKey key = this.pointerKeys.getPointerKeyForArrayContents(ik);
            OrdinalSet<InstanceKey> pointees = this.getPointsToSet(key);
            IntSet set = pointees.getBackingSet();
            if (set == null) continue;
            S.addAll(set);
        }
        return new OrdinalSet<InstanceKey>(S, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtGet(CGNode node, SSAGetInstruction instruction) {
        return this.computeImplicitPointsToSetAtGet(node, instruction.getDeclaredField(), instruction.getRef(), instruction.isStatic());
    }

    public OrdinalSet<InstanceKey> computeImplicitPointsToSetAtGet(CGNode node, FieldReference field, int refVn, boolean isStatic) {
        IField f = this.getCallGraph().getClassHierarchy().resolveField(field);
        if (f == null) {
            return OrdinalSet.empty();
        }
        if (isStatic) {
            PointerKey fKey = this.pointerKeys.getPointerKeyForStaticField(f);
            return this.getPointsToSet(fKey);
        }
        PointerKey ref = this.pointerKeys.getPointerKeyForLocal(node, refVn);
        MutableSparseIntSet S = MutableSparseIntSet.makeEmpty();
        OrdinalSet<InstanceKey> refs = this.getPointsToSet(ref);
        for (InstanceKey ik : refs) {
            PointerKey fkey = this.pointerKeys.getPointerKeyForInstanceField(ik, f);
            OrdinalSet<InstanceKey> pointees = this.getPointsToSet(fkey);
            IntSet set = pointees.getBackingSet();
            if (set == null) continue;
            S.addAll(set);
        }
        return new OrdinalSet<InstanceKey>(S, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtCatch(CGNode node, SSAGetCaughtExceptionInstruction instruction) {
        IR ir = node.getIR();
        List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(ir, ir.getBasicBlockForCatch(instruction));
        Set<TypeReference> caughtTypes = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(instruction, ir);
        MutableSparseIntSet S = MutableSparseIntSet.makeEmpty();
        for (ProgramCounter peiLoc : peis) {
            Collection<TypeReference> types;
            SSAInstruction s;
            SSAInstruction pei = ir.getPEI(peiLoc);
            PointerKey e = null;
            if (pei instanceof SSAAbstractInvokeInstruction) {
                s = (SSAAbstractInvokeInstruction)pei;
                e = this.pointerKeys.getPointerKeyForLocal(node, ((SSAAbstractInvokeInstruction)s).getException());
            } else if (pei instanceof SSAThrowInstruction) {
                s = (SSAThrowInstruction)pei;
                e = this.pointerKeys.getPointerKeyForLocal(node, ((SSAAbstractThrowInstruction)s).getException());
            }
            if (e != null) {
                OrdinalSet<InstanceKey> ep = this.getPointsToSet(e);
                for (InstanceKey ik : ep) {
                    if (!PropagationCallGraphBuilder.catches(caughtTypes, ik.getConcreteType(), this.getCallGraph().getClassHierarchy())) continue;
                    S.add(this.instanceKeys.getMappedIndex(ik));
                }
            }
            if ((types = pei.getExceptionTypes()) == null) continue;
            for (TypeReference type : types) {
                InstanceKey ik;
                ConcreteTypeKey ck;
                IClass klass;
                if (type == null || !PropagationCallGraphBuilder.catches(caughtTypes, klass = (ck = (ConcreteTypeKey)(ik = SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(node, peiLoc, type, this.iKeyFactory))).getType(), this.getCallGraph().getClassHierarchy())) continue;
                S.add(this.instanceKeys.getMappedIndex(SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(node, peiLoc, type, this.iKeyFactory)));
            }
        }
        return new OrdinalSet<InstanceKey>(S, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtCheckCast(CGNode node, SSACheckCastInstruction instruction) {
        PointerKey rhs = this.pointerKeys.getPointerKeyForLocal(node, instruction.getVal());
        OrdinalSet<InstanceKey> rhsSet = this.getPointsToSet(rhs);
        MutableSparseIntSet S = MutableSparseIntSet.makeEmpty();
        IClass klass = this.getCallGraph().getClassHierarchy().lookupClass(instruction.getDeclaredResultType());
        if (klass == null) {
            return rhsSet;
        }
        if (klass.isInterface()) {
            for (InstanceKey ik : rhsSet) {
                if (!this.getCallGraph().getClassHierarchy().implementsInterface(ik.getConcreteType(), klass)) continue;
                S.add(this.getInstanceKeyMapping().getMappedIndex(ik));
            }
        } else {
            for (InstanceKey ik : rhsSet) {
                if (!this.getCallGraph().getClassHierarchy().isSubclassOf(ik.getConcreteType(), klass)) continue;
                S.add(this.getInstanceKeyMapping().getMappedIndex(ik));
            }
        }
        return new OrdinalSet<InstanceKey>(S, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtCall(LocalPointerKey lpk, CGNode node, SSAInvokeInstruction call) {
        int exc = call.getException();
        if (lpk.getValueNumber() == exc) {
            return this.computeImplicitExceptionsForCall(node, call);
        }
        Assertions.UNREACHABLE("time to implement me.");
        return null;
    }

    private OrdinalSet<InstanceKey> toOrdinalSet(InstanceKey[] ik) {
        MutableSparseIntSet s = MutableSparseIntSet.makeEmpty();
        int i = 0;
        while (i < ik.length) {
            int index = this.instanceKeys.getMappedIndex(ik[i]);
            if (index != -1) {
                s.add(index);
            } else {
                Assertions._assert(index != -1, "instance " + ik[i] + " not mapped!");
            }
            ++i;
        }
        return new OrdinalSet<InstanceKey>(s, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitExceptionsForCall(CGNode node, SSAInvokeInstruction call) {
        MutableSparseIntSet S = MutableSparseIntSet.makeEmpty();
        for (CGNode target : this.getCallGraph().getPossibleTargets(node, call.getCallSite())) {
            PointerKey retVal = this.pointerKeys.getPointerKeyForExceptionalReturnValue(target);
            IntSet set = this.getPointsToSet(retVal).getBackingSet();
            if (set == null) continue;
            S.addAll(set);
        }
        return new OrdinalSet<InstanceKey>(S, this.instanceKeys);
    }

    @Override
    public HeapModel getHeapModel() {
        return this.H;
    }

    @Override
    public Collection<PointerKey> getPointerKeys() {
        return Iterator2Collection.toCollection(this.pointsToMap.iterateKeys());
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.builder.getClassHierarchy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HModel
    implements HeapModel {
        private HModel() {
        }

        @Override
        public Iterator<PointerKey> iteratePointerKeys() {
            return PointerAnalysisImpl.this.pointsToMap.iterateKeys();
        }

        @Override
        public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) {
            return PointerAnalysisImpl.this.iKeyFactory.getInstanceKeyForAllocation(node, allocation);
        }

        @Override
        public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
            return PointerAnalysisImpl.this.iKeyFactory.getInstanceKeyForMultiNewArray(node, allocation, dim);
        }

        @Override
        public <T> InstanceKey getInstanceKeyForConstant(TypeReference type, T S) {
            return PointerAnalysisImpl.this.iKeyFactory.getInstanceKeyForConstant(type, S);
        }

        @Override
        public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter peiLoc, TypeReference type) {
            Assertions.UNREACHABLE();
            return null;
        }

        @Override
        public InstanceKey getInstanceKeyForClassObject(TypeReference type) {
            Assertions.UNREACHABLE();
            return null;
        }

        @Override
        public PointerKey getPointerKeyForLocal(CGNode node, int valueNumber) {
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForLocal(node, valueNumber);
        }

        @Override
        public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, FilteredPointerKey.TypeFilter filter) {
            return PointerAnalysisImpl.this.pointerKeys.getFilteredPointerKeyForLocal(node, valueNumber, filter);
        }

        @Override
        public PointerKey getPointerKeyForReturnValue(CGNode node) {
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForReturnValue(node);
        }

        @Override
        public PointerKey getPointerKeyForExceptionalReturnValue(CGNode node) {
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForExceptionalReturnValue(node);
        }

        @Override
        public PointerKey getPointerKeyForStaticField(IField f) {
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForStaticField(f);
        }

        @Override
        public PointerKey getPointerKeyForInstanceField(InstanceKey I, IField field) {
            assert (field != null);
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForInstanceField(I, field);
        }

        @Override
        public PointerKey getPointerKeyForArrayContents(InstanceKey I) {
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForArrayContents(I);
        }

        @Override
        public IClassHierarchy getClassHierarchy() {
            return PointerAnalysisImpl.this.getCallGraph().getClassHierarchy();
        }
    }

    protected static class ImplicitPointsToSetVisitor
    extends SSAInstruction.Visitor {
        protected final PointerAnalysisImpl analysis;
        protected final CGNode node;
        protected final LocalPointerKey lpk;
        protected OrdinalSet<InstanceKey> pointsToSet = null;

        protected ImplicitPointsToSetVisitor(PointerAnalysisImpl analysis, LocalPointerKey lpk) {
            this.lpk = lpk;
            this.node = lpk.getNode();
            this.analysis = analysis;
        }

        public void visitNew(SSANewInstruction instruction) {
            this.pointsToSet = OrdinalSet.empty();
        }

        public void visitInvoke(SSAInvokeInstruction instruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtCall(this.lpk, this.node, instruction);
        }

        public void visitCheckCast(SSACheckCastInstruction instruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtCheckCast(this.node, instruction);
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtCatch(this.node, instruction);
        }

        public void visitGet(SSAGetInstruction instruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtGet(this.node, instruction);
        }

        public void visitPhi(SSAPhiInstruction instruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtPhi(this.node, instruction);
        }

        public void visitPi(SSAPiInstruction instruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtPi(this.node, instruction);
        }

        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtALoad(this.node, instruction);
        }
    }
}

