/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ReferenceCleanser;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.Trace;
import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointerFlowGraph
extends AbstractGraph<PointerKey> {
    protected final PointerAnalysis pa;
    protected final CallGraph cg;
    protected final SlowSparseNumberedGraph<PointerKey> delegate = SlowSparseNumberedGraph.make();
    private final Collection<CGNode> processedNodes = HashSetFactory.make();
    private final EdgeManager<PointerKey> edgeManager = new LazyEdgeManager();
    private static int wipeCount = 0;
    private static final int WIPE_THRESHOLD = 1000;

    protected PointerFlowGraph(PointerAnalysis pa, CallGraph cg) throws IllegalArgumentException {
        this.pa = pa;
        this.cg = cg;
        if (cg == null) {
            throw new IllegalArgumentException("cg cannot be null");
        }
    }

    private void processAllNodes() {
        for (CGNode node : this.cg) {
            if (this.processedNodes.contains(node)) continue;
            this.processNode(node);
        }
    }

    private void processCallers(CGNode node) {
        Iterator<CGNode> it = this.cg.getPredNodes(node);
        while (it.hasNext()) {
            CGNode p = it.next();
            if (this.processedNodes.contains(p)) continue;
            this.processNode(p);
        }
    }

    @Override
    public NodeManager<PointerKey> getNodeManager() {
        return this.delegate.getNodeManager();
    }

    @Override
    protected EdgeManager<PointerKey> getEdgeManager() {
        return this.edgeManager;
    }

    private void processNode(CGNode node) {
        Assertions._assert(!this.processedNodes.contains(node));
        this.processedNodes.add(node);
        IR ir = PointerFlowGraph.getIR(node);
        if (ir != null) {
            this.visit(node, ir);
        } else {
            Trace.println("PointerFlowGraph.build got null ir for " + node);
        }
    }

    private static IR getIR(CGNode node) {
        if (++wipeCount > 1000) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
        return node.getIR();
    }

    private void visit(CGNode node, IR ir) {
        for (SSACFG.BasicBlock bb : ir.getControlFlowGraph()) {
            InstructionVisitor v = this.makeInstructionVisitor(node, ir, bb);
            for (SSAInstruction i : bb) {
                if (i == null) continue;
                i.visit(v);
            }
        }
        List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(ir, ir.getExitBlock());
        PointerKey exception = this.pa.getHeapModel().getPointerKeyForExceptionalReturnValue(node);
        PointerFlowGraph.addExceptionEdges(node, this.delegate, this.pa, ir, peis, exception);
    }

    protected InstructionVisitor makeInstructionVisitor(CGNode node, IR ir, SSACFG.BasicBlock bb) {
        return new InstructionVisitor(this.pa, this.cg, this.delegate, node, ir, bb);
    }

    private static void addExceptionEdges(CGNode node, Graph<PointerKey> delegate, PointerAnalysis pa, IR ir, List<ProgramCounter> peis, PointerKey exceptionVar) {
        delegate.addNode(exceptionVar);
        for (ProgramCounter peiLoc : peis) {
            PointerKey e;
            SSAInstruction s;
            SSAInstruction pei = ir.getPEI(peiLoc);
            if (pei instanceof SSAAbstractInvokeInstruction) {
                s = (SSAAbstractInvokeInstruction)pei;
                e = pa.getHeapModel().getPointerKeyForLocal(node, ((SSAAbstractInvokeInstruction)s).getException());
                delegate.addNode(e);
                delegate.addEdge(e, exceptionVar);
                continue;
            }
            if (!(pei instanceof SSAThrowInstruction)) continue;
            s = (SSAThrowInstruction)pei;
            e = pa.getHeapModel().getPointerKeyForLocal(node, ((SSAAbstractThrowInstruction)s).getException());
            delegate.addNode(e);
            delegate.addEdge(e, exceptionVar);
        }
    }

    public PointerAnalysis getPointerAnalysis() {
        return this.pa;
    }

    @Override
    public Iterator<PointerKey> iterator() {
        this.processAllNodes();
        return super.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstructionVisitor
    extends SSAInstruction.Visitor {
        private final CGNode node;
        private final IR ir;
        private final ISSABasicBlock bb;
        private final PointerAnalysis pa;
        private final Graph<PointerKey> delegate;
        private final CallGraph cg;

        public InstructionVisitor(PointerAnalysis pa, CallGraph cg, Graph<PointerKey> delegate, CGNode node, IR ir, SSACFG.BasicBlock bb) {
            this.delegate = delegate;
            this.node = node;
            this.ir = ir;
            this.bb = bb;
            this.pa = pa;
            this.cg = cg;
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            PointerKey result = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getDef());
            PointerKey arrayRef = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getArrayRef());
            if (result == null) {
                return;
            }
            this.delegate.addNode(result);
            for (InstanceKey ik : this.pa.getPointsToSet(arrayRef)) {
                TypeReference C = ik.getConcreteType().getReference().getArrayElementType();
                if (C.isPrimitiveType()) {
                    return;
                }
                PointerKey p = this.pa.getHeapModel().getPointerKeyForArrayContents(ik);
                if (p == null) {
                    return;
                }
                this.delegate.addNode(p);
                this.delegate.addEdge(p, result);
            }
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            PointerKey value = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getValue());
            PointerKey arrayRef = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getArrayRef());
            if (value == null || arrayRef == null) {
                return;
            }
            this.delegate.addNode(value);
            for (InstanceKey ik : this.pa.getPointsToSet(arrayRef)) {
                TypeReference C = ik.getConcreteType().getReference().getArrayElementType();
                if (C.isPrimitiveType()) {
                    return;
                }
                PointerKey p = this.pa.getHeapModel().getPointerKeyForArrayContents(ik);
                if (p == null) {
                    return;
                }
                this.delegate.addNode(p);
                this.delegate.addEdge(value, p);
            }
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            PointerKey result = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getResult());
            PointerKey value = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getVal());
            if (value != null) {
                this.delegate.addNode(value);
                this.delegate.addNode(result);
                this.delegate.addEdge(value, result);
            }
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
            PointerKey result = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getDef());
            PointerKey value = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getVal());
            this.delegate.addNode(value);
            this.delegate.addNode(result);
            this.delegate.addEdge(value, result);
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
            if (instruction.returnsPrimitiveType() || instruction.returnsVoid()) {
                return;
            }
            PointerKey returnValue = this.pa.getHeapModel().getPointerKeyForReturnValue(this.node);
            PointerKey result = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getResult());
            if (result == null) {
                return;
            }
            this.delegate.addNode(returnValue);
            this.delegate.addNode(result);
            this.delegate.addEdge(result, returnValue);
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            FieldReference field = instruction.getDeclaredField();
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            PointerKey def = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getDef());
            this.delegate.addNode(def);
            IField f = this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                return;
            }
            if (instruction.isStatic()) {
                PointerKey fKey = this.pa.getHeapModel().getPointerKeyForStaticField(f);
                this.delegate.addNode(fKey);
                this.delegate.addEdge(fKey, def);
            } else {
                PointerKey ref = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getRef());
                for (InstanceKey ik : this.pa.getPointsToSet(ref)) {
                    PointerKey p = this.pa.getHeapModel().getPointerKeyForInstanceField(ik, f);
                    this.delegate.addNode(p);
                    this.delegate.addEdge(p, def);
                }
            }
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            FieldReference field = instruction.getDeclaredField();
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                return;
            }
            PointerKey val = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getVal());
            if (val == null) {
                return;
            }
            if (instruction.isStatic()) {
                PointerKey fKey = this.pa.getHeapModel().getPointerKeyForStaticField(f);
                this.delegate.addNode(fKey);
                this.delegate.addNode(val);
                this.delegate.addEdge(val, fKey);
            } else {
                PointerKey ref = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getRef());
                for (InstanceKey ik : this.pa.getPointsToSet(ref)) {
                    PointerKey p = this.pa.getHeapModel().getPointerKeyForInstanceField(ik, f);
                    if (p == null) {
                        Assertions.UNREACHABLE();
                    }
                    this.delegate.addNode(val);
                    this.delegate.addNode(p);
                    this.delegate.addEdge(val, p);
                }
            }
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            for (CGNode target : this.cg.getPossibleTargets(this.node, instruction.getCallSite())) {
                if (PointerFlowGraph.getIR(target) == null) continue;
                int i = 0;
                while (i < instruction.getNumberOfUses()) {
                    int vn = i + 1;
                    if (target.getMethod().getParameterType(i).isReferenceType()) {
                        PointerKey actual = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getUse(i));
                        PointerKey formal = this.pa.getHeapModel().getPointerKeyForLocal(target, vn);
                        if (actual != null) {
                            this.delegate.addNode(actual);
                            if (formal != null) {
                                this.delegate.addNode(formal);
                                this.delegate.addEdge(actual, formal);
                            }
                        }
                    }
                    ++i;
                }
                if (instruction.hasDef() && instruction.getDeclaredResultType().isReferenceType()) {
                    PointerKey result = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getDef());
                    PointerKey ret = this.pa.getHeapModel().getPointerKeyForReturnValue(target);
                    this.delegate.addNode(result);
                    this.delegate.addNode(ret);
                    this.delegate.addEdge(ret, result);
                }
                PointerKey e = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getException());
                PointerKey er = this.pa.getHeapModel().getPointerKeyForExceptionalReturnValue(target);
                this.delegate.addNode(e);
                this.delegate.addNode(er);
                this.delegate.addEdge(er, e);
            }
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.bb);
            PointerKey def = this.pa.getHeapModel().getPointerKeyForLocal(this.node, instruction.getDef());
            PointerFlowGraph.addExceptionEdges(this.node, this.delegate, this.pa, this.ir, peis, def);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LazyEdgeManager
    implements EdgeManager<PointerKey> {
        private LazyEdgeManager() {
        }

        private void lazySucc(Object N) {
            if (N instanceof AbstractLocalPointerKey) {
                AbstractLocalPointerKey lpk = (AbstractLocalPointerKey)N;
                CGNode node = lpk.getNode();
                if (!PointerFlowGraph.this.processedNodes.contains(node)) {
                    PointerFlowGraph.this.processNode(node);
                }
                if (lpk instanceof ReturnValueKey) {
                    PointerFlowGraph.this.processCallers(node);
                }
            } else {
                PointerFlowGraph.this.processAllNodes();
            }
        }

        private void lazyPred(Object N) {
            if (N instanceof AbstractLocalPointerKey) {
                LocalPointerKey p;
                AbstractLocalPointerKey lpk = (AbstractLocalPointerKey)N;
                CGNode node = lpk.getNode();
                if (!PointerFlowGraph.this.processedNodes.contains(node)) {
                    PointerFlowGraph.this.processNode(node);
                }
                if (lpk instanceof LocalPointerKey && (p = (LocalPointerKey)lpk).isParameter()) {
                    PointerFlowGraph.this.processCallers(node);
                }
            } else {
                PointerFlowGraph.this.processAllNodes();
            }
        }

        @Override
        public Iterator<? extends PointerKey> getPredNodes(PointerKey N) {
            this.lazyPred(N);
            return PointerFlowGraph.this.delegate.getPredNodes(N);
        }

        @Override
        public int getPredNodeCount(PointerKey N) {
            this.lazyPred(N);
            return PointerFlowGraph.this.delegate.getPredNodeCount(N);
        }

        @Override
        public Iterator<? extends PointerKey> getSuccNodes(PointerKey N) {
            this.lazySucc(N);
            return PointerFlowGraph.this.delegate.getSuccNodes(N);
        }

        @Override
        public int getSuccNodeCount(PointerKey N) {
            this.lazySucc(N);
            return PointerFlowGraph.this.delegate.getSuccNodeCount(N);
        }

        @Override
        public void addEdge(PointerKey src, PointerKey dst) {
            PointerFlowGraph.this.delegate.addEdge(src, dst);
        }

        @Override
        public void removeEdge(PointerKey src, PointerKey dst) {
            PointerFlowGraph.this.delegate.removeEdge(src, dst);
        }

        @Override
        public void removeAllIncidentEdges(PointerKey node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeIncomingEdges(PointerKey node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeOutgoingEdges(PointerKey node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public boolean hasEdge(PointerKey src, PointerKey dst) {
            this.lazySucc(src);
            this.lazyPred(dst);
            return PointerFlowGraph.this.delegate.hasEdge(src, dst);
        }
    }
}

