/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.eclipse.util.CancelException;
import com.ibm.wala.fixedpoint.impl.AbstractFixedPointSolver;
import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixedpoint.impl.UnaryStatement;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ipa.callgraph.propagation.AbstractPointsToSolver;
import com.ibm.wala.ipa.callgraph.propagation.IPointerOperator;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreTransitiveSolver
extends AbstractPointsToSolver {
    public PreTransitiveSolver(PropagationSystem system, PropagationCallGraphBuilder builder) {
        super(system, builder);
    }

    @Override
    public void solve() throws IllegalArgumentException, CancelException {
        this.getBuilder().addConstraintsFromNewNodes();
        boolean changed = false;
        do {
            changed = false;
            BitVectorIntSet visited = new BitVectorIntSet();
            this.getSystem().revertToPreTransitive();
            Collection<IVariable> complexUses = this.findComplexUses();
            NumberedGraph<PointsToSetVariable> ag = this.getSystem().getAssignmentGraph();
            for (PointsToSetVariable pointsToSetVariable : complexUses) {
                this.getLvals(ag, pointsToSetVariable.getPointerKey(), new Path(), visited);
                Iterator<AbstractStatement> it2 = this.getSystem().getStatementsThatUse(pointsToSetVariable);
                while (it2.hasNext()) {
                    AbstractStatement s = it2.next();
                    if (!this.isComplexStatement(s)) continue;
                    byte code = s.evaluate();
                    changed |= AbstractFixedPointSolver.isChanged(code);
                    changed |= AbstractFixedPointSolver.isSideEffect(code);
                }
            }
            if ((changed |= this.getBuilder().addConstraintsFromNewNodes()) || this.getReflectionHandler() == null) continue;
            changed |= this.getReflectionHandler().updateForReflection();
        } while (changed);
    }

    private boolean isComplexStatement(AbstractStatement s) {
        IPointerOperator op = (IPointerOperator)s.getOperator();
        return op.isComplex() || op instanceof PropagationCallGraphBuilder.FilterOperator;
    }

    private IntSet getLvals(Graph<PointsToSetVariable> ag, PointerKey p, Path path, MutableIntSet visited) {
        if (path.contains(this.getSystem().getNumber(p))) {
            if (path.size() > 1) {
                this.unifyCycle(path, this.getSystem().getNumber(p));
            }
            PointsToSetVariable v = this.getSystem().findOrCreatePointsToSet(p);
            return v.getValue();
        }
        path.add(this.getSystem().getNumber(p));
        PointsToSetVariable v = this.getSystem().findOrCreatePointsToSet(p);
        if (visited.contains(this.getSystem().getNumber(p))) {
            path.remove(this.getSystem().getNumber(p));
            return v.getValue();
        }
        visited.add(this.getSystem().getNumber(p));
        MutableIntSet result = IntSetUtil.getDefaultIntSetFactory().make();
        if (v.getValue() != null) {
            result.addAll(v.getValue());
        }
        Iterator2Collection<PointsToSetVariable> origPred = Iterator2Collection.toCollection(ag.getPredNodes(v));
        for (PointsToSetVariable n : origPred) {
            IntSet lvals;
            PointerKey pk = n.getPointerKey();
            if (this.getSystem().isUnified(n.getPointerKey())) {
                n = this.getSystem().findOrCreatePointsToSet(pk);
                pk = n.getPointerKey();
            }
            if ((lvals = this.getLvals(ag, pk, path, visited)) == null) continue;
            result.addAll(lvals);
        }
        path.remove(this.getSystem().getNumber(p));
        v.addAll(result);
        return result;
    }

    private void unifyCycle(Path path, int number) {
        Integer i;
        MutableSparseIntSet cycle = MutableSparseIntSet.makeEmpty();
        cycle.add(number);
        int index = path.size() - 1;
        while ((i = path.get(index--)) != number) {
            cycle.add(i);
        }
        if (cycle.size() > 1) {
            this.getSystem().unify(cycle);
        }
    }

    public Collection<IVariable> findComplexUses() {
        HashSet<IVariable> result = HashSetFactory.make();
        Iterator it = this.getSystem().getStatements();
        while (it.hasNext()) {
            AbstractStatement s = (AbstractStatement)it.next();
            if (!this.isComplexStatement(s)) continue;
            if (s instanceof UnaryStatement) {
                UnaryStatement u = (UnaryStatement)s;
                result.add((IVariable)u.getRightHandSide());
                continue;
            }
            IVariable[] rhs = s.getRHS();
            int i = 0;
            while (i < rhs.length) {
                result.add(rhs[i]);
                ++i;
            }
        }
        return result;
    }

    private static class Path {
        final MutableIntSet contents = new BimodalMutableIntSet();
        final ArrayList<Integer> sequence = new ArrayList();

        private Path() {
        }

        public boolean contains(int number) {
            return this.contents.contains(number);
        }

        public Integer get(int i) {
            return this.sequence.get(i);
        }

        public void remove(int number) {
            Assertions._assert(this.sequence.get(this.sequence.size() - 1) == number);
            this.sequence.remove(this.sequence.size() - 1);
            this.contents.remove(number);
        }

        public void add(int number) {
            this.sequence.add(new Integer(number));
            this.contents.add(number);
        }

        public int size() {
            return this.contents.size();
        }
    }
}

