/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticClass;
import com.ibm.wala.eclipse.util.CancelException;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AssignOperator;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.IPointerOperator;
import com.ibm.wala.ipa.callgraph.propagation.IPointsToSolver;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerFlowGraphFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.UnarySideEffect;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropagationCallGraphBuilder
implements CallGraphBuilder {
    private static final boolean DEBUG_ALL = false;
    static final boolean DEBUG_ASSIGN = false;
    private static final boolean DEBUG_ARRAY_LOAD = false;
    private static final boolean DEBUG_ARRAY_STORE = false;
    private static final boolean DEBUG_FILTER = false;
    protected static final boolean DEBUG_GENERAL = false;
    private static final boolean DEBUG_GET = false;
    private static final boolean DEBUG_PUT = false;
    private static final boolean DEBUG_ENTRYPOINTS = false;
    static final boolean DEBUG_TRACK_INSTANCE = false;
    static final int DEBUG_INSTANCE_KEY = 7900;
    protected final PointerKeyFactory pointerKeyFactory;
    private final IClass JAVA_LANG_OBJECT;
    private final IClass JAVA_LANG_THROWABLE;
    public static final Set<TypeReference> THROWABLE_SET = Collections.singleton(TypeReference.JavaLangThrowable);
    protected final IClassHierarchy cha;
    protected final AnalysisOptions options;
    private final AnalysisCache analysisCache;
    private final Set<CGNode> alreadyVisited = HashSetFactory.make();
    private Set<CGNode> discoveredNodes = HashSetFactory.make();
    protected final Set<CallSiteReference> entrypointCallSites = HashSetFactory.make();
    protected PropagationSystem system;
    private IPointsToSolver solver;
    protected final ExplicitCallGraph callGraph;
    protected static final AssignOperator assignOperator = new AssignOperator();
    public final FilterOperator filterOperator = new FilterOperator();
    protected final InverseFilterOperator inverseFilterOperator = new InverseFilterOperator();
    private SSAContextInterpreter contextInterpreter;
    protected ContextSelector contextSelector;
    protected InstanceKeyFactory instanceKeyFactory;
    private final boolean rememberGetPutHistory = true;

    protected PropagationCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache, PointerKeyFactory pointerKeyFactory) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        assert (cache != null);
        this.cha = cha;
        this.options = options;
        this.analysisCache = cache;
        Assertions._assert(pointerKeyFactory != null);
        this.pointerKeyFactory = pointerKeyFactory;
        this.callGraph = this.createEmptyCallGraph(cha, options);
        this.callGraph.init();
        this.callGraph.setInterpreter(this.contextInterpreter);
        this.JAVA_LANG_OBJECT = cha.lookupClass(TypeReference.JavaLangObject);
        this.JAVA_LANG_THROWABLE = cha.lookupClass(TypeReference.JavaLangThrowable);
    }

    protected ExplicitCallGraph createEmptyCallGraph(IClassHierarchy cha, AnalysisOptions options) {
        return new ExplicitCallGraph(cha, options, this.getAnalysisCache());
    }

    protected boolean isJavaLangObject(IClass klass) {
        return klass.getReference().equals(TypeReference.JavaLangObject);
    }

    @Override
    public CallGraph makeCallGraph(AnalysisOptions options) throws IllegalArgumentException, CancelException {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        this.system = this.makeSystem(options);
        this.system.setMinEquationsForTopSort(options.getMinEquationsForTopSort());
        this.system.setTopologicalGrowthFactor(options.getTopologicalGrowthFactor());
        this.system.setMaxEvalBetweenTopo(options.getMaxEvalBetweenTopo());
        this.discoveredNodes = HashSetFactory.make();
        this.discoveredNodes.add(this.callGraph.getFakeRootNode());
        for (Entrypoint E : options.getEntrypoints()) {
            SSAAbstractInvokeInstruction call = E.addCall((AbstractRootMethod)this.callGraph.getFakeRootNode().getMethod());
            if (call == null) {
                Warnings.add(EntrypointResolutionWarning.create(E));
                continue;
            }
            this.entrypointCallSites.add(call.getCallSite());
        }
        this.customInit();
        this.solver = this.makeSolver();
        this.solver.solve();
        return this.callGraph;
    }

    protected PropagationSystem makeSystem(AnalysisOptions options) {
        return new PropagationSystem(this.callGraph, this.pointerKeyFactory, this.instanceKeyFactory, options.getSupportRefinement());
    }

    protected abstract IPointsToSolver makeSolver();

    protected void customInit() {
    }

    protected abstract boolean addConstraintsFromNode(CGNode var1);

    protected boolean addConstraintsFromNewNodes() {
        boolean result = false;
        while (!this.discoveredNodes.isEmpty()) {
            Iterator<CGNode> it = this.discoveredNodes.iterator();
            this.discoveredNodes = HashSetFactory.make();
            while (it.hasNext()) {
                CGNode n = it.next();
                result |= this.addConstraintsFromNode(n);
            }
        }
        return result;
    }

    public PointerKey getPointerKeyForLocal(CGNode node, int valueNumber) {
        return this.pointerKeyFactory.getPointerKeyForLocal(node, valueNumber);
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, FilteredPointerKey.TypeFilter filter) {
        Assertions._assert(filter != null);
        return this.pointerKeyFactory.getFilteredPointerKeyForLocal(node, valueNumber, filter);
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, IClass filter) {
        return this.getFilteredPointerKeyForLocal(node, valueNumber, new FilteredPointerKey.SingleClassFilter(filter));
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, InstanceKey filter) {
        return this.getFilteredPointerKeyForLocal(node, valueNumber, new FilteredPointerKey.SingleInstanceFilter(filter));
    }

    public PointerKey getPointerKeyForReturnValue(CGNode node) {
        return this.pointerKeyFactory.getPointerKeyForReturnValue(node);
    }

    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode node) {
        return this.pointerKeyFactory.getPointerKeyForExceptionalReturnValue(node);
    }

    public PointerKey getPointerKeyForStaticField(IField f) {
        Assertions._assert(f != null, "null FieldReference");
        return this.pointerKeyFactory.getPointerKeyForStaticField(f);
    }

    public PointerKey getPointerKeyForInstanceField(InstanceKey I, IField field) {
        if (field == null) {
            throw new IllegalArgumentException("field is null");
        }
        if (I == null) {
            throw new IllegalArgumentException("I is null");
        }
        IClass t = field.getDeclaringClass();
        IClass C = I.getConcreteType();
        if (!(C instanceof SyntheticClass) && !this.getClassHierarchy().isSubclassOf(C, t)) {
            return null;
        }
        return this.pointerKeyFactory.getPointerKeyForInstanceField(I, field);
    }

    public PointerKey getPointerKeyForArrayContents(InstanceKey I) {
        if (I == null) {
            throw new IllegalArgumentException("I is null");
        }
        IClass C = I.getConcreteType();
        if (!C.isArrayClass()) {
            Assertions._assert(false, "illegal arguments: " + I);
        }
        return this.pointerKeyFactory.getPointerKeyForArrayContents(I);
    }

    protected void assignInstanceToCatch(PointerKey exceptionVar, Set catchClasses, InstanceKey e) {
        if (PropagationCallGraphBuilder.catches(catchClasses, e.getConcreteType(), this.cha)) {
            this.system.newConstraint(exceptionVar, e);
        }
    }

    protected void addAssignmentsForCatchPointerKey(PointerKey exceptionVar, Set catchClasses, PointerKey e) {
        for (TypeReference T : catchClasses) {
            IClass C = this.cha.lookupClass(T);
            if (C == null) {
                Warnings.add(ExceptionLookupFailure.create(T));
                continue;
            }
            if (C.getReference().equals(TypeReference.JavaLangThrowable)) {
                this.system.newConstraint(exceptionVar, assignOperator, e);
                continue;
            }
            TypedPointerKey typedException = TypedPointerKey.make(exceptionVar, C);
            this.system.newConstraint((PointerKey)typedException, this.filterOperator, e);
            this.system.newConstraint(exceptionVar, assignOperator, (PointerKey)typedException);
        }
    }

    public static boolean catches(Set catchClasses, IClass klass, IClassHierarchy cha) {
        if (catchClasses == null) {
            throw new IllegalArgumentException("catchClasses is null");
        }
        Assertions._assert(catchClasses.size() > 0);
        if (catchClasses == THROWABLE_SET) {
            return true;
        }
        for (TypeReference T : catchClasses) {
            IClass C = cha.lookupClass(T);
            if (C == null || !cha.isAssignableFrom(C, klass)) continue;
            return true;
        }
        return false;
    }

    public static boolean representsNullType(InstanceKey key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        IClass cls = key.getConcreteType();
        Language L = cls.getClassLoader().getLanguage();
        return L.isNullType(cls.getReference());
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public AnalysisOptions getOptions() {
        return this.options;
    }

    public IClass getJavaLangObject() {
        return this.JAVA_LANG_OBJECT;
    }

    public IClass getJavaLangThrowable() {
        return this.JAVA_LANG_THROWABLE;
    }

    public ExplicitCallGraph getCallGraph() {
        return this.callGraph;
    }

    public void setContextInterpreter(SSAContextInterpreter interpreter) {
        this.contextInterpreter = interpreter;
        this.callGraph.setInterpreter(interpreter);
    }

    @Override
    public PointerAnalysis getPointerAnalysis() {
        return this.system.extractPointerAnalysis(this);
    }

    @Override
    public PointerFlowGraphFactory getPointerFlowGraphFactory() {
        return new PointerFlowGraphFactory();
    }

    public PropagationSystem getPropagationSystem() {
        return this.system;
    }

    public PointerKeyFactory getPointerKeyFactory() {
        return this.pointerKeyFactory;
    }

    public RTAContextInterpreter getContextInterpreter() {
        return this.contextInterpreter;
    }

    public CGNode getTargetForCall(CGNode caller, CallSiteReference site, InstanceKey iKey) {
        IClass recv = iKey != null ? iKey.getConcreteType() : null;
        IMethod targetMethod = this.options.getMethodTargetSelector().getCalleeTarget(caller, site, recv);
        if (targetMethod == null || targetMethod.isAbstract()) {
            return null;
        }
        Context targetContext = this.contextSelector.getCalleeTarget(caller, site, targetMethod, iKey);
        return this.getCallGraph().findOrCreateNode(targetMethod, targetContext);
    }

    public ContextSelector getContextSelector() {
        return this.contextSelector;
    }

    public void setContextSelector(ContextSelector selector) {
        this.contextSelector = selector;
    }

    public InstanceKeyFactory getInstanceKeys() {
        return this.instanceKeyFactory;
    }

    public void setInstanceKeys(InstanceKeyFactory keys) {
        this.instanceKeyFactory = keys;
    }

    public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) {
        return this.instanceKeyFactory.getInstanceKeyForAllocation(node, allocation);
    }

    public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
        return this.instanceKeyFactory.getInstanceKeyForMultiNewArray(node, allocation, dim);
    }

    public <T> InstanceKey getInstanceKeyForConstant(TypeReference type, T S) {
        return this.instanceKeyFactory.getInstanceKeyForConstant(type, S);
    }

    public InstanceKey getInstanceKeyForClassObject(TypeReference type) {
        return this.instanceKeyFactory.getInstanceKeyForClassObject(type);
    }

    public boolean haveAlreadyVisited(CGNode node) {
        return this.alreadyVisited.contains(node);
    }

    protected void markAlreadyVisited(CGNode node) {
        this.alreadyVisited.add(node);
    }

    public void markDiscovered(CGNode node) {
        this.discoveredNodes.add(node);
    }

    protected void markChanged(CGNode node) {
        this.alreadyVisited.remove(node);
        this.discoveredNodes.add(node);
    }

    protected boolean wasChanged(CGNode node) {
        return this.discoveredNodes.contains(node) && !this.alreadyVisited.contains(node);
    }

    protected MutableIntSet getMutableInstanceKeysForClass(IClass klass) {
        return this.system.cloneInstanceKeysForClass(klass);
    }

    protected IntSet getInstanceKeysForClass(IClass klass) {
        return this.system.getInstanceKeysForClass(klass);
    }

    protected IntSet filterForClass(IntSet S, IClass klass) {
        MutableIntSet filter = null;
        if (klass.getReference().equals(TypeReference.JavaLangObject)) {
            return S;
        }
        filter = this.getMutableInstanceKeysForClass(klass);
        boolean debug = false;
        filter.intersectWith(S);
        return filter;
    }

    protected IPointsToSolver getSolver() {
        return this.solver;
    }

    public void addConstraintsFromChangedNode(CGNode node) {
        this.unconditionallyAddConstraintsFromNode(node);
    }

    protected abstract boolean unconditionallyAddConstraintsFromNode(CGNode var1);

    @Override
    public AnalysisCache getAnalysisCache() {
        return this.analysisCache;
    }

    public final class ArrayLoadOperator
    extends UnarySideEffect
    implements IPointerOperator {
        protected final MutableIntSet priorInstances;

        public String toString() {
            return "ArrayLoad";
        }

        public ArrayLoadOperator(PointsToSetVariable def) {
            super(def);
            this.priorInstances = IntSetUtil.make();
            PropagationCallGraphBuilder.this.system.registerFixedSet(def, this);
        }

        public byte evaluate(PointsToSetVariable rhs) {
            if (rhs.size() == 0) {
                return 0;
            }
            final PointerKey object = rhs.getPointerKey();
            PointsToSetVariable def = this.getFixedSet();
            final PointerKey dVal = def.getPointerKey();
            final MutableBoolean sideEffect = new MutableBoolean();
            IntSetAction action = new IntSetAction(){

                public void act(int i) {
                    InstanceKey I = ((ArrayLoadOperator)ArrayLoadOperator.this).PropagationCallGraphBuilder.this.system.getInstanceKey(i);
                    if (!I.getConcreteType().isArrayClass()) {
                        return;
                    }
                    TypeReference C = I.getConcreteType().getReference().getArrayElementType();
                    if (C.isPrimitiveType()) {
                        return;
                    }
                    PointerKey p = PropagationCallGraphBuilder.this.getPointerKeyForArrayContents(I);
                    if (p == null) {
                        return;
                    }
                    sideEffect.b |= ((ArrayLoadOperator)ArrayLoadOperator.this).PropagationCallGraphBuilder.this.system.newFieldRead(dVal, assignOperator, p, object);
                }
            };
            if (this.priorInstances != null) {
                rhs.getValue().foreachExcluding(this.priorInstances, action);
                this.priorInstances.addAll(rhs.getValue());
            } else {
                rhs.getValue().foreach(action);
            }
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        public int hashCode() {
            return 9871 + super.hashCode();
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }

        protected boolean isLoadOperator() {
            return true;
        }

        public boolean isComplex() {
            return true;
        }
    }

    public final class ArrayStoreOperator
    extends UnarySideEffect
    implements IPointerOperator {
        public String toString() {
            return "ArrayStore";
        }

        public ArrayStoreOperator(PointsToSetVariable val) {
            super(val);
            PropagationCallGraphBuilder.this.system.registerFixedSet(val, this);
        }

        public byte evaluate(PointsToSetVariable rhs) {
            if (rhs.size() == 0) {
                return 0;
            }
            PointerKey object = rhs.getPointerKey();
            PointsToSetVariable val = this.getFixedSet();
            PointerKey pVal = val.getPointerKey();
            List<InstanceKey> instances = PropagationCallGraphBuilder.this.system.getInstances(rhs.getValue());
            boolean sideEffect = false;
            for (InstanceKey I : instances) {
                TypeReference C;
                if (!I.getConcreteType().isArrayClass() || (C = I.getConcreteType().getReference().getArrayElementType()).isPrimitiveType()) continue;
                IClass contents = PropagationCallGraphBuilder.this.getClassHierarchy().lookupClass(C);
                if (contents == null) {
                    Assertions._assert(false, "null type for " + C + " " + I.getConcreteType());
                }
                PointerKey p = PropagationCallGraphBuilder.this.getPointerKeyForArrayContents(I);
                if (PropagationCallGraphBuilder.this.isJavaLangObject(contents)) {
                    sideEffect |= PropagationCallGraphBuilder.this.system.newFieldWrite(p, assignOperator, pVal, object);
                    continue;
                }
                sideEffect |= PropagationCallGraphBuilder.this.system.newFieldWrite(p, PropagationCallGraphBuilder.this.filterOperator, pVal, object);
            }
            int sideEffectMask = sideEffect ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        public int hashCode() {
            return 9859 + super.hashCode();
        }

        public boolean isComplex() {
            return true;
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }

        protected boolean isLoadOperator() {
            return false;
        }
    }

    private static class EntrypointResolutionWarning
    extends Warning {
        final Entrypoint entrypoint;

        EntrypointResolutionWarning(Entrypoint entrypoint) {
            super((byte)2);
            this.entrypoint = entrypoint;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.entrypoint;
        }

        public static EntrypointResolutionWarning create(Entrypoint entrypoint) {
            return new EntrypointResolutionWarning(entrypoint);
        }
    }

    private static class ExceptionLookupFailure
    extends Warning {
        final TypeReference t;

        ExceptionLookupFailure(TypeReference t) {
            super((byte)2);
            this.t = t;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.t;
        }

        public static ExceptionLookupFailure create(TypeReference t) {
            return new ExceptionLookupFailure(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FilterOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        protected FilterOperator() {
        }

        @Override
        public byte evaluate(PointsToSetVariable lhs, PointsToSetVariable rhs) {
            FilteredPointerKey pk = (FilteredPointerKey)lhs.getPointerKey();
            if (rhs.size() == 0) {
                return 0;
            }
            boolean changed = false;
            FilteredPointerKey.TypeFilter filter = pk.getTypeFilter();
            changed = filter.addFiltered(PropagationCallGraphBuilder.this.system, lhs, rhs);
            return changed ? (byte)1 : 0;
        }

        @Override
        public boolean isComplex() {
            return false;
        }

        @Override
        public String toString() {
            return "Filter ";
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return 88651;
        }
    }

    public class GetFieldOperator
    extends UnarySideEffect
    implements IPointerOperator {
        private final IField field;
        protected final MutableIntSet priorInstances;

        public GetFieldOperator(IField field, PointsToSetVariable def) {
            super(def);
            this.priorInstances = IntSetUtil.make();
            this.field = field;
            PropagationCallGraphBuilder.this.system.registerFixedSet(def, this);
        }

        public String toString() {
            return "GetField " + this.getField() + "," + this.getFixedSet().getPointerKey();
        }

        public byte evaluate(PointsToSetVariable rhs) {
            PointsToSetVariable ref = rhs;
            if (ref.size() == 0) {
                return 0;
            }
            final PointerKey object = ref.getPointerKey();
            PointsToSetVariable def = this.getFixedSet();
            final PointerKey dVal = def.getPointerKey();
            IntSet value = this.filterInstances(ref.getValue());
            final MutableBoolean sideEffect = new MutableBoolean();
            IntSetAction action = new IntSetAction(){

                public void act(int i) {
                    PointerKey p;
                    InstanceKey I = ((GetFieldOperator)GetFieldOperator.this).PropagationCallGraphBuilder.this.system.getInstanceKey(i);
                    if (!PropagationCallGraphBuilder.representsNullType(I) && (p = PropagationCallGraphBuilder.this.getPointerKeyForInstanceField(I, GetFieldOperator.this.getField())) != null) {
                        sideEffect.b |= ((GetFieldOperator)GetFieldOperator.this).PropagationCallGraphBuilder.this.system.newFieldRead(dVal, assignOperator, p, object);
                    }
                }
            };
            if (this.priorInstances != null) {
                value.foreachExcluding(this.priorInstances, action);
                this.priorInstances.addAll(value);
            } else {
                value.foreach(action);
            }
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        protected IntSet filterInstances(IntSet value) {
            return value;
        }

        public int hashCode() {
            return 9857 * this.getField().hashCode() + this.getFixedSet().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof GetFieldOperator) {
                GetFieldOperator other = (GetFieldOperator)o;
                return this.getField().equals(other.getField()) && this.getFixedSet().equals(other.getFixedSet());
            }
            return false;
        }

        protected IField getField() {
            return this.field;
        }

        protected boolean isLoadOperator() {
            return true;
        }

        public boolean isComplex() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class InstanceArrayStoreOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        private final InstanceKey instance;
        protected final MutableIntSet priorInstances = IntSetUtil.make();

        @Override
        public String toString() {
            return "InstanceArrayStore ";
        }

        public InstanceArrayStoreOperator(InstanceKey instance) {
            this.instance = instance;
        }

        @Override
        public byte evaluate(PointsToSetVariable dummyLHS, PointsToSetVariable var) {
            PointsToSetVariable arrayref = var;
            if (arrayref.size() == 0) {
                return 0;
            }
            MutableIntSet value = arrayref.getValue();
            final MutableBoolean sideEffect = new MutableBoolean();
            IntSetAction action = new IntSetAction(){

                public void act(int i) {
                    InstanceKey I = ((InstanceArrayStoreOperator)InstanceArrayStoreOperator.this).PropagationCallGraphBuilder.this.system.getInstanceKey(i);
                    if (!I.getConcreteType().isArrayClass()) {
                        return;
                    }
                    TypeReference C = I.getConcreteType().getReference().getArrayElementType();
                    if (C.isPrimitiveType()) {
                        return;
                    }
                    IClass contents = PropagationCallGraphBuilder.this.getClassHierarchy().lookupClass(C);
                    if (contents == null) {
                        Assertions._assert(false, "null type for " + C + " " + I.getConcreteType());
                    }
                    PointerKey p = PropagationCallGraphBuilder.this.getPointerKeyForArrayContents(I);
                    if (contents.isInterface()) {
                        if (PropagationCallGraphBuilder.this.getClassHierarchy().implementsInterface(InstanceArrayStoreOperator.this.instance.getConcreteType(), contents)) {
                            sideEffect.b |= ((InstanceArrayStoreOperator)InstanceArrayStoreOperator.this).PropagationCallGraphBuilder.this.system.newConstraint(p, InstanceArrayStoreOperator.this.instance);
                        }
                    } else if (PropagationCallGraphBuilder.this.getClassHierarchy().isSubclassOf(InstanceArrayStoreOperator.this.instance.getConcreteType(), contents)) {
                        sideEffect.b |= ((InstanceArrayStoreOperator)InstanceArrayStoreOperator.this).PropagationCallGraphBuilder.this.system.newConstraint(p, InstanceArrayStoreOperator.this.instance);
                    }
                }
            };
            if (this.priorInstances != null) {
                value.foreachExcluding(this.priorInstances, action);
                this.priorInstances.addAll(value);
            } else {
                value.foreach(action);
            }
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        @Override
        public int hashCode() {
            return 9839 * this.instance.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof InstanceArrayStoreOperator) {
                InstanceArrayStoreOperator other = (InstanceArrayStoreOperator)o;
                return this.instance.equals(other.instance);
            }
            return false;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class InstancePutFieldOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        private final IField field;
        private final InstanceKey instance;
        protected final MutableIntSet priorInstances = IntSetUtil.make();

        @Override
        public String toString() {
            return "InstancePutField" + this.field;
        }

        public InstancePutFieldOperator(IField field, InstanceKey instance) {
            this.field = field;
            this.instance = instance;
        }

        @Override
        public byte evaluate(PointsToSetVariable dummyLHS, PointsToSetVariable var) {
            PointsToSetVariable ref = var;
            if (ref.size() == 0) {
                return 0;
            }
            MutableIntSet value = ref.getValue();
            final MutableBoolean sideEffect = new MutableBoolean();
            IntSetAction action = new IntSetAction(){

                public void act(int i) {
                    InstanceKey I = ((InstancePutFieldOperator)InstancePutFieldOperator.this).PropagationCallGraphBuilder.this.system.getInstanceKey(i);
                    if (!PropagationCallGraphBuilder.representsNullType(I)) {
                        PointerKey p = PropagationCallGraphBuilder.this.getPointerKeyForInstanceField(I, InstancePutFieldOperator.this.field);
                        sideEffect.b |= ((InstancePutFieldOperator)InstancePutFieldOperator.this).PropagationCallGraphBuilder.this.system.newConstraint(p, InstancePutFieldOperator.this.instance);
                    }
                }
            };
            if (this.priorInstances != null) {
                value.foreachExcluding(this.priorInstances, action);
                this.priorInstances.addAll(value);
            } else {
                value.foreach(action);
            }
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        @Override
        public int hashCode() {
            return this.field.hashCode() + 9839 * this.instance.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof InstancePutFieldOperator) {
                InstancePutFieldOperator other = (InstancePutFieldOperator)o;
                return this.field.equals(other.field) && this.instance.equals(other.instance);
            }
            return false;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    protected class InverseFilterOperator
    extends FilterOperator {
        public String toString() {
            return "InverseFilter";
        }

        public boolean isComplex() {
            return false;
        }

        public byte evaluate(PointsToSetVariable lhs, PointsToSetVariable rhs) {
            FilteredPointerKey pk = (FilteredPointerKey)lhs.getPointerKey();
            FilteredPointerKey.TypeFilter filter = pk.getTypeFilter();
            boolean debug = false;
            if (rhs.size() == 0) {
                return 0;
            }
            boolean changed = filter.addInverseFiltered(PropagationCallGraphBuilder.this.system, lhs, rhs);
            return changed ? (byte)1 : 0;
        }
    }

    protected static class MutableBoolean {
        boolean b = false;

        protected MutableBoolean() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PutFieldOperator
    extends UnarySideEffect
    implements IPointerOperator {
        private final IField field;
        protected final MutableIntSet priorInstances;

        @Override
        public String toString() {
            return "PutField" + this.getField();
        }

        public PutFieldOperator(IField field, PointsToSetVariable val) {
            super(val);
            this.priorInstances = IntSetUtil.make();
            this.field = field;
            PropagationCallGraphBuilder.this.system.registerFixedSet(val, this);
        }

        @Override
        public boolean isComplex() {
            return true;
        }

        @Override
        public byte evaluate(PointsToSetVariable rhs) {
            if (rhs.size() == 0) {
                return 0;
            }
            final PointerKey object = rhs.getPointerKey();
            PointsToSetVariable val = this.getFixedSet();
            final PointerKey pVal = val.getPointerKey();
            IntSet value = rhs.getValue();
            value = this.filterInstances(value);
            final UnaryOperator<PointsToSetVariable> assign = this.getPutAssignmentOperator();
            if (assign == null) {
                Assertions.UNREACHABLE();
            }
            final MutableBoolean sideEffect = new MutableBoolean();
            IntSetAction action = new IntSetAction(){

                public void act(int i) {
                    InstanceKey I = ((PutFieldOperator)PutFieldOperator.this).PropagationCallGraphBuilder.this.system.getInstanceKey(i);
                    if (!PropagationCallGraphBuilder.representsNullType(I)) {
                        PointerKey p = PropagationCallGraphBuilder.this.getPointerKeyForInstanceField(I, PutFieldOperator.this.getField());
                        sideEffect.b |= ((PutFieldOperator)PutFieldOperator.this).PropagationCallGraphBuilder.this.system.newFieldWrite(p, assign, pVal, object);
                    }
                }
            };
            if (this.priorInstances != null) {
                value.foreachExcluding(this.priorInstances, action);
                this.priorInstances.addAll(value);
            } else {
                value.foreach(action);
            }
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        protected IntSet filterInstances(IntSet value) {
            return value;
        }

        @Override
        public int hashCode() {
            return 9857 * this.getField().hashCode() + this.getFixedSet().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o.getClass().equals(this.getClass())) {
                PutFieldOperator other = (PutFieldOperator)o;
                return this.getField().equals(other.getField()) && this.getFixedSet().equals(other.getFixedSet());
            }
            return false;
        }

        public UnaryOperator<PointsToSetVariable> getPutAssignmentOperator() {
            return assignOperator;
        }

        protected IField getField() {
            return this.field;
        }

        @Override
        protected boolean isLoadOperator() {
            return false;
        }
    }

    public static final class TypedPointerKey
    implements FilteredPointerKey {
        private final IClass type;
        private final PointerKey base;

        static TypedPointerKey make(PointerKey base, IClass type) {
            Assertions._assert(type != null);
            return new TypedPointerKey(base, type);
        }

        private TypedPointerKey(PointerKey base, IClass type) {
            this.type = type;
            this.base = base;
            Assertions._assert(type != null);
            Assertions._assert(!(type instanceof FilteredPointerKey));
        }

        public FilteredPointerKey.TypeFilter getTypeFilter() {
            return new FilteredPointerKey.SingleClassFilter(this.type);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypedPointerKey) {
                TypedPointerKey other = (TypedPointerKey)obj;
                return this.type.equals(other.type) && this.base.equals(other.base);
            }
            return false;
        }

        public int hashCode() {
            return 67931 * this.base.hashCode() + this.type.hashCode();
        }

        public String toString() {
            return "{ " + this.base + " type: " + this.type + "}";
        }

        public PointerKey getBase() {
            return this.base;
        }
    }
}

