/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.eclipse.util.CancelException;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.slicer.NormalReturnCallee;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHandler {
    private static final boolean VERBOSE = false;
    private final PropagationCallGraphBuilder builder;

    public ReflectionHandler(PropagationCallGraphBuilder builder) {
        this.builder = builder;
    }

    protected boolean updateForReflection() throws IllegalArgumentException, CancelException {
        Collection<Statement> returnStatements = this.computeFactoryReturnStatements();
        Set changedNodes = HashSetFactory.make();
        for (Statement st : returnStatements) {
            Collection<Statement> slice = Slicer.computeForwardSlice(st, this.builder.callGraph, null, Slicer.DataDependenceOptions.REFLECTION, Slicer.ControlDependenceOptions.NONE);
            Filter f = new Filter(){

                public boolean accepts(Object o) {
                    Statement s = (Statement)o;
                    if (s.getKind() == Statement.Kind.NORMAL) {
                        return ((NormalStatement)s).getInstruction() instanceof SSACheckCastInstruction;
                    }
                    return false;
                }
            };
            Collection casts = Iterator2Collection.toCollection(new FilterIterator(slice.iterator(), f));
            changedNodes.addAll(this.modifyFactoryInterpreter(st, casts, this.builder.getContextInterpreter(), this.builder.getClassHierarchy()));
        }
        Iterator it = changedNodes.iterator();
        while (it.hasNext()) {
            this.builder.addConstraintsFromChangedNode((CGNode)it.next());
        }
        return changedNodes.size() > 0;
    }

    private Collection<Statement> computeFactoryReturnStatements() {
        HashSet<Statement> result = HashSetFactory.make();
        for (CGNode n : this.builder.getCallGraph()) {
            SyntheticMethod m;
            if (!(n.getMethod() instanceof SyntheticMethod) || !(m = (SyntheticMethod)n.getMethod()).isFactoryMethod()) continue;
            result.add(new NormalReturnCallee(n));
        }
        return result;
    }

    private Set<CGNode> modifyFactoryInterpreter(Statement returnStatement, Collection<Statement> casts, RTAContextInterpreter contextInterpreter, IClassHierarchy cha) {
        HashSet<CGNode> result = HashSetFactory.make();
        IR ir = returnStatement.getNode().getIR();
        LocalPointerKey pk = null;
        Iterator<SSAInstruction> it2 = ir.iterateNormalInstructions();
        while (it2.hasNext()) {
            SSAInstruction s = it2.next();
            if (!(s instanceof SSAReturnInstruction)) continue;
            SSAReturnInstruction r = (SSAReturnInstruction)s;
            pk = (LocalPointerKey)this.builder.getPointerKeyForLocal(returnStatement.getNode(), r.getResult());
            break;
        }
        for (Statement st : casts) {
            SSACheckCastInstruction c = (SSACheckCastInstruction)((NormalStatement)st).getInstruction();
            TypeReference type = c.getDeclaredResultType();
            IClass klass = cha.lookupClass(type);
            if (klass == null || !contextInterpreter.recordFactoryType(pk.getNode(), klass)) continue;
            result.add(pk.getNode());
        }
        return result;
    }
}

