/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.analysis.reflection.CloneInterpreter;
import com.ibm.wala.analysis.reflection.Malleable;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.Util;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.IPointerOperator;
import com.ibm.wala.ipa.callgraph.propagation.IPointsToSolver;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PreTransitiveSolver;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.StandardSolver;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadClassInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ReferenceCleanser;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.warnings.ResolutionFailure;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSAPropagationCallGraphBuilder
extends PropagationCallGraphBuilder
implements HeapModel {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MULTINEWARRAY = false;
    public static final boolean PERIODIC_WIPE_SOFT_CACHES = true;
    public static final int WIPE_SOFT_CACHE_INTERVAL = 2500;
    private static int wipeCount = 0;
    private static final boolean SHORT_CIRCUIT_INVARIANT_SETS = true;
    protected static final boolean SHORT_CIRCUIT_SINGLE_USES = true;
    private final boolean clone2Assign = false;
    private static final Selector cloneSelector = CloneInterpreter.CLONE.getSelector();
    private final Set<IClass> clinitVisited = HashSetFactory.make();
    private final boolean usePreTransitiveSolver;

    protected SSAPropagationCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache, PointerKeyFactory pointerKeyFactory) {
        super(cha, options, cache, pointerKeyFactory);
        this.usePreTransitiveSolver = options.usePreTransitiveSolver();
    }

    public SSAContextInterpreter getCFAContextInterpreter() {
        return (SSAContextInterpreter)this.getContextInterpreter();
    }

    public static InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter x, TypeReference type, InstanceKeyFactory ikFactory) {
        if (ikFactory == null) {
            throw new IllegalArgumentException("ikFactory is null");
        }
        return ikFactory.getInstanceKeyForPEI(node, x, type);
    }

    @Override
    protected boolean addConstraintsFromNode(CGNode node) {
        if (this.haveAlreadyVisited(node)) {
            return false;
        }
        this.markAlreadyVisited(node);
        return this.unconditionallyAddConstraintsFromNode(node);
    }

    @Override
    protected boolean unconditionallyAddConstraintsFromNode(CGNode node) {
        IR ir;
        if (++wipeCount >= 2500) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
        if ((ir = this.getCFAContextInterpreter().getIR(node)) == null) {
            return false;
        }
        this.addNodeInstructionConstraints(node);
        DefUse du = this.getCFAContextInterpreter().getDU(node);
        this.addNodePassthruExceptionConstraints(node, ir, du);
        return true;
    }

    protected ConstraintVisitor makeVisitor(ExplicitCallGraph.ExplicitNode node) {
        return new ConstraintVisitor(this, node);
    }

    protected void addNodeInstructionConstraints(CGNode node) {
        ConstraintVisitor v = this.makeVisitor((ExplicitCallGraph.ExplicitNode)node);
        IR ir = this.getCFAContextInterpreter().getIR(node);
        SSACFG cfg = ir.getControlFlowGraph();
        for (SSACFG.BasicBlock b : cfg) {
            this.addBlockInstructionConstraints(node, cfg, b, v);
            if (!this.wasChanged(node)) continue;
            return;
        }
    }

    protected void addBlockInstructionConstraints(CGNode node, ControlFlowGraph<ISSABasicBlock> cfg, SSACFG.BasicBlock b, ConstraintVisitor v) {
        v.setBasicBlock(b);
        for (SSAInstruction s : b) {
            if (s == null) continue;
            s.visit(v);
            if (!this.wasChanged(node)) continue;
            return;
        }
        this.addPhiConstraints(node, cfg, b, v);
    }

    private void addPhiConstraints(CGNode node, ControlFlowGraph<ISSABasicBlock> cfg, SSACFG.BasicBlock b, ConstraintVisitor v) {
        Iterator<ISSABasicBlock> sbs = cfg.getSuccNodes(b);
        while (sbs.hasNext()) {
            SSACFG.BasicBlock sb = (SSACFG.BasicBlock)sbs.next();
            if (!sb.hasPhi()) continue;
            int n = 0;
            Iterator<ISSABasicBlock> back = cfg.getPredNodes(sb);
            while (back.hasNext()) {
                if (back.next() == b) break;
                ++n;
            }
            Iterator<SSAPhiInstruction> phis = sb.iteratePhis();
            while (phis.hasNext()) {
                SSAPhiInstruction phi = phis.next();
                if (phi == null) continue;
                PointerKey def = this.getPointerKeyForLocal(node, phi.getDef());
                if (this.hasNoInterestingUses(node, phi.getDef(), v.du)) {
                    this.system.recordImplicitPointsToSet(def);
                    continue;
                }
                if (phi.getUse(n) <= 0) continue;
                PointerKey use = this.getPointerKeyForLocal(node, phi.getUse(n));
                if (this.contentsAreInvariant(v.symbolTable, v.du, phi.getUse(n))) {
                    this.system.recordImplicitPointsToSet(use);
                    InstanceKey[] ik = this.getInvariantContents(v.symbolTable, v.du, node, phi.getUse(n), this);
                    int i = 0;
                    while (i < ik.length) {
                        this.system.newConstraint(def, ik[i]);
                        ++i;
                    }
                    continue;
                }
                this.system.newConstraint(def, assignOperator, use);
            }
        }
    }

    protected void addNodePassthruExceptionConstraints(CGNode node, IR ir, DefUse du) {
        List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(ir, ir.getExitBlock());
        PointerKey exception = this.getPointerKeyForExceptionalReturnValue(node);
        this.addExceptionDefConstraints(ir, du, node, peis, exception, THROWABLE_SET);
    }

    private void addExceptionDefConstraints(IR ir, DefUse du, CGNode node, List<ProgramCounter> peis, PointerKey exceptionVar, Set catchClasses) {
        for (ProgramCounter peiLoc : peis) {
            Collection<TypeReference> types;
            PointerKey e;
            SSAInstruction s;
            SSAInstruction pei = ir.getPEI(peiLoc);
            if (pei instanceof SSAAbstractInvokeInstruction) {
                s = (SSAAbstractInvokeInstruction)pei;
                e = this.getPointerKeyForLocal(node, ((SSAAbstractInvokeInstruction)s).getException());
                if (!SSAPropagationCallGraphBuilder.hasUniqueCatchBlock((SSAAbstractInvokeInstruction)s, ir)) {
                    this.addAssignmentsForCatchPointerKey(exceptionVar, catchClasses, e);
                }
            } else if (pei instanceof SSAAbstractThrowInstruction) {
                s = (SSAAbstractThrowInstruction)pei;
                e = this.getPointerKeyForLocal(node, ((SSAAbstractThrowInstruction)s).getException());
                if (this.contentsAreInvariant(ir.getSymbolTable(), du, ((SSAAbstractThrowInstruction)s).getException())) {
                    InstanceKey[] ik = this.getInvariantContents(ir.getSymbolTable(), du, node, ((SSAAbstractThrowInstruction)s).getException(), this);
                    int i = 0;
                    while (i < ik.length) {
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        this.assignInstanceToCatch(exceptionVar, catchClasses, ik[i]);
                        ++i;
                    }
                } else {
                    this.addAssignmentsForCatchPointerKey(exceptionVar, catchClasses, e);
                }
            }
            if ((types = pei.getExceptionTypes()) == null) continue;
            for (TypeReference type : types) {
                ConcreteTypeKey ck;
                IClass klass;
                if (type == null) continue;
                InstanceKey ik = SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(node, peiLoc, type, this.instanceKeyFactory);
                if (!(ik instanceof ConcreteTypeKey)) {
                    Assertions._assert(ik instanceof ConcreteTypeKey, "uh oh: need to implement getCaughtException constraints for instance " + ik);
                }
                if (!PropagationCallGraphBuilder.catches(catchClasses, klass = (ck = (ConcreteTypeKey)ik).getType(), this.cha)) continue;
                this.system.newConstraint(exceptionVar, SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(node, peiLoc, type, this.instanceKeyFactory));
            }
        }
    }

    protected static boolean hasUniqueCatchBlock(SSAAbstractInvokeInstruction call, IR ir) {
        Iterator<ISSABasicBlock> it;
        ISSABasicBlock[] bb = ir.getBasicBlocksForCall(call.getCallSite());
        if (bb.length == 1 && (it = ir.getControlFlowGraph().getExceptionalSuccessors(bb[0]).iterator()).hasNext()) {
            it.next();
            return !it.hasNext();
        }
        return false;
    }

    public PointerKey getUniqueCatchKey(SSAAbstractInvokeInstruction call, IR ir, CGNode node) throws IllegalArgumentException, IllegalArgumentException {
        if (call == null) {
            throw new IllegalArgumentException("call == null");
        }
        if (ir == null) {
            throw new IllegalArgumentException("ir == null");
        }
        ISSABasicBlock[] bb = ir.getBasicBlocksForCall(call.getCallSite());
        Assertions._assert(bb.length == 1);
        SSACFG.BasicBlock cb = (SSACFG.BasicBlock)ir.getControlFlowGraph().getExceptionalSuccessors(bb[0]).iterator().next();
        if (cb.isExitBlock()) {
            return this.getPointerKeyForExceptionalReturnValue(node);
        }
        SSACFG.ExceptionHandlerBasicBlock ehbb = (SSACFG.ExceptionHandlerBasicBlock)cb;
        SSAGetCaughtExceptionInstruction ci = ehbb.getCatchInstruction();
        return this.getPointerKeyForLocal(node, ci.getDef());
    }

    public static List<ProgramCounter> getIncomingPEIs(IR ir, ISSABasicBlock bb) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        SSACFG g = ir.getControlFlowGraph();
        ArrayList<ProgramCounter> result = new ArrayList<ProgramCounter>(g.getPredNodeCount(bb));
        Iterator<ISSABasicBlock> it = g.getPredNodes(bb);
        while (it.hasNext()) {
            SSACFG.BasicBlock pred = (SSACFG.BasicBlock)it.next();
            if (pred.isEntryBlock()) continue;
            int index = pred.getLastInstructionIndex();
            SSAInstruction pei = ir.getInstructions()[index];
            if (pei == null || !pei.isPEI()) continue;
            result.add(new ProgramCounter(g.getProgramCounter(index)));
        }
        return result;
    }

    private void processResolvedCall(CGNode caller, SSAAbstractInvokeInstruction instruction, CGNode target, InstanceKey[][] constParams, PointerKey uniqueCatchKey) {
        int nExpected;
        int nUses;
        caller.addTarget(instruction.getCallSite(), target);
        if (FakeRootMethod.isFakeRootMethod(caller.getMethod().getReference()) && this.entrypointCallSites.contains(instruction.getCallSite())) {
            this.callGraph.registerEntrypoint(target);
        }
        if (!this.haveAlreadyVisited(target)) {
            this.markDiscovered(target);
        }
        if ((nUses = instruction.getNumberOfParameters()) != (nExpected = target.getMethod().getNumberOfParameters())) {
            Warnings.add(ResolutionFailure.create(target, instruction, "found " + nUses + " uses but expected " + nExpected));
            return;
        }
        boolean needsFilter = !instruction.getCallSite().isStatic() && this.needsFilterForReceiver(instruction, target);
        int i = 0;
        while (i < instruction.getNumberOfParameters()) {
            int vn = i + 1;
            if (target.getMethod().getParameterType(i).isReferenceType()) {
                PointerKey formal;
                if (constParams != null && constParams[i] != null) {
                    InstanceKey[] ik = constParams[i];
                    int j = 0;
                    while (j < ik.length) {
                        if (needsFilter && i == 0) {
                            FilteredPointerKey.TypeFilter C = this.getFilter(target);
                            PointerKey formal2 = null;
                            formal2 = this.isRootType(C) ? this.getPointerKeyForLocal(target, vn) : this.getFilteredPointerKeyForLocal(target, vn, C);
                            this.system.newConstraint(formal2, ik[j]);
                        } else {
                            formal = this.getPointerKeyForLocal(target, vn);
                            this.system.newConstraint(formal, ik[j]);
                        }
                        ++j;
                    }
                } else {
                    if (instruction.getUse(i) < 0) {
                        Assertions.UNREACHABLE("unexpected " + instruction + " in " + caller);
                    }
                    PointerKey actual = this.getPointerKeyForLocal(caller, instruction.getUse(i));
                    if (needsFilter && i == 0) {
                        FilteredPointerKey.TypeFilter C = this.getFilter(target);
                        if (this.isRootType(C)) {
                            formal = this.getPointerKeyForLocal(target, vn);
                            this.system.newConstraint(formal, assignOperator, actual);
                        } else {
                            formal = this.getFilteredPointerKeyForLocal(target, vn, C);
                            this.system.newConstraint(formal, this.filterOperator, actual);
                        }
                    } else {
                        PointerKey formal3 = this.getPointerKeyForLocal(target, vn);
                        this.system.newConstraint(formal3, assignOperator, actual);
                    }
                }
            }
            ++i;
        }
        if (instruction.hasDef() && instruction.getDeclaredResultType().isReferenceType()) {
            PointerKey result = this.getPointerKeyForLocal(caller, instruction.getDef());
            PointerKey ret = this.getPointerKeyForReturnValue(target);
            this.system.newConstraint(result, assignOperator, ret);
        }
        PointerKey e = this.getPointerKeyForLocal(caller, instruction.getException());
        PointerKey er = this.getPointerKeyForExceptionalReturnValue(target);
        if (uniqueCatchKey != null) {
            this.system.newConstraint(uniqueCatchKey, assignOperator, er);
        } else {
            this.system.newConstraint(e, assignOperator, er);
        }
    }

    public boolean hasNoInterestingUses(CGNode node, int vn, DefUse du) {
        if (du == null) {
            throw new IllegalArgumentException("du is null");
        }
        InterestingVisitor v = this.makeInterestingVisitor(node, vn);
        Iterator<SSAInstruction> it = du.getUses(vn);
        while (it.hasNext()) {
            SSAInstruction s = it.next();
            s.visit(v);
            if (!v.bingo) continue;
            return false;
        }
        return true;
    }

    protected InterestingVisitor makeInterestingVisitor(CGNode node, int vn) {
        return new InterestingVisitor(vn);
    }

    private boolean needsFilterForReceiver(SSAAbstractInvokeInstruction instruction, CGNode target) {
        FilteredPointerKey.TypeFilter f = (FilteredPointerKey.TypeFilter)target.getContext().get(ContextKey.FILTER);
        if (f != null) {
            return true;
        }
        if (instruction.getCallSite().isStatic() || instruction.getCallSite().isSpecial()) {
            return false;
        }
        MethodReference declaredTarget = instruction.getDeclaredTarget();
        IMethod resolvedTarget = this.getClassHierarchy().resolveMethod(declaredTarget);
        if (resolvedTarget == null) {
            return true;
        }
        return true;
    }

    private boolean isRootType(IClass klass) {
        return klass.getClassHierarchy().isRootClass(klass);
    }

    private boolean isRootType(FilteredPointerKey.TypeFilter filter) {
        if (filter instanceof FilteredPointerKey.SingleClassFilter) {
            return this.isRootType(((FilteredPointerKey.SingleClassFilter)filter).getConcreteType());
        }
        return false;
    }

    private FilteredPointerKey.TypeFilter getFilter(CGNode target) {
        FilteredPointerKey.TypeFilter filter = (FilteredPointerKey.TypeFilter)target.getContext().get(ContextKey.FILTER);
        if (filter != null) {
            return filter;
        }
        IClass C = this.getReceiverClass(target.getMethod());
        return new FilteredPointerKey.SingleClassFilter(C);
    }

    private IClass getReceiverClass(IMethod method) {
        TypeReference formalType = method.getParameterType(0);
        IClass C = this.getClassHierarchy().lookupClass(formalType);
        if (method.isStatic()) {
            Assertions.UNREACHABLE("asked for receiver of static method " + method);
        }
        if (C == null) {
            Assertions.UNREACHABLE("no class found for " + formalType + " recv of " + method);
        }
        return C;
    }

    protected boolean contentsAreInvariant(SymbolTable symbolTable, DefUse du, int valueNumber) {
        if (this.isConstantRef(symbolTable, valueNumber)) {
            return true;
        }
        SSAInstruction def = du.getDef(valueNumber);
        return def instanceof SSANewInstruction;
    }

    protected InstanceKey[] getInvariantContents(SymbolTable symbolTable, DefUse du, CGNode node, int valueNumber, HeapModel hm) {
        return this.getInvariantContents(symbolTable, du, node, valueNumber, hm, false);
    }

    protected InstanceKey[] getInvariantContents(SymbolTable symbolTable, DefUse du, CGNode node, int valueNumber, HeapModel hm, boolean ensureIndexes) {
        InstanceKey[] result;
        if (this.isConstantRef(symbolTable, valueNumber)) {
            Object x = symbolTable.getConstantValue(valueNumber);
            if (x instanceof String) {
                String S = (String)x;
                TypeReference type = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(S);
                if (type == null) {
                    return new InstanceKey[0];
                }
                InstanceKey ik = hm.getInstanceKeyForConstant(type, S);
                result = ik != null ? new InstanceKey[]{ik} : new InstanceKey[]{};
            } else {
                TypeReference type = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(x);
                if (type == null) {
                    return new InstanceKey[0];
                }
                InstanceKey ik = hm.getInstanceKeyForConstant(type, x);
                result = ik != null ? new InstanceKey[]{ik} : new InstanceKey[]{};
            }
        } else {
            InstanceKey[] instanceKeyArray;
            SSANewInstruction def = (SSANewInstruction)du.getDef(valueNumber);
            InstanceKey iKey = hm.getInstanceKeyForAllocation(node, def.getNewSite());
            if (iKey == null) {
                instanceKeyArray = new InstanceKey[]{};
            } else {
                InstanceKey[] instanceKeyArray2 = new InstanceKey[1];
                instanceKeyArray = instanceKeyArray2;
                instanceKeyArray2[0] = iKey;
            }
            result = instanceKeyArray;
        }
        if (ensureIndexes) {
            int i = 0;
            while (i < result.length) {
                this.system.findOrCreateIndexForInstanceKey(result[i]);
                ++i;
            }
        }
        return result;
    }

    protected boolean isConstantRef(SymbolTable symbolTable, int valueNumber) {
        if (valueNumber == -1) {
            return false;
        }
        if (symbolTable.isConstant(valueNumber)) {
            Object v = symbolTable.getConstantValue(valueNumber);
            return !(v instanceof Number);
        }
        return false;
    }

    @Override
    public Iterator<PointerKey> iteratePointerKeys() {
        return this.system.iteratePointerKeys();
    }

    public static Set<TypeReference> getCaughtExceptionTypes(SSAGetCaughtExceptionInstruction instruction, IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        if (instruction == null) {
            throw new IllegalArgumentException("instruction is null");
        }
        Iterator<TypeReference> exceptionTypes = ((SSACFG.ExceptionHandlerBasicBlock)ir.getControlFlowGraph().getNode(instruction.getBasicBlockNumber())).getCaughtExceptionTypes();
        HashSet<TypeReference> types = HashSetFactory.make(10);
        while (exceptionTypes.hasNext()) {
            types.add(exceptionTypes.next());
        }
        return types;
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter instr, TypeReference type) {
        return SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(node, instr, type, this.instanceKeyFactory);
    }

    @Override
    protected IPointsToSolver makeSolver() {
        return this.usePreTransitiveSolver ? new PreTransitiveSolver(this.system, this) : new StandardSolver(this.system, this);
    }

    private static class CheckcastFailure
    extends Warning {
        final TypeReference type;

        CheckcastFailure(TypeReference type) {
            super((byte)2);
            this.type = type;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.type;
        }

        public static CheckcastFailure create(TypeReference type) {
            return new CheckcastFailure(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ConstraintVisitor
    extends SSAInstruction.Visitor {
        protected final SSAPropagationCallGraphBuilder builder;
        protected final ExplicitCallGraph.ExplicitNode node;
        private final ExplicitCallGraph callGraph;
        protected final IR ir;
        protected final PropagationSystem system;
        private ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;
        protected final DefUse du;

        public ConstraintVisitor(SSAPropagationCallGraphBuilder builder, ExplicitCallGraph.ExplicitNode node) {
            this.builder = builder;
            this.node = node;
            this.callGraph = builder.getCallGraph();
            this.system = builder.getPropagationSystem();
            this.ir = builder.getCFAContextInterpreter().getIR(node);
            this.symbolTable = this.ir.getSymbolTable();
            this.du = builder.getCFAContextInterpreter().getDU(node);
            Assertions._assert(this.symbolTable != null);
        }

        protected SSAPropagationCallGraphBuilder getBuilder() {
            return this.builder;
        }

        protected AnalysisOptions getOptions() {
            return this.builder.options;
        }

        protected AnalysisCache getAnalysisCache() {
            return this.builder.getAnalysisCache();
        }

        public PointerKey getPointerKeyForLocal(int valueNumber) {
            return this.getBuilder().getPointerKeyForLocal(this.node, valueNumber);
        }

        public FilteredPointerKey getFilteredPointerKeyForLocal(int valueNumber, FilteredPointerKey.TypeFilter filter) {
            return this.getBuilder().getFilteredPointerKeyForLocal((CGNode)this.node, valueNumber, filter);
        }

        public PointerKey getPointerKeyForReturnValue() {
            return this.getBuilder().getPointerKeyForReturnValue(this.node);
        }

        public PointerKey getPointerKeyForExceptionalReturnValue() {
            return this.getBuilder().getPointerKeyForExceptionalReturnValue(this.node);
        }

        public PointerKey getPointerKeyForStaticField(IField f) {
            return this.getBuilder().getPointerKeyForStaticField(f);
        }

        public PointerKey getPointerKeyForInstanceField(InstanceKey I, IField f) {
            return this.getBuilder().getPointerKeyForInstanceField(I, f);
        }

        public PointerKey getPointerKeyForArrayContents(InstanceKey I) {
            return this.getBuilder().getPointerKeyForArrayContents(I);
        }

        public InstanceKey getInstanceKeyForAllocation(NewSiteReference allocation) {
            return this.getBuilder().getInstanceKeyForAllocation(this.node, allocation);
        }

        public InstanceKey getInstanceKeyForMultiNewArray(NewSiteReference allocation, int dim) {
            return this.getBuilder().getInstanceKeyForMultiNewArray(this.node, allocation, dim);
        }

        public <T> InstanceKey getInstanceKeyForConstant(T S) {
            TypeReference type = this.node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(S);
            return this.getBuilder().getInstanceKeyForConstant(type, S);
        }

        public InstanceKey getInstanceKeyForPEI(ProgramCounter instr, TypeReference type) {
            return this.getBuilder().getInstanceKeyForPEI(this.node, instr, type);
        }

        public InstanceKey getInstanceKeyForClassObject(TypeReference type) {
            return this.getBuilder().getInstanceKeyForClassObject(type);
        }

        public CGNode getTargetForCall(CGNode caller, CallSiteReference site, InstanceKey iKey) {
            return this.getBuilder().getTargetForCall(caller, site, iKey);
        }

        protected boolean contentsAreInvariant(SymbolTable symbolTable, DefUse du, int valueNumber) {
            return this.getBuilder().contentsAreInvariant(symbolTable, du, valueNumber);
        }

        protected InstanceKey[] getInvariantContents(int valueNumber) {
            return this.getInvariantContents(this.ir.getSymbolTable(), this.du, this.node, valueNumber);
        }

        protected InstanceKey[] getInvariantContents(SymbolTable symbolTable, DefUse du, CGNode node, int valueNumber) {
            return this.getBuilder().getInvariantContents(symbolTable, du, node, valueNumber, this.getBuilder());
        }

        protected IClassHierarchy getClassHierarchy() {
            return this.getBuilder().getClassHierarchy();
        }

        protected boolean hasNoInterestingUses(int vn) {
            return this.getBuilder().hasNoInterestingUses(this.node, vn, this.du);
        }

        protected boolean isRootType(IClass klass) {
            return this.getBuilder().isRootType(klass);
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            this.doVisitArrayLoad(instruction.getDef(), instruction.getArrayRef());
        }

        protected void doVisitArrayLoad(int def, int arrayRef) {
            PointerKey result = this.getPointerKeyForLocal(def);
            PointerKey arrayRefPtrKey = this.getPointerKeyForLocal(arrayRef);
            if (this.hasNoInterestingUses(def)) {
                this.system.recordImplicitPointsToSet(result);
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, arrayRef)) {
                this.system.recordImplicitPointsToSet(arrayRefPtrKey);
                InstanceKey[] ik = this.getInvariantContents(arrayRef);
                int i = 0;
                while (i < ik.length) {
                    if (!SSAPropagationCallGraphBuilder.representsNullType(ik[i])) {
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        PointerKey p = this.getPointerKeyForArrayContents(ik[i]);
                        if (p == null) {
                            Warnings.add(ResolutionFailure.create(this.node, ik[i].getConcreteType()));
                        } else {
                            this.system.newConstraint(result, assignOperator, p);
                        }
                    }
                    ++i;
                }
            } else {
                Assertions._assert(!this.system.isUnified(result));
                Assertions._assert(!this.system.isUnified(arrayRefPtrKey));
                SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                sSAPropagationCallGraphBuilder.getClass();
                this.system.newSideEffect(new PropagationCallGraphBuilder.ArrayLoadOperator(sSAPropagationCallGraphBuilder, this.system.findOrCreatePointsToSet(result)), arrayRefPtrKey);
            }
        }

        public void doVisitArrayStore(int arrayRef, int value) {
            PointerKey valuePtrKey = this.getPointerKeyForLocal(value);
            PointerKey arrayRefPtrKey = this.getPointerKeyForLocal(arrayRef);
            if (this.contentsAreInvariant(this.symbolTable, this.du, arrayRef)) {
                this.system.recordImplicitPointsToSet(arrayRefPtrKey);
                InstanceKey[] ik = this.getInvariantContents(arrayRef);
                int i = 0;
                while (i < ik.length) {
                    if (!SSAPropagationCallGraphBuilder.representsNullType(ik[i])) {
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        PointerKey p = this.getPointerKeyForArrayContents(ik[i]);
                        IClass contents = ((ArrayClass)ik[i].getConcreteType()).getElementClass();
                        if (p == null) {
                            Warnings.add(ResolutionFailure.create(this.node, ik[i].getConcreteType()));
                        } else if (this.contentsAreInvariant(this.symbolTable, this.du, value)) {
                            this.system.recordImplicitPointsToSet(valuePtrKey);
                            InstanceKey[] vk = this.getInvariantContents(value);
                            int j = 0;
                            while (j < vk.length) {
                                this.system.findOrCreateIndexForInstanceKey(vk[j]);
                                if (vk[j].getConcreteType() != null && this.getClassHierarchy().isAssignableFrom(contents, vk[j].getConcreteType())) {
                                    this.system.newConstraint(p, vk[j]);
                                }
                                ++j;
                            }
                        } else if (this.isRootType(contents)) {
                            this.system.newConstraint(p, assignOperator, valuePtrKey);
                        } else {
                            this.system.newConstraint(p, this.getBuilder().filterOperator, valuePtrKey);
                        }
                    }
                    ++i;
                }
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, value)) {
                this.system.recordImplicitPointsToSet(valuePtrKey);
                InstanceKey[] ik = this.getInvariantContents(value);
                int i = 0;
                while (i < ik.length) {
                    this.system.findOrCreateIndexForInstanceKey(ik[i]);
                    Assertions._assert(!this.system.isUnified(arrayRefPtrKey));
                    SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                    sSAPropagationCallGraphBuilder.getClass();
                    this.system.newSideEffect(new PropagationCallGraphBuilder.InstanceArrayStoreOperator(sSAPropagationCallGraphBuilder, ik[i]), arrayRefPtrKey);
                    ++i;
                }
            } else {
                SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                sSAPropagationCallGraphBuilder.getClass();
                this.system.newSideEffect(new PropagationCallGraphBuilder.ArrayStoreOperator(sSAPropagationCallGraphBuilder, this.system.findOrCreatePointsToSet(valuePtrKey)), arrayRefPtrKey);
            }
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            this.doVisitArrayStore(instruction.getArrayRef(), instruction.getValue());
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            IClass cls = this.getClassHierarchy().lookupClass(instruction.getDeclaredResultType());
            FilteredPointerKey result = null;
            if (cls == null) {
                Warnings.add(CheckcastFailure.create(instruction.getDeclaredResultType()));
                return;
            }
            result = this.getFilteredPointerKeyForLocal(instruction.getResult(), new FilteredPointerKey.SingleClassFilter(cls));
            PointerKey value = this.getPointerKeyForLocal(instruction.getVal());
            if (this.hasNoInterestingUses(instruction.getDef())) {
                this.system.recordImplicitPointsToSet(result);
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, instruction.getVal())) {
                this.system.recordImplicitPointsToSet(value);
                InstanceKey[] ik = this.getInvariantContents(instruction.getVal());
                if (cls.isInterface()) {
                    int i = 0;
                    while (i < ik.length) {
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        if (this.getClassHierarchy().implementsInterface(ik[i].getConcreteType(), cls)) {
                            this.system.newConstraint(result, ik[i]);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < ik.length) {
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        if (this.getClassHierarchy().isSubclassOf(ik[i].getConcreteType(), cls)) {
                            this.system.newConstraint(result, ik[i]);
                        }
                        ++i;
                    }
                }
            } else {
                if (cls == null) {
                    Warnings.add(ResolutionFailure.create(this.node, instruction.getDeclaredResultType()));
                    cls = this.getBuilder().getJavaLangObject();
                }
                if (this.isRootType(cls)) {
                    this.system.newConstraint((PointerKey)result, assignOperator, value);
                } else {
                    this.system.newConstraint((PointerKey)result, this.getBuilder().filterOperator, value);
                }
            }
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
            if (instruction.returnsPrimitiveType() || instruction.returnsVoid()) {
                return;
            }
            PointerKey returnValue = this.getPointerKeyForReturnValue();
            PointerKey result = this.getPointerKeyForLocal(instruction.getResult());
            if (this.contentsAreInvariant(this.symbolTable, this.du, instruction.getResult())) {
                this.system.recordImplicitPointsToSet(result);
                InstanceKey[] ik = this.getInvariantContents(instruction.getResult());
                int i = 0;
                while (i < ik.length) {
                    this.system.newConstraint(returnValue, ik[i]);
                    ++i;
                }
            } else {
                this.system.newConstraint(returnValue, assignOperator, result);
            }
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            this.visitGetInternal(instruction.getDef(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        protected void visitGetInternal(int lval, int ref, boolean isStatic, FieldReference field) {
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            PointerKey def = this.getPointerKeyForLocal(lval);
            Assertions._assert(def != null);
            IField f = this.getClassHierarchy().resolveField(field);
            if (f == null && this.callGraph.getFakeRootNode().getMethod().getDeclaringClass().getReference().equals(field.getDeclaringClass())) {
                f = this.callGraph.getFakeRootNode().getMethod().getDeclaringClass().getField(field.getName());
            }
            if (f == null) {
                Warnings.add(ResolutionFailure.create(this.node, field));
                return;
            }
            if (this.hasNoInterestingUses(lval)) {
                this.system.recordImplicitPointsToSet(def);
            } else if (isStatic) {
                PointerKey fKey = this.getPointerKeyForStaticField(f);
                this.system.newConstraint(def, assignOperator, fKey);
                IClass klass = this.getClassHierarchy().lookupClass(field.getDeclaringClass());
                if (klass == null) {
                    Warnings.add(ResolutionFailure.create(this.node, field.getDeclaringClass()));
                } else {
                    this.processClassInitializer(klass);
                }
            } else {
                PointerKey refKey = this.getPointerKeyForLocal(ref);
                if (this.contentsAreInvariant(this.symbolTable, this.du, ref)) {
                    this.system.recordImplicitPointsToSet(refKey);
                    InstanceKey[] ik = this.getInvariantContents(ref);
                    int i = 0;
                    while (i < ik.length) {
                        if (!SSAPropagationCallGraphBuilder.representsNullType(ik[i])) {
                            this.system.findOrCreateIndexForInstanceKey(ik[i]);
                            PointerKey p = this.getPointerKeyForInstanceField(ik[i], f);
                            this.system.newConstraint(def, assignOperator, p);
                        }
                        ++i;
                    }
                } else {
                    SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                    sSAPropagationCallGraphBuilder.getClass();
                    this.system.newSideEffect(new PropagationCallGraphBuilder.GetFieldOperator(sSAPropagationCallGraphBuilder, f, this.system.findOrCreatePointsToSet(def)), refKey);
                }
            }
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            this.visitPutInternal(instruction.getVal(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        public void visitPutInternal(int rval, int ref, boolean isStatic, FieldReference field) {
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = this.getClassHierarchy().resolveField(field);
            if (f == null) {
                Warnings.add(FieldResolutionFailure.create(field));
                return;
            }
            Assertions._assert(isStatic || !this.symbolTable.isStringConstant(ref), "put to string constant shouldn't be allowed?");
            if (isStatic) {
                this.processPutStatic(rval, field, f);
            } else {
                this.processPutField(rval, ref, f);
            }
        }

        private void processPutField(int rval, int ref, IField f) {
            Assertions._assert(!f.getFieldTypeReference().isPrimitiveType());
            PointerKey refKey = this.getPointerKeyForLocal(ref);
            PointerKey rvalKey = this.getPointerKeyForLocal(rval);
            if (this.contentsAreInvariant(this.symbolTable, this.du, rval)) {
                this.system.recordImplicitPointsToSet(rvalKey);
                InstanceKey[] ik = this.getInvariantContents(rval);
                if (this.contentsAreInvariant(this.symbolTable, this.du, ref)) {
                    this.system.recordImplicitPointsToSet(refKey);
                    InstanceKey[] refk = this.getInvariantContents(ref);
                    int j = 0;
                    while (j < refk.length) {
                        if (!SSAPropagationCallGraphBuilder.representsNullType(refk[j])) {
                            this.system.findOrCreateIndexForInstanceKey(refk[j]);
                            PointerKey p = this.getPointerKeyForInstanceField(refk[j], f);
                            int i = 0;
                            while (i < ik.length) {
                                this.system.newConstraint(p, ik[i]);
                                ++i;
                            }
                        }
                        ++j;
                    }
                } else {
                    int i = 0;
                    while (i < ik.length) {
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                        sSAPropagationCallGraphBuilder.getClass();
                        this.system.newSideEffect(new PropagationCallGraphBuilder.InstancePutFieldOperator(sSAPropagationCallGraphBuilder, f, ik[i]), refKey);
                        ++i;
                    }
                }
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, ref)) {
                this.system.recordImplicitPointsToSet(refKey);
                InstanceKey[] refk = this.getInvariantContents(ref);
                int j = 0;
                while (j < refk.length) {
                    if (!SSAPropagationCallGraphBuilder.representsNullType(refk[j])) {
                        this.system.findOrCreateIndexForInstanceKey(refk[j]);
                        PointerKey p = this.getPointerKeyForInstanceField(refk[j], f);
                        this.system.newConstraint(p, assignOperator, rvalKey);
                    }
                    ++j;
                }
            } else {
                SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                sSAPropagationCallGraphBuilder.getClass();
                this.system.newSideEffect(new PropagationCallGraphBuilder.PutFieldOperator(sSAPropagationCallGraphBuilder, f, this.system.findOrCreatePointsToSet(rvalKey)), refKey);
            }
        }

        private void processPutStatic(int rval, FieldReference field, IField f) {
            PointerKey fKey = this.getPointerKeyForStaticField(f);
            PointerKey rvalKey = this.getPointerKeyForLocal(rval);
            if (this.contentsAreInvariant(this.symbolTable, this.du, rval)) {
                this.system.recordImplicitPointsToSet(rvalKey);
                InstanceKey[] ik = this.getInvariantContents(rval);
                int i = 0;
                while (i < ik.length) {
                    this.system.newConstraint(fKey, ik[i]);
                    ++i;
                }
            } else {
                this.system.newConstraint(fKey, assignOperator, rvalKey);
            }
            IClass klass = this.getClassHierarchy().lookupClass(field.getDeclaringClass());
            if (klass == null) {
                Warnings.add(FieldResolutionFailure.create(field));
            } else {
                this.processClassInitializer(klass);
            }
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            this.visitInvokeInternal(instruction);
        }

        protected void visitInvokeInternal(SSAAbstractInvokeInstruction instruction) {
            PointerKey uniqueCatch = null;
            if (SSAPropagationCallGraphBuilder.hasUniqueCatchBlock(instruction, this.ir)) {
                uniqueCatch = this.getBuilder().getUniqueCatchKey(instruction, this.ir, this.node);
            }
            if (instruction.getCallSite().isStatic()) {
                CGNode n = this.getTargetForCall(this.node, instruction.getCallSite(), null);
                if (n == null) {
                    Warnings.add(ResolutionFailure.create(this.node, instruction));
                } else {
                    this.getBuilder().processResolvedCall(this.node, instruction, n, this.computeInvariantParameters(instruction), uniqueCatch);
                    this.processClassInitializer(n.getMethod().getDeclaringClass());
                }
            } else {
                PointerKey receiver = this.getPointerKeyForLocal(instruction.getReceiver());
                if (this.contentsAreInvariant(this.symbolTable, this.du, instruction.getReceiver())) {
                    this.system.recordImplicitPointsToSet(receiver);
                    InstanceKey[] ik = this.getInvariantContents(instruction.getReceiver());
                    int i = 0;
                    while (i < ik.length) {
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        CGNode n = this.getTargetForCall(this.node, instruction.getCallSite(), ik[i]);
                        if (n == null) {
                            Warnings.add(ResolutionFailure.create(this.node, instruction));
                        } else {
                            this.getBuilder().processResolvedCall(this.node, instruction, n, this.computeInvariantParameters(instruction), uniqueCatch);
                            this.processClassInitializer(n.getMethod().getDeclaringClass());
                        }
                        ++i;
                    }
                } else {
                    SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                    sSAPropagationCallGraphBuilder.getClass();
                    DispatchOperator dispatchOperator = sSAPropagationCallGraphBuilder.new DispatchOperator(instruction, this.node, this.computeInvariantParameters(instruction), uniqueCatch);
                    this.system.newSideEffect(dispatchOperator, receiver);
                }
            }
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            InstanceKey iKey = this.getInstanceKeyForAllocation(instruction.getNewSite());
            if (iKey == null) {
                return;
            }
            PointerKey def = this.getPointerKeyForLocal(instruction.getDef());
            IClass klass = iKey.getConcreteType();
            if (klass == null) {
                Warnings.add(ResolutionFailure.create(this.node, instruction.getConcreteType()));
                return;
            }
            if (!this.contentsAreInvariant(this.symbolTable, this.du, instruction.getDef())) {
                this.system.newConstraint(def, iKey);
            } else {
                this.system.findOrCreateIndexForInstanceKey(iKey);
                this.system.recordImplicitPointsToSet(def);
            }
            this.processClassInitializer(klass);
            int dim = 0;
            InstanceKey lastInstance = iKey;
            while (klass != null && klass.isArrayClass()) {
                Integer c;
                if ((klass = ((ArrayClass)klass).getElementClass()) == null || !klass.isArrayClass()) continue;
                if (instruction.getNumberOfUses() <= dim + 1) break;
                int sv = instruction.getUse(dim + 1);
                if (this.ir.getSymbolTable().isIntegerConstant(sv) && (c = (Integer)this.ir.getSymbolTable().getConstantValue(sv)) == 0) break;
                InstanceKey ik = this.getInstanceKeyForMultiNewArray(instruction.getNewSite(), dim);
                PointerKey pk = this.getPointerKeyForArrayContents(lastInstance);
                this.system.newConstraint(pk, ik);
                lastInstance = ik;
                ++dim;
            }
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey def = this.getPointerKeyForLocal(instruction.getDef());
            Set<TypeReference> types = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(instruction, this.ir);
            this.getBuilder().addExceptionDefConstraints(this.ir, this.du, this.node, peis, def, types);
        }

        private int booleanConstantTest(SSAConditionalBranchInstruction c, int v) {
            int result = 0;
            if (this.symbolTable.isZeroOrFalse(c.getUse(0)) && c.getUse(1) == v || this.symbolTable.isZeroOrFalse(c.getUse(1)) && c.getUse(0) == v) {
                result = -1;
            } else if (this.symbolTable.isOneOrTrue(c.getUse(0)) && c.getUse(1) == v || this.symbolTable.isOneOrTrue(c.getUse(1)) && c.getUse(0) == v) {
                result = 1;
            }
            if (c.getOperator() == ConditionalBranchInstruction.Operator.NE) {
                result = -result;
            }
            return result;
        }

        private int nullConstantTest(SSAConditionalBranchInstruction c, int v) {
            if (this.symbolTable.isNullConstant(c.getUse(0)) && c.getUse(1) == v || this.symbolTable.isNullConstant(c.getUse(1)) && c.getUse(0) == v) {
                if (c.getOperator() == ConditionalBranchInstruction.Operator.EQ) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        @Override
        public void visitPhi(SSAPhiInstruction instruction) {
            if (this.ir.getMethod() instanceof AbstractRootMethod) {
                PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                if (this.hasNoInterestingUses(instruction.getDef())) {
                    this.system.recordImplicitPointsToSet(dst);
                } else {
                    int i = 0;
                    while (i < instruction.getNumberOfUses()) {
                        PointerKey use = this.getPointerKeyForLocal(instruction.getUse(i));
                        if (this.contentsAreInvariant(this.symbolTable, this.du, instruction.getUse(i))) {
                            this.system.recordImplicitPointsToSet(use);
                            InstanceKey[] ik = this.getInvariantContents(instruction.getUse(i));
                            int j = 0;
                            while (j < ik.length) {
                                this.system.newConstraint(dst, ik[j]);
                                ++j;
                            }
                        } else {
                            this.system.newConstraint(dst, assignOperator, use);
                        }
                        ++i;
                    }
                }
            }
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
            if (this.hasNoInterestingUses(instruction.getDef())) {
                PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                this.system.recordImplicitPointsToSet(dst);
            } else {
                SSACFG cfg = this.ir.getControlFlowGraph();
                if (Util.endsWithConditionalBranch(cfg, this.getBasicBlock()) && cfg.getSuccNodeCount(this.getBasicBlock()) == 2) {
                    SSAConditionalBranchInstruction cond = (SSAConditionalBranchInstruction)Util.getLastInstruction(cfg, this.getBasicBlock());
                    SSAInstruction cause = instruction.getCause();
                    SSACFG.BasicBlock target = (SSACFG.BasicBlock)cfg.getNode(instruction.getSuccessor());
                    if (cause instanceof SSAInstanceofInstruction) {
                        int direction = this.booleanConstantTest(cond, cause.getDef());
                        if (direction != 0) {
                            TypeReference type = ((SSAInstanceofInstruction)cause).getCheckedType();
                            IClass cls = this.getClassHierarchy().lookupClass(type);
                            if (cls == null) {
                                Warnings.add(ResolutionFailure.create(this.node, type));
                                PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                                this.addPiAssignment(dst, instruction.getVal());
                            } else {
                                FilteredPointerKey dst = this.getFilteredPointerKeyForLocal(instruction.getDef(), new FilteredPointerKey.SingleClassFilter(cls));
                                PointerKey src = this.getPointerKeyForLocal(instruction.getVal());
                                if (target == Util.getTakenSuccessor(cfg, this.getBasicBlock()) && direction == 1 || target == Util.getNotTakenSuccessor(cfg, this.getBasicBlock()) && direction == -1) {
                                    this.system.newConstraint((PointerKey)dst, this.getBuilder().filterOperator, src);
                                } else {
                                    this.system.newConstraint((PointerKey)dst, this.getBuilder().inverseFilterOperator, src);
                                }
                            }
                        }
                    } else {
                        int dir = this.nullConstantTest(cond, instruction.getVal());
                        if (dir != 0) {
                            if (target == Util.getTakenSuccessor(cfg, this.getBasicBlock()) && dir == -1 || target == Util.getNotTakenSuccessor(cfg, this.getBasicBlock()) && dir == 1) {
                                PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                                this.addPiAssignment(dst, instruction.getVal());
                            }
                        } else {
                            PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                            this.addPiAssignment(dst, instruction.getVal());
                        }
                    }
                } else {
                    PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                    this.addPiAssignment(dst, instruction.getVal());
                }
            }
        }

        private void addPiAssignment(PointerKey dst, int src) {
            PointerKey srcKey = this.getPointerKeyForLocal(src);
            if (this.contentsAreInvariant(this.symbolTable, this.du, src)) {
                this.system.recordImplicitPointsToSet(srcKey);
                InstanceKey[] ik = this.getInvariantContents(src);
                int j = 0;
                while (j < ik.length) {
                    this.system.newConstraint(dst, ik[j]);
                    ++j;
                }
            } else {
                this.system.newConstraint(dst, assignOperator, srcKey);
            }
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public void setBasicBlock(ISSABasicBlock block) {
            this.basicBlock = block;
        }

        protected InstanceKey[][] computeInvariantParameters(SSAAbstractInvokeInstruction call) {
            InstanceKey[][] constParams = null;
            int i = 0;
            while (i < call.getNumberOfUses()) {
                if (call.getUse(i) > 0 && this.contentsAreInvariant(this.symbolTable, this.du, call.getUse(i))) {
                    this.system.recordImplicitPointsToSet(this.getPointerKeyForLocal(call.getUse(i)));
                    if (constParams == null) {
                        constParams = new InstanceKey[call.getNumberOfUses()][];
                    }
                    constParams[i] = this.getInvariantContents(call.getUse(i));
                    int j = 0;
                    while (j < constParams[i].length) {
                        this.system.findOrCreateIndexForInstanceKey(constParams[i][j]);
                        ++j;
                    }
                }
                ++i;
            }
            return constParams;
        }

        @Override
        public void visitLoadClass(SSALoadClassInstruction instruction) {
            PointerKey def = this.getPointerKeyForLocal(instruction.getDef());
            InstanceKey iKey = this.getInstanceKeyForClassObject(instruction.getLoadedClass());
            if (!this.contentsAreInvariant(this.symbolTable, this.du, instruction.getDef())) {
                this.system.newConstraint(def, iKey);
            } else {
                this.system.findOrCreateIndexForInstanceKey(iKey);
                this.system.recordImplicitPointsToSet(def);
            }
        }

        private void processClassInitializer(IClass klass) {
            Assertions._assert(klass != null);
            if (this.getBuilder().clinitVisited.contains(klass)) {
                return;
            }
            this.getBuilder().clinitVisited.add(klass);
            if (klass.getClassInitializer() != null) {
                CGNode target;
                FakeWorldClinitMethod fakeWorldClinitMethod = (FakeWorldClinitMethod)this.callGraph.getFakeWorldClinitNode().getMethod();
                MethodReference m = klass.getClassInitializer().getReference();
                CallSiteReference site = CallSiteReference.make(1, m, IInvokeInstruction.Dispatch.STATIC);
                IMethod targetMethod = this.getOptions().getMethodTargetSelector().getCalleeTarget(this.callGraph.getFakeRootNode(), site, null);
                if (targetMethod != null && (target = this.getTargetForCall(this.callGraph.getFakeRootNode(), site, null)) != null && this.callGraph.getPredNodeCount(target) == 0) {
                    SSAInvokeInstruction s = fakeWorldClinitMethod.addInvocation(new int[0], site);
                    PointerKey uniqueCatch = this.getBuilder().getPointerKeyForExceptionalReturnValue(this.callGraph.getFakeRootNode());
                    this.getBuilder().processResolvedCall(this.callGraph.getFakeWorldClinitNode(), s, target, null, uniqueCatch);
                }
            }
            try {
                IClass sc = klass.getSuperclass();
                if (sc != null) {
                    this.processClassInitializer(sc);
                }
            }
            catch (ClassHierarchyException e) {
                Assertions.UNREACHABLE();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DispatchOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        private final SSAAbstractInvokeInstruction call;
        private final ExplicitCallGraph.ExplicitNode node;
        private final InstanceKey[][] constParams;
        private final PointerKey uniqueCatch;
        private final MutableIntSet previousReceivers = IntSetUtil.getDefaultIntSetFactory().make();

        DispatchOperator(SSAAbstractInvokeInstruction call, ExplicitCallGraph.ExplicitNode node, InstanceKey[][] constParams, PointerKey uniqueCatch) {
            this.call = call;
            this.node = node;
            this.constParams = constParams;
            this.uniqueCatch = uniqueCatch;
        }

        @Override
        public byte evaluate(PointsToSetVariable lhs, PointsToSetVariable rhs) {
            PointsToSetVariable receivers = rhs;
            final PropagationCallGraphBuilder.MutableBoolean sideEffect = new PropagationCallGraphBuilder.MutableBoolean();
            MutableIntSet value = receivers.getValue();
            if (value == null) {
                return 0;
            }
            IntSetAction action = new IntSetAction(){

                public void act(int ptr) {
                    IntSet targets;
                    InstanceKey iKey = ((DispatchOperator)DispatchOperator.this).SSAPropagationCallGraphBuilder.this.system.getInstanceKey(ptr);
                    TypeReference concreteType = iKey.getConcreteType().getReference();
                    if (Malleable.isMalleable(concreteType)) {
                        return;
                    }
                    CGNode target = SSAPropagationCallGraphBuilder.this.getTargetForCall(DispatchOperator.this.node, DispatchOperator.this.call.getCallSite(), iKey);
                    if (!(target == null || (targets = SSAPropagationCallGraphBuilder.this.getCallGraph().getPossibleTargetNumbers(DispatchOperator.this.node, DispatchOperator.this.call.getCallSite())) != null && targets.contains(target.getGraphNodeId()))) {
                        sideEffect.b = true;
                        SSAPropagationCallGraphBuilder.this.processResolvedCall(DispatchOperator.this.node, DispatchOperator.this.call, target, DispatchOperator.this.constParams, DispatchOperator.this.uniqueCatch);
                        if (!SSAPropagationCallGraphBuilder.this.haveAlreadyVisited(target)) {
                            SSAPropagationCallGraphBuilder.this.markDiscovered(target);
                        }
                    }
                }
            };
            try {
                value.foreachExcluding(this.previousReceivers, action);
            }
            catch (Error e) {
                System.err.println("error in " + this.call + " on " + receivers + " of types " + value + " for " + this.node);
                throw e;
            }
            catch (RuntimeException e) {
                System.err.println("error in " + this.call + " on " + receivers + " of types " + value + " for " + this.node);
                throw e;
            }
            this.previousReceivers.copySet(value);
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        @Override
        public String toString() {
            return "Dispatch to " + this.call + " in node " + this.node;
        }

        @Override
        public int hashCode() {
            return this.node.hashCode() + 90289 * this.call.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof DispatchOperator) {
                DispatchOperator other = (DispatchOperator)o;
                return this.node.equals(other.node) && this.call.equals(other.call);
            }
            return false;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    private static class FieldResolutionFailure
    extends Warning {
        final FieldReference field;

        FieldResolutionFailure(FieldReference field) {
            super((byte)2);
            this.field = field;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.field;
        }

        public static FieldResolutionFailure create(FieldReference field) {
            return new FieldResolutionFailure(field);
        }
    }

    protected static class InterestingVisitor
    extends SSAInstruction.Visitor {
        protected final int vn;
        protected boolean bingo = false;

        protected InterestingVisitor(int vn) {
            this.vn = vn;
        }

        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            if (!instruction.typeIsPrimitive() && instruction.getArrayRef() == this.vn) {
                this.bingo = true;
            }
        }

        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            if (!(instruction.typeIsPrimitive() || instruction.getArrayRef() != this.vn && instruction.getValue() != this.vn)) {
                this.bingo = true;
            }
        }

        public void visitCheckCast(SSACheckCastInstruction instruction) {
            this.bingo = true;
        }

        public void visitGet(SSAGetInstruction instruction) {
            FieldReference field = instruction.getDeclaredField();
            if (!field.getFieldType().isPrimitiveType()) {
                this.bingo = true;
            }
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            this.bingo = true;
        }

        public void visitInvoke(SSAInvokeInstruction instruction) {
            this.bingo = true;
        }

        public void visitPhi(SSAPhiInstruction instruction) {
            this.bingo = true;
        }

        public void visitPi(SSAPiInstruction instruction) {
            this.bingo = true;
        }

        public void visitPut(SSAPutInstruction instruction) {
            FieldReference field = instruction.getDeclaredField();
            if (!field.getFieldType().isPrimitiveType()) {
                this.bingo = true;
            }
        }

        public void visitReturn(SSAReturnInstruction instruction) {
            this.bingo = true;
        }

        public void visitThrow(SSAThrowInstruction instruction) {
            this.bingo = true;
        }
    }
}

