/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;

public abstract class CallStringContextSelector
implements ContextSelector {
    private static final ContextKey CALL_STRING = new ContextKey(){

        public String toString() {
            return "CALL_STRING_KEY";
        }
    };
    private final ContextSelector base;

    public CallStringContextSelector(ContextSelector base) {
        this.base = base;
    }

    protected abstract int getLength(CGNode var1, CallSiteReference var2, IMethod var3);

    private CallString getCallString(CGNode caller, CallSiteReference site, IMethod target) {
        int length = this.getLength(caller, site, target);
        if (length > 0) {
            if (caller.getContext().get(CALL_STRING) != null) {
                return new CallString(site, caller.getMethod(), length, (CallString)caller.getContext().get(CALL_STRING));
            }
            return new CallString(site, caller.getMethod());
        }
        return null;
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey receiver) {
        Context baseContext = this.base.getCalleeTarget(caller, site, callee, receiver);
        CallString cs = this.getCallString(caller, site, callee);
        if (cs == null) {
            return baseContext;
        }
        if (baseContext == Everywhere.EVERYWHERE) {
            return new CallStringContext(cs);
        }
        return new CallStringContextPair(cs, baseContext);
    }

    public boolean mayUnderstand(CGNode caller, CallSiteReference site, IMethod targetMethod, InstanceKey instance) {
        return this.base.mayUnderstand(caller, site, targetMethod, instance);
    }

    public boolean contextIsIrrelevant(CGNode node, CallSiteReference site) {
        return false;
    }

    public boolean allSitesDispatchIdentically(CGNode node, CallSiteReference site) {
        return false;
    }

    private class CallString
    implements ContextItem {
        private final CallSiteReference[] sites;
        private final IMethod[] methods;

        private CallString(CallSiteReference site, IMethod method) {
            this.sites = new CallSiteReference[]{site};
            this.methods = new IMethod[]{method};
        }

        private CallString(CallSiteReference site, IMethod method, int length, CallString base) {
            this.sites = new CallSiteReference[length];
            this.sites[0] = site;
            System.arraycopy(base.sites, 0, this.sites, 1, Math.min(length - 1, base.sites.length));
            this.methods = new IMethod[length];
            this.methods[0] = method;
            System.arraycopy(base.methods, 0, this.methods, 1, Math.min(length - 1, base.methods.length));
        }

        public String toString() {
            StringBuffer str = new StringBuffer("[");
            int i = 0;
            while (i < this.sites.length) {
                str.append(" ").append(this.methods[i].getName()).append("@").append(this.sites[i].getProgramCounter());
                ++i;
            }
            str.append(" ]");
            return str.toString();
        }

        public int hashCode() {
            int code = 1;
            int i = 0;
            while (i < this.sites.length) {
                code *= this.sites[i].hashCode() * this.methods[i].hashCode();
                ++i;
            }
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof CallString) {
                CallString oc = (CallString)o;
                if (oc.sites.length == this.sites.length) {
                    int i = 0;
                    while (i < this.sites.length) {
                        if (!this.sites[i].equals(oc.sites[i]) || !this.methods[i].equals(oc.methods[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private class CallStringContext
    implements Context {
        private final CallString cs;

        private CallStringContext(CallString cs) {
            this.cs = cs;
        }

        public boolean equals(Object o) {
            return o instanceof CallStringContext && ((CallStringContext)o).cs.equals(this.cs);
        }

        public int hashCode() {
            return this.cs.hashCode();
        }

        public String toString() {
            return "CallStringContext: " + this.cs.toString();
        }

        public ContextItem get(ContextKey name) {
            if (CALL_STRING.equals(name)) {
                return this.cs;
            }
            return null;
        }
    }

    private class CallStringContextPair
    implements Context {
        private final CallString cs;
        private final Context base;

        private CallStringContextPair(CallString cs, Context base) {
            this.cs = cs;
            this.base = base;
        }

        public boolean equals(Object o) {
            return o instanceof CallStringContextPair && ((CallStringContextPair)o).cs.equals(this.cs) && ((CallStringContextPair)o).base.equals(this.base);
        }

        public String toString() {
            return "CallStringContextPair: " + this.cs.toString() + ":" + this.base.toString();
        }

        public int hashCode() {
            return this.cs.hashCode() * this.base.hashCode();
        }

        public ContextItem get(ContextKey name) {
            if (CALL_STRING.equals(name)) {
                return this.cs;
            }
            return this.base.get(name);
        }
    }
}

