/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.ContainerUtil;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXInstanceKeys;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.debug.Assertions;

public class ContainerContextSelector
implements ContextSelector {
    private static final boolean DEBUG = false;
    private static final TypeName SyntheticSystemName = TypeName.string2TypeName("Lcom/ibm/wala/model/java/lang/System");
    public static final TypeReference SyntheticSystem = TypeReference.findOrCreate(ClassLoaderReference.Primordial, SyntheticSystemName);
    public static final Atom arraycopyAtom = Atom.findOrCreateUnicodeAtom("arraycopy");
    private static final Descriptor arraycopyDesc = Descriptor.findOrCreateUTF8("(Ljava/lang/Object;Ljava/lang/Object;)V");
    public static final MethodReference synthArraycopy = MethodReference.findOrCreate(SyntheticSystem, arraycopyAtom, arraycopyDesc);
    private static final TypeReference Arrays = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/util/Arrays");
    private static final MethodReference ArraysAsList = MethodReference.findOrCreate(Arrays, "asList", "([Ljava/lang/Object;)Ljava/util/List;");
    private static final MethodReference ArraysCopyOfRange = MethodReference.findOrCreate(Arrays, "copyOfRange", "([CII)[C");
    private static final MethodReference ArraysCopyOf = MethodReference.findOrCreate(Arrays, "copyOf", "([Ljava/lang/Object;I)[Ljava/lang/Object;");
    private static final MethodReference ArraysCopyOf2 = MethodReference.findOrCreate(Arrays, "copyOf", "([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
    private static final MethodReference StringValueOf = MethodReference.findOrCreate(TypeReference.JavaLangString, "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
    private final IClassHierarchy cha;
    private final ZeroXInstanceKeys delegate;

    public ContainerContextSelector(IClassHierarchy cha, ZeroXInstanceKeys delegate) {
        this.cha = cha;
        this.delegate = delegate;
        Assertions._assert(delegate != null);
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey receiver) {
        if (this.mayUnderstand(caller, site, callee, receiver)) {
            if (ContainerContextSelector.isWellKnownStaticFactory(callee.getReference())) {
                return new CallerSiteContext(caller, site);
            }
            if (receiver == null) {
                Assertions.UNREACHABLE("null receiver for " + site);
            }
            return new ReceiverInstanceContext(receiver);
        }
        return null;
    }

    public static boolean isWellKnownStaticFactory(MethodReference m) {
        if (m.getDeclaringClass().equals(TypeReference.JavaLangSystem) && m.getName().toString().equals("arraycopy")) {
            return true;
        }
        if (m.equals(synthArraycopy)) {
            return true;
        }
        if (m.equals(ArraysAsList)) {
            return true;
        }
        if (m.equals(ArraysCopyOfRange)) {
            return true;
        }
        if (m.equals(ArraysCopyOf)) {
            return true;
        }
        if (m.equals(ArraysCopyOf2)) {
            return true;
        }
        return m.equals(StringValueOf);
    }

    public static Context findRecursiveMatchingContext(IMethod M, Context C, InstanceKey receiver) {
        Context result = ContainerContextSelector.findRecursiveMatchingContext(M, C);
        if (result != null) {
            return result;
        }
        if (receiver instanceof AllocationSiteInNode) {
            AllocationSiteInNode a = (AllocationSiteInNode)receiver;
            IMethod m = a.getNode().getMethod();
            return ContainerContextSelector.findRecursiveMatchingContext(m, C);
        }
        return null;
    }

    public static CGNode findNodeRecursiveMatchingContext(IMethod M, Context C) {
        if (C instanceof ReceiverInstanceContext) {
            ReceiverInstanceContext ric = (ReceiverInstanceContext)C;
            if (!(ric.getReceiver() instanceof AllocationSiteInNode)) {
                return null;
            }
            AllocationSiteInNode I = (AllocationSiteInNode)ric.getReceiver();
            CGNode N = I.getNode();
            if (N.getMethod().equals(M)) {
                return N;
            }
            return ContainerContextSelector.findNodeRecursiveMatchingContext(M, N.getContext());
        }
        return null;
    }

    public static Context findRecursiveMatchingContext(IMethod M, Context C) {
        CGNode n = ContainerContextSelector.findNodeRecursiveMatchingContext(M, C);
        return n == null ? null : n.getContext();
    }

    public int getBoundOnNumberOfTargets(CGNode caller, CallSiteReference site, IMethod targetMethod) {
        return -1;
    }

    public boolean mayUnderstand(CGNode caller, CallSiteReference site, IMethod targetMethod, InstanceKey receiver) {
        AllocationSiteInNode I;
        CGNode N;
        if (targetMethod == null) {
            throw new IllegalArgumentException("targetMethod is null");
        }
        if (ContainerContextSelector.isWellKnownStaticFactory(targetMethod.getReference())) {
            return true;
        }
        if (site.isStatic()) {
            return false;
        }
        if (targetMethod.getDeclaringClass().getReference().equals(TypeReference.JavaLangObject)) {
            return false;
        }
        if (this.isContainer(targetMethod.getDeclaringClass())) {
            return true;
        }
        if (receiver == null) {
            IClass klass = targetMethod.getDeclaringClass();
            int n = this.cha.getNumberOfImmediateSubclasses(klass);
            if (n > 0) {
                return true;
            }
            return this.delegate.isInteresting(klass);
        }
        if (!this.delegate.isInteresting(receiver.getConcreteType())) {
            return false;
        }
        return receiver instanceof AllocationSiteInNode && (N = (I = (AllocationSiteInNode)receiver).getNode()).getContext() instanceof ReceiverInstanceContext;
    }

    protected boolean isContainer(IClass C) {
        return ContainerUtil.isContainer(C);
    }

    public boolean contextIsIrrelevant(CGNode node, CallSiteReference site) {
        return false;
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public boolean allSitesDispatchIdentically(CGNode node, CallSiteReference site) {
        return false;
    }
}

