/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.analysis.reflection.FactoryBypassInterpreter;
import com.ibm.wala.analysis.reflection.Malleable;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.ReflectionSpecification;
import com.ibm.wala.ipa.callgraph.impl.DefaultContextSelector;
import com.ibm.wala.ipa.callgraph.impl.DelegatingContextSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.callgraph.propagation.ClassBasedInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.IPointsToSolver;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.StandardSolver;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultPointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultSSAInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DelegatingSSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.rta.CallSite;
import com.ibm.wala.ipa.callgraph.propagation.rta.DelegatingExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.rta.TypeBasedPointerAnalysis;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.ResolutionFailure;
import com.ibm.wala.util.warnings.Warnings;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRTABuilder
extends PropagationCallGraphBuilder {
    protected static final int DEBUG_LEVEL = 0;
    protected static final boolean DEBUG = false;
    private static final int VERBOSE_INTERVAL = 10000;
    private static final int PERIODIC_MAINTAIN_INTERVAL = 10000;
    protected final boolean clone2Assign = true;
    protected final Set<IClass> clinitProcessed = HashSetFactory.make();
    protected final HashSet<IClass> allocatedClasses = HashSetFactory.make();
    private final Map<MethodReference, CallSite> delegateMap = HashMapFactory.make();
    private static final TypeReference[] PRE_ALLOC = new TypeReference[]{TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/Object"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ArithmeticException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ArrayStoreException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ClassCastException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ClassNotFoundException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/IndexOutOfBoundsException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/NegativeArraySizeException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ExceptionInInitializerError"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/NullPointerException")};

    protected AbstractRTABuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache, ContextSelector appContextSelector, SSAContextInterpreter appContextInterpreter, ReflectionSpecification reflect) {
        super(cha, options, cache, new DefaultPointerKeyFactory());
        this.setInstanceKeys(new ClassBasedInstanceKeys(options, cha));
        this.setContextSelector(this.makeContextSelector(appContextSelector));
        this.setContextInterpreter(this.makeContextInterpreter(appContextInterpreter, reflect));
    }

    protected RTAContextInterpreter getRTAContextInterpreter() {
        return this.getContextInterpreter();
    }

    @Override
    protected boolean addConstraintsFromNode(CGNode node) {
        if (this.haveAlreadyVisited(node)) {
            return false;
        }
        this.markAlreadyVisited(node);
        this.addNewConstraints(node);
        this.addCallConstraints(node);
        this.addFieldConstraints(node);
        return true;
    }

    private void addNewConstraints(CGNode node) {
        Iterator<NewSiteReference> it = this.getRTAContextInterpreter().iterateNewSites(node);
        while (it.hasNext()) {
            NewSiteReference n = it.next();
            this.visitNew(node, n);
        }
    }

    private void addCallConstraints(CGNode node) {
        Iterator<CallSiteReference> it = this.getRTAContextInterpreter().iterateCallSites(node);
        while (it.hasNext()) {
            CallSiteReference c = it.next();
            this.visitInvoke(node, c);
        }
    }

    private void addFieldConstraints(CGNode node) {
        FieldReference f;
        Iterator<FieldReference> it = this.getRTAContextInterpreter().iterateFieldsRead(node);
        while (it.hasNext()) {
            f = it.next();
            this.processFieldAccess(node, f);
        }
        it = this.getRTAContextInterpreter().iterateFieldsWritten(node);
        while (it.hasNext()) {
            f = it.next();
            this.processFieldAccess(node, f);
        }
    }

    private void processFieldAccess(CGNode node, FieldReference f) {
        TypeReference t = f.getDeclaringClass();
        IClass klass = this.getClassHierarchy().lookupClass(t);
        if (klass == null) {
            Warnings.add(ResolutionFailure.create(node, t));
        } else {
            this.processClassInitializer(klass);
        }
    }

    protected void processClassInitializer(IClass klass) {
        if (this.clinitProcessed.contains(klass)) {
            return;
        }
        this.clinitProcessed.add(klass);
        if (klass.getClassInitializer() != null) {
            CGNode target;
            FakeWorldClinitMethod fakeWorldClinitMethod = (FakeWorldClinitMethod)this.callGraph.getFakeWorldClinitNode().getMethod();
            MethodReference m = klass.getClassInitializer().getReference();
            CallSiteReference site = CallSiteReference.make(1, m, IInvokeInstruction.Dispatch.STATIC);
            IMethod targetMethod = this.options.getMethodTargetSelector().getCalleeTarget(this.callGraph.getFakeRootNode(), site, null);
            if (targetMethod != null && (target = this.callGraph.getNode(targetMethod, Everywhere.EVERYWHERE)) == null) {
                SSAInvokeInstruction s = fakeWorldClinitMethod.addInvocation(null, site);
                target = this.callGraph.findOrCreateNode(targetMethod, Everywhere.EVERYWHERE);
                this.processResolvedCall(this.callGraph.getFakeWorldClinitNode(), s.getCallSite(), target);
            }
        }
        try {
            klass = klass.getSuperclass();
            if (klass != null && !this.clinitProcessed.contains(klass)) {
                this.processClassInitializer(klass);
            }
        }
        catch (ClassHierarchyException e) {
            Assertions.UNREACHABLE();
        }
    }

    public void visitInvoke(CGNode node, CallSiteReference site) {
        boolean canResolveEagerly;
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        IInvokeInstruction.IDispatch code = site.getInvocationCode();
        boolean bl = canResolveEagerly = code == IInvokeInstruction.Dispatch.SPECIAL && this.getContextSelector().contextIsIrrelevant(node, site);
        if (code == IInvokeInstruction.Dispatch.STATIC || canResolveEagerly) {
            CGNode n = this.getTargetForCall(node, site, null);
            if (n == null) {
                Warnings.add(ResolutionFailure.create(node, site));
            } else {
                this.processResolvedCall(node, site, n);
                this.processClassInitializer(this.cha.lookupClass(site.getDeclaredTarget().getDeclaringClass()));
            }
        } else {
            PointerKey selector;
            if (this.getContextSelector().allSitesDispatchIdentically(node, site)) {
                CallSite delegate = this.delegateMap.get(site.getDeclaredTarget());
                if (delegate == null) {
                    delegate = new CallSite(site, node);
                    this.delegateMap.put(site.getDeclaredTarget(), delegate);
                } else {
                    if (node.equals(delegate.getNode()) && site.equals(delegate.getSite())) {
                        return;
                    }
                    DelegatingExplicitCallGraph.DelegatingCGNode dnode = (DelegatingExplicitCallGraph.DelegatingCGNode)node;
                    dnode.delegate(site, delegate.getNode(), delegate.getSite());
                    return;
                }
            }
            if ((selector = this.getKeyForSite(site)) == null) {
                Warnings.add(ResolutionFailure.create(node, site));
                return;
            }
            UnaryOperator<PointsToSetVariable> dispatchOperator = this.makeDispatchOperator(site, node);
            this.system.newSideEffect(dispatchOperator, selector);
        }
    }

    protected abstract UnaryOperator<PointsToSetVariable> makeDispatchOperator(CallSiteReference var1, CGNode var2);

    protected abstract PointerKey getKeyForSite(CallSiteReference var1);

    void processResolvedCall(CGNode caller, CallSiteReference site, CGNode target) {
        caller.addTarget(site, target);
        if (FakeRootMethod.isFakeRootMethod(caller.getMethod().getReference()) && this.entrypointCallSites.contains(site)) {
            this.callGraph.registerEntrypoint(target);
        }
        if (!this.haveAlreadyVisited(target)) {
            this.markDiscovered(target);
        }
    }

    public void visitNew(CGNode node, NewSiteReference newSite) {
        if (newSite == null) {
            throw new IllegalArgumentException("newSite is null");
        }
        if (Malleable.isMalleable(newSite.getDeclaredType())) {
            return;
        }
        InstanceKey iKey = this.getInstanceKeyForAllocation(node, newSite);
        if (iKey == null) {
            return;
        }
        IClass klass = iKey.getConcreteType();
        if (klass == null) {
            Warnings.add(ResolutionFailure.create(node, iKey.getConcreteType()));
            return;
        }
        if (this.allocatedClasses.contains(klass)) {
            return;
        }
        this.allocatedClasses.add(klass);
        this.updateSetsForNewClass(klass, iKey, node, newSite);
        this.processClassInitializer(klass);
    }

    protected abstract void updateSetsForNewClass(IClass var1, InstanceKey var2, CGNode var3, NewSiteReference var4);

    @Override
    protected void customInit() {
        super.customInit();
        FakeRootMethod m = (FakeRootMethod)this.getCallGraph().getFakeRootNode().getMethod();
        int i = 0;
        while (i < PRE_ALLOC.length) {
            SSANewInstruction n = m.addAllocation(PRE_ALLOC[i]);
            this.visitNew(this.getCallGraph().getFakeRootNode(), n.getNewSite());
            ++i;
        }
    }

    public Set<IClass> getAllocatedTypes() {
        return (Set)this.allocatedClasses.clone();
    }

    @Override
    protected IPointsToSolver makeSolver() {
        return new StandardSolver(this.system, this);
    }

    protected ContextSelector makeContextSelector(ContextSelector appContextSelector) {
        DefaultContextSelector def = new DefaultContextSelector(this.cha, this.options.getMethodTargetSelector());
        ContextSelector contextSelector = appContextSelector == null ? def : new DelegatingContextSelector(appContextSelector, def);
        return contextSelector;
    }

    protected SSAContextInterpreter makeContextInterpreter(SSAContextInterpreter appContextInterpreter, ReflectionSpecification reflect) {
        SSAContextInterpreter defI = new DefaultSSAInterpreter(this.getOptions(), this.getAnalysisCache());
        defI = new DelegatingSSAContextInterpreter(new FactoryBypassInterpreter(this.getOptions(), this.getAnalysisCache(), reflect), defI);
        DelegatingSSAContextInterpreter contextInterpreter = new DelegatingSSAContextInterpreter(appContextInterpreter, defI);
        return contextInterpreter;
    }

    @Override
    protected boolean unconditionallyAddConstraintsFromNode(CGNode node) {
        this.addNewConstraints(node);
        this.addCallConstraints(node);
        this.addFieldConstraints(node);
        this.markAlreadyVisited(node);
        return true;
    }

    @Override
    protected ExplicitCallGraph createEmptyCallGraph(IClassHierarchy cha, AnalysisOptions options) {
        return new DelegatingExplicitCallGraph(cha, options, this.getAnalysisCache());
    }

    @Override
    protected PropagationSystem makeSystem(AnalysisOptions options) {
        PropagationSystem result = super.makeSystem(options);
        result.setVerboseInterval(10000);
        result.setPeriodicMaintainInterval(10000);
        return result;
    }

    @Override
    public PointerAnalysis getPointerAnalysis() {
        return TypeBasedPointerAnalysis.make(this.getOptions(), this.allocatedClasses, this.getCallGraph());
    }
}

