/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingRTAContextInterpreter
implements RTAContextInterpreter {
    private final RTAContextInterpreter A;
    private final RTAContextInterpreter B;

    public DelegatingRTAContextInterpreter(RTAContextInterpreter A, RTAContextInterpreter B) {
        this.A = A;
        this.B = B;
        Assertions._assert(B != null, "B is null");
    }

    @Override
    public boolean understands(CGNode node) {
        if (this.A != null) {
            return this.A.understands(node) || this.B.understands(node);
        }
        return this.B.understands(node);
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
        if (this.A != null && this.A.understands(node)) {
            return this.A.iterateNewSites(node);
        }
        Assertions._assert(this.B.understands(node));
        return this.B.iterateNewSites(node);
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
        if (this.A != null && this.A.understands(node)) {
            return this.A.iterateCallSites(node);
        }
        Assertions._assert(this.B.understands(node));
        return this.B.iterateCallSites(node);
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
        if (this.A != null && this.A.understands(node)) {
            return this.A.iterateFieldsRead(node);
        }
        Assertions._assert(this.B.understands(node));
        return this.B.iterateFieldsRead(node);
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
        if (this.A != null && this.A.understands(node)) {
            return this.A.iterateFieldsWritten(node);
        }
        Assertions._assert(this.B.understands(node));
        return this.B.iterateFieldsWritten(node);
    }

    @Override
    public boolean recordFactoryType(CGNode node, IClass klass) {
        boolean result = false;
        if (this.A != null) {
            result |= this.A.recordFactoryType(node, klass);
        }
        return result |= this.B.recordFactoryType(node, klass);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.A + ", " + this.B;
    }
}

