/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.Function;
import com.ibm.wala.util.IndiscriminateFilter;
import com.ibm.wala.util.MapIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterproceduralCFG<T extends ISSABasicBlock>
implements NumberedGraph<BasicBlockInContext<T>> {
    private static final int DEBUG_LEVEL = 0;
    private static final boolean CALL_TO_RETURN_EDGES = true;
    private final NumberedGraph<BasicBlockInContext<T>> g = new SlowSparseNumberedGraph<BasicBlockInContext<T>>(2);
    private final CallGraph cg;
    private final Filter<CGNode> relevant;
    private final BitVector hasCallVector = new BitVector();
    private final Filter<BasicBlockInContext<T>> isCall = new Filter<BasicBlockInContext<T>>(){

        @Override
        public boolean accepts(BasicBlockInContext<T> o) {
            return AbstractInterproceduralCFG.this.hasCall(o);
        }
    };

    protected abstract ControlFlowGraph<T> getCFG(CGNode var1);

    public AbstractInterproceduralCFG(CallGraph cg) {
        this(cg, IndiscriminateFilter.singleton());
    }

    public AbstractInterproceduralCFG(CallGraph CG, Filter<CGNode> relevant) {
        this.cg = CG;
        this.relevant = relevant;
        this.createNodes();
        this.createEdges();
    }

    private void createEdges() {
        for (CGNode n : this.cg) {
            ControlFlowGraph<T> cfg;
            if (!this.relevant.accepts(n) || (cfg = this.getCFG(n)) == null) continue;
            IInstruction[] instrs = cfg.getInstructions();
            for (ISSABasicBlock bb : cfg) {
                if (bb == cfg.entry()) {
                    this.addEdgesToEntryBlock(n, bb);
                    continue;
                }
                this.addEdgesToNonEntryBlock(n, cfg, instrs, bb);
            }
        }
    }

    private void createNodes() {
        for (CGNode n : this.cg) {
            ControlFlowGraph<T> cfg;
            if (!this.relevant.accepts(n) || (cfg = this.getCFG(n)) == null) continue;
            this.addNodeForEachBasicBlock(cfg, n);
        }
    }

    private void addEdgesToNonEntryBlock(CGNode n, ControlFlowGraph<T> cfg, IInstruction[] instrs, T bb) {
        Iterator<T> ps = cfg.getPredNodes(bb);
        while (ps.hasNext()) {
            ISSABasicBlock pb = (ISSABasicBlock)ps.next();
            if (pb.getLastInstructionIndex() < 0) {
                BasicBlockInContext<ISSABasicBlock> p = new BasicBlockInContext<ISSABasicBlock>(n, pb);
                BasicBlockInContext<T> b = new BasicBlockInContext<T>(n, bb);
                this.g.addEdge(p, b);
                continue;
            }
            int index = pb.getLastInstructionIndex();
            IInstruction inst = instrs[index];
            if (inst instanceof IInvokeInstruction) {
                IInvokeInstruction call = (IInvokeInstruction)inst;
                CallSiteReference site = AbstractInterproceduralCFG.makeCallSiteReference(n.getMethod().getDeclaringClass().getClassLoader().getReference(), cfg.getProgramCounter(index), call);
                boolean irrelevantTargets = false;
                for (CGNode tn : this.cg.getPossibleTargets(n, site)) {
                    if (!this.relevant.accepts(tn)) {
                        irrelevantTargets = true;
                        continue;
                    }
                    ControlFlowGraph<T> tcfg = this.getCFG(tn);
                    if (tcfg == null) continue;
                    this.addEdgesFromExitToReturn(n, bb, tn, tcfg);
                }
                if (!irrelevantTargets) {
                    // empty if block
                }
                BasicBlockInContext<ISSABasicBlock> p = new BasicBlockInContext<ISSABasicBlock>(n, pb);
                BasicBlockInContext<T> b = new BasicBlockInContext<T>(n, bb);
                this.g.addEdge(p, b);
                continue;
            }
            BasicBlockInContext<ISSABasicBlock> p = new BasicBlockInContext<ISSABasicBlock>(n, pb);
            BasicBlockInContext<T> b = new BasicBlockInContext<T>(n, bb);
            if (!this.g.containsNode(p) || !this.g.containsNode(b)) {
                Assertions._assert(this.g.containsNode(p), "IPCFG does not contain " + p);
                Assertions._assert(this.g.containsNode(b), "IPCFG does not contain " + b);
            }
            this.g.addEdge(p, b);
        }
    }

    public static CallSiteReference makeCallSiteReference(ClassLoaderReference loader, int pc, IInvokeInstruction call) throws IllegalArgumentException, IllegalArgumentException {
        if (call == null) {
            throw new IllegalArgumentException("call == null");
        }
        if (!(call instanceof SSAAbstractInvokeInstruction) && !(call instanceof InvokeInstruction)) {
            throw new IllegalArgumentException("(not ( call instanceof com.ibm.wala.ssa.SSAAbstractInvokeInstruction ) ) and (not ( call instanceof com.ibm.wala.shrikeBT.InvokeInstruction ) )");
        }
        CallSiteReference site = null;
        if (call instanceof InvokeInstruction) {
            InvokeInstruction c = (InvokeInstruction)call;
            site = CallSiteReference.make(pc, MethodReference.findOrCreate(loader, c.getClassType(), c.getMethodName(), c.getMethodSignature()), call.getInvocationCode());
        } else {
            SSAAbstractInvokeInstruction c = (SSAAbstractInvokeInstruction)call;
            site = CallSiteReference.make(pc, c.getDeclaredTarget(), call.getInvocationCode());
        }
        return site;
    }

    private void addEdgesFromExitToReturn(CGNode caller, T returnBlock, CGNode target, ControlFlowGraph<? extends T> targetCFG) {
        ISSABasicBlock texit = (ISSABasicBlock)targetCFG.exit();
        BasicBlockInContext<ISSABasicBlock> exit = new BasicBlockInContext<ISSABasicBlock>(target, texit);
        BasicBlockInContext<T> ret = new BasicBlockInContext<T>(caller, returnBlock);
        if (!this.g.containsNode(exit) || !this.g.containsNode(ret)) {
            Assertions._assert(this.g.containsNode(exit), "IPCFG does not contain " + exit);
            Assertions._assert(this.g.containsNode(ret), "IPCFG does not contain " + ret);
        }
        this.g.addEdge(exit, ret);
    }

    private void addEdgesToEntryBlock(CGNode n, T bb) {
        Iterator<CGNode> callers = this.cg.getPredNodes(n);
        while (callers.hasNext()) {
            CGNode caller = callers.next();
            if (!this.relevant.accepts(caller)) continue;
            ControlFlowGraph<T> ccfg = this.getCFG(caller);
            IInstruction[] cinsts = ccfg.getInstructions();
            int i = 0;
            while (i < cinsts.length) {
                if (cinsts[i] instanceof IInvokeInstruction) {
                    IInvokeInstruction call = (IInvokeInstruction)cinsts[i];
                    CallSiteReference site = AbstractInterproceduralCFG.makeCallSiteReference(n.getMethod().getDeclaringClass().getClassLoader().getReference(), ccfg.getProgramCounter(i), call);
                    if (this.cg.getPossibleTargets(caller, site).contains(n)) {
                        ISSABasicBlock callerBB = (ISSABasicBlock)ccfg.getBlockForInstruction(i);
                        BasicBlockInContext<ISSABasicBlock> b1 = new BasicBlockInContext<ISSABasicBlock>(caller, callerBB);
                        BasicBlockInContext<T> b2 = new BasicBlockInContext<T>(n, bb);
                        this.g.addEdge(b1, b2);
                    }
                }
                ++i;
            }
        }
    }

    private void addNodeForEachBasicBlock(ControlFlowGraph<? extends T> cfg, CGNode N) {
        for (ISSABasicBlock bb : cfg) {
            BasicBlockInContext<ISSABasicBlock> b = new BasicBlockInContext<ISSABasicBlock>(N, bb);
            this.g.addNode(b);
            if (!this.hasCall(b, cfg)) continue;
            this.hasCallVector.set(this.getNumber(b));
        }
    }

    public ControlFlowGraph<T> getCFG(BasicBlockInContext B) throws IllegalArgumentException {
        if (B == null) {
            throw new IllegalArgumentException("B == null");
        }
        return this.getCFG(this.getCGNode(B));
    }

    public CGNode getCGNode(BasicBlockInContext B) throws IllegalArgumentException {
        if (B == null) {
            throw new IllegalArgumentException("B == null");
        }
        return B.getNode();
    }

    @Override
    public void removeNodeAndEdges(BasicBlockInContext N) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<BasicBlockInContext<T>> iterator() {
        return this.g.iterator();
    }

    @Override
    public int getNumberOfNodes() {
        return this.g.getNumberOfNodes();
    }

    @Override
    public void addNode(BasicBlockInContext n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNode(BasicBlockInContext n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<? extends BasicBlockInContext<T>> getPredNodes(BasicBlockInContext<T> N) {
        return this.g.getPredNodes(N);
    }

    @Override
    public int getPredNodeCount(BasicBlockInContext<T> N) {
        return this.g.getPredNodeCount(N);
    }

    @Override
    public Iterator<? extends BasicBlockInContext<T>> getSuccNodes(BasicBlockInContext<T> N) {
        return this.g.getSuccNodes(N);
    }

    @Override
    public int getSuccNodeCount(BasicBlockInContext<T> N) {
        return this.g.getSuccNodeCount(N);
    }

    @Override
    public void addEdge(BasicBlockInContext src, BasicBlockInContext dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(BasicBlockInContext src, BasicBlockInContext dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllIncidentEdges(BasicBlockInContext node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.g.toString();
    }

    @Override
    public boolean containsNode(BasicBlockInContext<T> N) {
        return this.g.containsNode(N);
    }

    public boolean hasCall(BasicBlockInContext<T> B) {
        if (!this.containsNode(B)) {
            Assertions._assert(this.containsNode(B));
        }
        return this.hasCallVector.get(this.getNumber(B));
    }

    private boolean hasCall(BasicBlockInContext B, ControlFlowGraph cfg) {
        IInstruction[] statements = cfg.getInstructions();
        int lastIndex = B.getLastInstructionIndex();
        if (lastIndex >= 0) {
            if (statements.length <= lastIndex) {
                System.err.println(statements.length);
                System.err.println(cfg);
                Assertions._assert(lastIndex < statements.length, "bad BB " + B + " and CFG for " + this.getCGNode(B));
            }
            IInstruction last = statements[lastIndex];
            return last instanceof IInvokeInstruction;
        }
        return false;
    }

    public Set<CGNode> getCallTargets(BasicBlockInContext B) {
        if (B == null) {
            throw new IllegalArgumentException("B is null");
        }
        ControlFlowGraph<T> cfg = this.getCFG(B);
        return this.getCallTargets(B, cfg, this.getCGNode(B));
    }

    private Set<CGNode> getCallTargets(IBasicBlock B, ControlFlowGraph cfg, CGNode Bnode) {
        IInstruction[] statements = cfg.getInstructions();
        IInvokeInstruction call = (IInvokeInstruction)statements[B.getLastInstructionIndex()];
        int pc = cfg.getProgramCounter(B.getLastInstructionIndex());
        CallSiteReference site = AbstractInterproceduralCFG.makeCallSiteReference(B.getMethod().getDeclaringClass().getClassLoader().getReference(), pc, call);
        HashSet<CGNode> result = HashSetFactory.make(this.cg.getNumberOfTargets(Bnode, site));
        for (CGNode target : this.cg.getPossibleTargets(Bnode, site)) {
            result.add(target);
        }
        return result;
    }

    @Override
    public void removeIncomingEdges(BasicBlockInContext node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(BasicBlockInContext node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasEdge(BasicBlockInContext<T> src, BasicBlockInContext<T> dst) {
        return this.g.hasEdge(src, dst);
    }

    @Override
    public int getNumber(BasicBlockInContext<T> N) {
        return this.g.getNumber(N);
    }

    @Override
    public BasicBlockInContext<T> getNode(int number) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public int getMaxNumber() {
        return this.g.getMaxNumber();
    }

    @Override
    public Iterator<BasicBlockInContext<T>> iterateNodes(IntSet s) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(BasicBlockInContext<T> node) {
        return this.g.getSuccNodeNumbers(node);
    }

    @Override
    public IntSet getPredNodeNumbers(BasicBlockInContext<T> node) {
        return this.g.getPredNodeNumbers(node);
    }

    public BasicBlockInContext<T> getEntry(CGNode n) {
        ControlFlowGraph<T> cfg = this.getCFG(n);
        ISSABasicBlock entry = (ISSABasicBlock)cfg.entry();
        return new BasicBlockInContext<ISSABasicBlock>(n, entry);
    }

    public BasicBlockInContext<T> getExit(CGNode n) {
        ControlFlowGraph<T> cfg = this.getCFG(n);
        ISSABasicBlock entry = (ISSABasicBlock)cfg.exit();
        return new BasicBlockInContext<ISSABasicBlock>(n, entry);
    }

    public Iterator<BasicBlockInContext> getReturnSites(BasicBlockInContext<T> bb) {
        if (bb == null) {
            throw new IllegalArgumentException("bb is null");
        }
        final CGNode node = bb.getNode();
        Filter isReturn = new Filter(){

            public boolean accepts(Object o) {
                Assertions._assert(o instanceof BasicBlockInContext);
                BasicBlockInContext other = (BasicBlockInContext)o;
                return !other.isEntryBlock() && node.equals(other.getNode());
            }
        };
        return new FilterIterator<BasicBlockInContext>(this.getSuccNodes(bb), isReturn);
    }

    public Iterator<BasicBlockInContext<T>> getCallSites(BasicBlockInContext<T> bb) {
        if (bb == null) {
            throw new IllegalArgumentException("bb is null");
        }
        ControlFlowGraph<T> cfg = this.getCFG(bb);
        Iterator<T> it = cfg.getPredNodes(bb.getDelegate());
        final CGNode node = bb.getNode();
        Function toContext = new Function<T, BasicBlockInContext<T>>(){

            @Override
            public BasicBlockInContext<T> apply(T object) {
                Object b = object;
                return new BasicBlockInContext(node, b);
            }
        };
        MapIterator m = new MapIterator(it, toContext);
        return new FilterIterator<BasicBlockInContext<T>>(m, this.isCall);
    }

    public boolean isReturn(BasicBlockInContext<T> bb) throws IllegalArgumentException {
        if (bb == null) {
            throw new IllegalArgumentException("bb == null");
        }
        ControlFlowGraph<T> cfg = this.getCFG(bb);
        Iterator<T> it = cfg.getPredNodes(bb.getDelegate());
        while (it.hasNext()) {
            ISSABasicBlock b = (ISSABasicBlock)it.next();
            if (!this.hasCall(new BasicBlockInContext<ISSABasicBlock>(bb.getNode(), b))) continue;
            return true;
        }
        return false;
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }
}

