/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cha;

import com.ibm.wala.annotations.Internal;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.CancelCHAConstructionException;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyWarning;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.CacheReference;
import com.ibm.wala.util.Function;
import com.ibm.wala.util.MapIterator;
import com.ibm.wala.util.ReferenceCleanser;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHierarchy
implements IClassHierarchy {
    private static final boolean DEBUG = false;
    private final Set<Language> languages = new HashSet<Language>();
    private final HashMap<IClass, Node> map = HashMapFactory.make();
    private TypeReference rootTypeRef;
    private Node root;
    private final ClassLoaderFactory factory;
    private final IClassLoader[] loaders;
    private final HashMap<IClass, Object> targetCache = HashMapFactory.make();
    private final AnalysisScope scope;
    private final Map<IClass, Set<IClass>> implementors = HashMapFactory.make();
    private Collection<IClass> subclassesOfError;
    private Collection<TypeReference> subTypeRefsOfError;
    private int nextNumber = 1;
    private static final Atom syntheticLoaderName = Atom.findOrCreateUnicodeAtom("Synthetic");
    private static final ClassLoaderReference syntheticLoaderRef = new ClassLoaderReference(syntheticLoaderName, Language.JAVA.getName());

    private Set<IClass> computeSuperclasses(IClass klass) throws ClassHierarchyException {
        Set result = HashSetFactory.make(3);
        klass = klass.getSuperclass();
        while (klass != null) {
            result.add(klass);
            klass = klass.getSuperclass();
        }
        return result;
    }

    private ClassHierarchy(AnalysisScope scope, ClassLoaderFactory factory, Language language, IProgressMonitor progressMonitor) throws ClassHierarchyException, IllegalArgumentException {
        this(scope, factory, (Collection<Language>)Collections.singleton(language), progressMonitor);
    }

    private ClassHierarchy(AnalysisScope scope, ClassLoaderFactory factory, IProgressMonitor progressMonitor) throws ClassHierarchyException, IllegalArgumentException {
        this(scope, factory, scope.getLanguages(), progressMonitor);
    }

    private ClassHierarchy(AnalysisScope scope, ClassLoaderFactory factory, Collection<Language> languages, IProgressMonitor progressMonitor) throws ClassHierarchyException, IllegalArgumentException {
        Warnings.clear();
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        if (scope.getLanguages().size() == 0) {
            throw new IllegalArgumentException("AnalysisScope must contain at least 1 language");
        }
        this.scope = scope;
        this.factory = factory;
        HashSet<Atom> langNames = new HashSet<Atom>();
        for (Language lang : languages) {
            this.languages.add(lang);
            this.languages.addAll(lang.getDerivedLanguages());
            langNames.add(lang.getName());
        }
        for (Language lang : this.languages) {
            if (lang.getRootType() == null) continue;
            if (this.rootTypeRef != null) {
                throw new IllegalArgumentException("AnalysisScope must have only 1 root type");
            }
            this.rootTypeRef = lang.getRootType();
        }
        try {
            try {
                int numLoaders = 0;
                for (ClassLoaderReference ref : scope.getLoaders()) {
                    if (!langNames.contains(ref.getLanguage())) continue;
                    ++numLoaders;
                }
                this.loaders = new IClassLoader[numLoaders];
                int idx = 0;
                if (progressMonitor != null) {
                    progressMonitor.beginTask("Build Class Hierarchy", numLoaders);
                }
                for (ClassLoaderReference ref : scope.getLoaders()) {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        throw new CancelCHAConstructionException();
                    }
                    if (!langNames.contains(ref.getLanguage())) continue;
                    IClassLoader icl = factory.getLoader(ref, this, scope);
                    this.loaders[idx++] = icl;
                    this.addAllClasses(icl, progressMonitor);
                    if (progressMonitor == null) continue;
                    progressMonitor.worked(1);
                }
            }
            catch (IOException e) {
                throw new ClassHierarchyException("factory.getLoader failed " + e);
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
        if (this.root == null) {
            throw new ClassHierarchyException("failed to load root " + this.rootTypeRef + " of class hierarchy");
        }
        this.numberTree();
        ReferenceCleanser.registerClassHierarchy(this);
    }

    private void addAllClasses(IClassLoader loader, IProgressMonitor progressMonitor) throws CancelCHAConstructionException {
        Collection toRemove = HashSetFactory.make();
        Iterator<IClass> it = loader.iterateAllClasses();
        while (it.hasNext()) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new CancelCHAConstructionException();
            }
            IClass klass = it.next();
            boolean added = this.addClass(klass);
            if (added) continue;
            toRemove.add(klass);
        }
        loader.removeAll(toRemove);
    }

    @Override
    public boolean addClass(IClass klass) {
        Collection<IClass> loadedSuperInterfaces;
        Set<IClass> loadedSuperclasses;
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        try {
            loadedSuperclasses = this.computeSuperclasses(klass);
            loadedSuperInterfaces = klass.getAllImplementedInterfaces();
        }
        catch (ClassHierarchyException e) {
            if (klass instanceof ShrikeClass) {
                // empty if block
            }
            Warnings.add(ClassExclusion.create(klass.getReference(), e.getMessage()));
            return false;
        }
        Node node = this.findOrCreateNode(klass);
        if (klass.getReference().equals(this.rootTypeRef)) {
            Assertions._assert(this.root == null);
            this.root = node;
        }
        Set workingSuperclasses = HashSetFactory.make(loadedSuperclasses);
        while (node != null) {
            IClass c = node.getJavaClass();
            IClass superclass = null;
            try {
                superclass = c.getSuperclass();
            }
            catch (ClassHierarchyException e1) {
                Assertions.UNREACHABLE();
            }
            if (superclass != null) {
                workingSuperclasses.remove(superclass);
                Node supernode = this.findOrCreateNode(superclass);
                supernode.addChild(node);
                if (supernode.getJavaClass().getReference().equals(this.rootTypeRef)) {
                    node = null;
                    continue;
                }
                node = supernode;
                continue;
            }
            node = null;
        }
        if (loadedSuperInterfaces != null) {
            for (IClass iface : loadedSuperInterfaces) {
                try {
                    this.computeSuperclasses(iface);
                }
                catch (ClassHierarchyException e) {
                    Warnings.add(ClassExclusion.create(iface.getReference(), e.getMessage()));
                    continue;
                }
                this.recordImplements(klass, iface);
            }
        }
        return true;
    }

    private void recordImplements(IClass klass, IClass iface) {
        Set<IClass> impls = MapUtil.findOrCreateSet(this.implementors, iface);
        impls.add(klass);
    }

    @Override
    public Collection<IMethod> getPossibleTargets(MethodReference ref) {
        IClassLoader loader;
        if (ref == null) {
            throw new IllegalArgumentException("ref is null");
        }
        try {
            loader = this.factory.getLoader(ref.getDeclaringClass().getClassLoader(), this, this.scope);
        }
        catch (IOException e) {
            throw new UnimplementedError("factory.getLoader failed " + e);
        }
        IClass declaredClass = loader.lookupClass(ref.getDeclaringClass().getName());
        if (declaredClass == null) {
            return Collections.emptySet();
        }
        Set targets = HashSetFactory.make();
        targets.addAll(this.findOrCreateTargetSet(declaredClass, ref));
        return targets;
    }

    private Set<IMethod> findOrCreateTargetSet(IClass declaredClass, MethodReference ref) {
        Set<IMethod> result;
        Map classCache = (Map)CacheReference.get(this.targetCache.get(declaredClass));
        if (classCache == null) {
            classCache = HashMapFactory.make(3);
            this.targetCache.put(declaredClass, CacheReference.make(classCache));
        }
        if ((result = (Set<IMethod>)classCache.get(ref)) == null) {
            result = this.computePossibleTargets(declaredClass, ref);
            classCache.put(ref, result);
        }
        return result;
    }

    private Set<IMethod> computePossibleTargets(IClass declaredClass, MethodReference ref) {
        if (declaredClass.isInterface()) {
            HashSet<IMethod> result = HashSetFactory.make(3);
            Set<IClass> impls = this.implementors.get(declaredClass);
            if (impls == null) {
                return Collections.emptySet();
            }
            for (IClass klass : impls) {
                if (klass.isInterface()) continue;
                result.addAll(this.computeTargetsNotInterface(ref, klass));
            }
            return result;
        }
        return this.computeTargetsNotInterface(ref, declaredClass);
    }

    private Set<IMethod> computeTargetsNotInterface(MethodReference ref, IClass klass) {
        Node n = this.findNode(klass);
        HashSet<IMethod> result = HashSetFactory.make(3);
        if (n == null) {
            return result;
        }
        Selector selector = ref.getSelector();
        IMethod resolved = this.resolveMethod(klass, selector);
        if (resolved != null) {
            result.add(resolved);
        }
        result.addAll(this.computeOverriders(n, selector));
        return result;
    }

    @Override
    public IMethod resolveMethod(MethodReference m) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        IClass receiver = this.lookupClass(m.getDeclaringClass());
        if (receiver == null) {
            return null;
        }
        Selector selector = m.getSelector();
        return this.resolveMethod(receiver, selector);
    }

    @Override
    public IField resolveField(FieldReference f) {
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        IClass klass = this.lookupClass(f.getDeclaringClass());
        if (klass == null) {
            return null;
        }
        return this.resolveField(klass, f);
    }

    @Override
    public IField resolveField(IClass klass, FieldReference f) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        return klass.getField(f.getName());
    }

    @Override
    public IMethod resolveMethod(IClass receiverClass, Selector selector) {
        if (receiverClass == null) {
            throw new IllegalArgumentException("receiverClass is null");
        }
        IMethod result = this.findMethod(receiverClass, selector);
        if (result != null) {
            return result;
        }
        IClass superclass = null;
        try {
            superclass = receiverClass.getSuperclass();
        }
        catch (ClassHierarchyException e) {
            Assertions.UNREACHABLE();
        }
        if (superclass == null) {
            return null;
        }
        return this.resolveMethod(superclass, selector);
    }

    private IMethod findMethod(IClass clazz, Selector selector) {
        return clazz.getMethod(selector);
    }

    private Set<IMethod> computeOverriders(Node node, Selector selector) {
        HashSet<IMethod> result = HashSetFactory.make(3);
        Iterator<Node> it = node.getChildren();
        while (it.hasNext()) {
            Node child = it.next();
            IMethod m = this.findMethod(child.getJavaClass(), selector);
            if (m != null) {
                result.add(m);
            }
            result.addAll(this.computeOverriders(child, selector));
        }
        return result;
    }

    private Node findNode(IClass klass) {
        return this.map.get(klass);
    }

    private Node findOrCreateNode(IClass klass) {
        Node result = this.map.get(klass);
        if (result == null) {
            result = new Node(klass);
            this.map.put(klass, result);
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(100);
        this.recursiveStringify(this.root, result);
        return result.toString();
    }

    private void recursiveStringify(Node n, StringBuffer buffer) {
        buffer.append(n.toString()).append("\n");
        Iterator<Node> it = n.getChildren();
        while (it.hasNext()) {
            Node child = it.next();
            this.recursiveStringify(child, buffer);
        }
    }

    private void numberTree() {
        Assertions._assert(this.root != null);
        this.visitForNumbering(this.root);
    }

    private void visitForNumbering(Node N) {
        N.left = this.nextNumber++;
        for (Node C : N.children) {
            this.visitForNumbering(C);
        }
        N.right = this.nextNumber++;
    }

    @Override
    public ClassLoaderFactory getFactory() {
        return this.factory;
    }

    @Override
    public IClass getLeastCommonSuperclass(IClass A, IClass B) {
        Set<IClass> superB;
        if (A == null) {
            throw new IllegalArgumentException("A is null");
        }
        TypeReference tempA = A.getReference();
        if (A.equals(B)) {
            return A;
        }
        if (tempA.equals(TypeReference.Null)) {
            return B;
        }
        if (B.getReference().equals(TypeReference.Null)) {
            return A;
        }
        if (B.getReference().equals(TypeReference.JavaLangObject)) {
            return B;
        }
        Node n = this.map.get(B);
        if (n == null) {
            Assertions._assert(n != null, "null n for " + B);
        }
        try {
            superB = this.getSuperclasses(B);
        }
        catch (ClassHierarchyException e1) {
            e1.printStackTrace();
            Assertions.UNREACHABLE();
            superB = null;
        }
        while (A != null) {
            if (superB.contains(A)) {
                return A;
            }
            try {
                A = A.getSuperclass();
            }
            catch (ClassHierarchyException e) {
                Assertions.UNREACHABLE();
            }
        }
        Assertions.UNREACHABLE("getLeastCommonSuperclass " + tempA + " " + B);
        return null;
    }

    private Set<IClass> getSuperclasses(IClass c) throws ClassHierarchyException {
        HashSet<IClass> result = HashSetFactory.make(3);
        while (c.getSuperclass() != null) {
            result.add(c.getSuperclass());
            c = c.getSuperclass();
        }
        return result;
    }

    @Override
    public TypeReference getLeastCommonSuperclass(TypeReference A, TypeReference B) {
        if (A == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (A.equals(B)) {
            return A;
        }
        IClass AClass = this.lookupClass(A);
        IClass BClass = this.lookupClass(B);
        if (AClass == null || BClass == null) {
            return TypeReference.JavaLangObject;
        }
        return this.getLeastCommonSuperclass(AClass, BClass).getReference();
    }

    @Override
    public IClass lookupClass(TypeReference A) {
        if (A == null) {
            throw new IllegalArgumentException("A is null");
        }
        ClassLoaderReference loaderRef = A.getClassLoader();
        int i = 0;
        while (i < this.loaders.length) {
            IClass klass;
            if (this.loaders[i].getReference().equals(loaderRef) && (klass = this.loaders[i].lookupClass(A.getName())) != null) {
                if (this.findNode(klass) != null) {
                    return klass;
                }
                if (klass == null) {
                    Assertions._assert(klass != null, "error looking up type " + A);
                }
                if (klass.isArrayClass()) {
                    TypeReference t = klass.getReference().getInnermostElementType();
                    if (t.isPrimitiveType()) {
                        return klass;
                    }
                    IClass tClass = this.lookupClass(t);
                    if (tClass != null) {
                        return klass;
                    }
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    private boolean slowIsSubclass(IClass sub, IClass sup) {
        IClass parent;
        block4: {
            if (sub == sup) {
                return true;
            }
            try {
                parent = sub.getSuperclass();
                if (parent != null) break block4;
                return false;
            }
            catch (ClassHierarchyException e) {
                Assertions.UNREACHABLE();
                return false;
            }
        }
        return this.slowIsSubclass(parent, sup);
    }

    @Override
    public boolean isSyntheticClass(IClass c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        return c.getClassLoader() == this.getLoader(syntheticLoaderRef);
    }

    @Override
    public boolean isSubclassOf(IClass c, IClass T) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        Assertions._assert(T != null, "null T");
        if (c.isArrayClass()) {
            if (T.getReference() == TypeReference.JavaLangObject) {
                return true;
            }
            if (T.getReference().isArrayType()) {
                TypeReference elementType = T.getReference().getArrayElementType();
                if (elementType.isPrimitiveType()) {
                    return elementType.equals(c.getReference().getArrayElementType());
                }
                IClass elementKlass = this.lookupClass(elementType);
                if (elementKlass == null) {
                    Warnings.add(ClassHierarchyWarning.create("could not find " + elementType));
                    return false;
                }
                IClass ce = ((ArrayClass)c).getElementClass();
                if (ce == null) {
                    return false;
                }
                return this.isSubclassOf(ce, elementKlass);
            }
            return false;
        }
        if (T.getReference().isArrayType()) {
            return false;
        }
        if (c.getReference().equals(T.getReference())) {
            return true;
        }
        Node n1 = this.map.get(c);
        if (n1 == null) {
            return false;
        }
        Node n2 = this.map.get(T);
        if (n2 == null) {
            return false;
        }
        if (n1.left == -1) {
            return this.slowIsSubclass(c, T);
        }
        if (n2.left == -1) {
            return this.slowIsSubclass(c, T);
        }
        return n2.left <= n1.left && n1.left <= n2.right;
    }

    @Override
    public boolean implementsInterface(IClass c, IClass i) {
        if (!i.isInterface()) {
            return false;
        }
        Set<IClass> impls = this.implementors.get(i);
        return impls != null && impls.contains(c);
    }

    @Override
    public Collection<IClass> computeSubClasses(TypeReference type) {
        IClass T = this.lookupClass(type);
        if (T == null) {
            Assertions._assert(T != null, "null class for type " + type);
        }
        if (T.getReference().equals(TypeReference.JavaLangError)) {
            if (this.subclassesOfError == null) {
                this.subclassesOfError = this.computeSubClassesInternal(T);
            }
            return this.subclassesOfError;
        }
        return this.computeSubClassesInternal(T);
    }

    @Override
    public Collection<TypeReference> getJavaLangErrorTypes() {
        if (this.subTypeRefsOfError == null) {
            this.computeSubClasses(TypeReference.JavaLangError);
            this.subTypeRefsOfError = HashSetFactory.make(this.subclassesOfError.size());
            for (IClass klass : this.subclassesOfError) {
                this.subTypeRefsOfError.add(klass.getReference());
            }
        }
        return Collections.unmodifiableCollection(this.subTypeRefsOfError);
    }

    private Set<IClass> computeSubClassesInternal(IClass T) {
        if (T.isArrayClass()) {
            return Collections.singleton(T);
        }
        Node node = this.findNode(T);
        if (node == null) {
            Assertions._assert(node != null, "null node for class " + T);
        }
        HashSet<IClass> result = HashSetFactory.make(3);
        result.add(T);
        Iterator<Node> it = node.getChildren();
        while (it.hasNext()) {
            Node child = it.next();
            result.addAll(this.computeSubClasses(child.klass.getReference()));
        }
        return result;
    }

    @Override
    public boolean isInterface(TypeReference type) {
        IClass T = this.lookupClass(type);
        if (T == null) {
            Assertions._assert(T != null, "Null lookup for " + type);
        }
        return T.isInterface();
    }

    @Override
    public Set<IClass> getImplementors(TypeReference type) {
        IClass T = this.lookupClass(type);
        Set<IClass> result = this.implementors.get(T);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Iterator<IClass> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int getNumberOfClasses() {
        return this.map.keySet().size();
    }

    @Override
    public IClassLoader[] getLoaders() {
        return this.loaders;
    }

    @Override
    public IClassLoader getLoader(ClassLoaderReference loaderRef) {
        int i = 0;
        while (i < this.loaders.length) {
            if (this.loaders[i].getReference().equals(loaderRef)) {
                return this.loaders[i];
            }
            ++i;
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public AnalysisScope getScope() {
        return this.scope;
    }

    @Override
    public int getNumberOfImmediateSubclasses(IClass klass) {
        Node node = this.findNode(klass);
        return node.children.size();
    }

    @Override
    public Collection<IClass> getImmediateSubclasses(IClass klass) {
        Function<Node, IClass> node2Class = new Function<Node, IClass>(){

            @Override
            public IClass apply(Node n) {
                return n.klass;
            }
        };
        return Iterator2Collection.toCollection(new MapIterator<Node, IClass>(this.findNode(klass).children.iterator(), node2Class));
    }

    public static ClassHierarchy make(AnalysisScope scope) throws NullPointerException, ClassHierarchyException {
        return ClassHierarchy.make(scope, new ClassLoaderFactoryImpl(scope.getExclusions()));
    }

    @Internal
    public static ClassHierarchy make(AnalysisScope scope, IProgressMonitor monitor) throws ClassHierarchyException {
        return ClassHierarchy.make(scope, (ClassLoaderFactory)new ClassLoaderFactoryImpl(scope.getExclusions()), monitor);
    }

    public static ClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory) throws ClassHierarchyException {
        return new ClassHierarchy(scope, factory, (IProgressMonitor)new NullProgressMonitor());
    }

    @Internal
    public static ClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory, IProgressMonitor monitor) throws ClassHierarchyException {
        return new ClassHierarchy(scope, factory, monitor);
    }

    public static ClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory, Set<Language> languages) throws ClassHierarchyException {
        return new ClassHierarchy(scope, factory, languages, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory, Language language) throws ClassHierarchyException {
        return new ClassHierarchy(scope, factory, language, (IProgressMonitor)new NullProgressMonitor());
    }

    @Internal
    public static ClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory, Language language, IProgressMonitor monitor) throws ClassHierarchyException {
        return new ClassHierarchy(scope, factory, language, monitor);
    }

    @Override
    public IClass getRootClass() {
        return this.root.getJavaClass();
    }

    @Override
    public boolean isRootClass(IClass c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        return c.equals(this.root.getJavaClass());
    }

    @Override
    public int getNumber(IClass c) {
        return this.map.get(c).left;
    }

    @Override
    public boolean isAssignableFrom(IClass c1, IClass c2) {
        if (c2 == null) {
            throw new IllegalArgumentException("c2 is null");
        }
        if (c1 == null) {
            throw new IllegalArgumentException("c1 is null");
        }
        if (c1.isInterface()) {
            return this.implementsInterface(c2, c1);
        }
        if (c2.isInterface()) {
            return c1.equals(this.getRootClass());
        }
        return this.isSubclassOf(c2, c1);
    }

    public static boolean isInnerClass(IClass klass) throws NullPointerException {
        return klass.getName().toString().indexOf("$") > -1;
    }

    private static class ClassExclusion
    extends Warning {
        final TypeReference klass;
        final String message;

        ClassExclusion(TypeReference klass, String message) {
            super((byte)1);
            this.klass = klass;
            this.message = message;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.klass + " " + this.message;
        }

        public static ClassExclusion create(TypeReference klass, String message) {
            return new ClassExclusion(klass, message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Node {
        private final IClass klass;
        private final Set<Node> children = HashSetFactory.make(3);
        private int left = -1;
        private int right = -1;

        Node(IClass klass) {
            this.klass = klass;
        }

        boolean isInterface() {
            return this.klass.isInterface();
        }

        IClass getJavaClass() {
            return this.klass;
        }

        void addChild(Node child) {
            this.children.add(child);
        }

        Iterator<Node> getChildren() {
            return this.children.iterator();
        }

        public String toString() {
            StringBuffer result = new StringBuffer(100);
            result.append(this.klass.toString()).append(":");
            Iterator<Node> i = this.children.iterator();
            while (i.hasNext()) {
                Node n = i.next();
                result.append(n.klass.toString());
                if (!i.hasNext()) continue;
                result.append(",");
            }
            return result.toString();
        }

        public int hashCode() {
            return this.klass.hashCode() * 929;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

