/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.modref;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.modref.DelegatingExtendedHeapModel;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.modref.GenReach;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModRef {
    public static ModRef make() {
        return new ModRef();
    }

    protected ModRef() {
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeMod(CallGraph cg, PointerAnalysis pa, HeapExclusions heapExclude) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Map<CGNode, Collection<PointerKey>> scan = this.scanForMod(cg, pa, heapExclude);
        return this.transitiveClosure(cg, scan);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeRef(CallGraph cg, PointerAnalysis pa, HeapExclusions heapExclude) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Map<CGNode, Collection<PointerKey>> scan = this.scanForRef(cg, pa, heapExclude);
        return this.transitiveClosure(cg, scan);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeMod(CallGraph cg, PointerAnalysis pa) {
        return this.computeMod(cg, pa, null);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeRef(CallGraph cg, PointerAnalysis pa) {
        return this.computeRef(cg, pa, null);
    }

    private Map<CGNode, OrdinalSet<PointerKey>> transitiveClosure(CallGraph cg, Map<CGNode, Collection<PointerKey>> scan) {
        GenReach<CGNode, PointerKey> gr = new GenReach<CGNode, PointerKey>(GraphInverter.invert(cg), scan);
        BitVectorSolver<CGNode> solver = new BitVectorSolver<CGNode>((IKilldallFramework<CGNode, BitVectorVariable>)gr);
        solver.solve();
        Map result = HashMapFactory.make();
        for (CGNode n : cg) {
            BitVectorVariable bv = (BitVectorVariable)solver.getOut(n);
            result.put(n, new OrdinalSet(bv.getValue(), gr.getLatticeValues()));
        }
        return result;
    }

    private Map<CGNode, Collection<PointerKey>> scanForMod(CallGraph cg, PointerAnalysis pa, HeapExclusions heapExclude) {
        Map result = HashMapFactory.make();
        for (CGNode n : cg) {
            result.put(n, this.scanNodeForMod(n, pa, heapExclude));
        }
        return result;
    }

    private Map<CGNode, Collection<PointerKey>> scanForRef(CallGraph cg, PointerAnalysis pa, HeapExclusions heapExclude) {
        Map result = HashMapFactory.make();
        for (CGNode n : cg) {
            result.put(n, this.scanNodeForRef(n, pa, heapExclude));
        }
        return result;
    }

    private Collection<PointerKey> scanNodeForMod(CGNode n, PointerAnalysis pa, HeapExclusions heapExclude) {
        Collection<PointerKey> result = HashSetFactory.make();
        DelegatingExtendedHeapModel h = new DelegatingExtendedHeapModel(pa.getHeapModel());
        ModVisitor v = this.makeModVisitor(n, result, pa, h);
        IR ir = n.getIR();
        if (ir != null) {
            Iterator<SSAInstruction> it = ir.iterateNormalInstructions();
            while (it.hasNext()) {
                it.next().visit(v);
            }
        }
        if (heapExclude != null) {
            result = heapExclude.filter(result);
        }
        return result;
    }

    private Collection<PointerKey> scanNodeForRef(CGNode n, PointerAnalysis pa, HeapExclusions heapExclude) {
        Collection<PointerKey> result = HashSetFactory.make();
        DelegatingExtendedHeapModel h = new DelegatingExtendedHeapModel(pa.getHeapModel());
        RefVisitor v = this.makeRefVisitor(n, result, pa, h);
        IR ir = n.getIR();
        if (ir != null) {
            Iterator<SSAInstruction> it = ir.iterateNormalInstructions();
            while (it.hasNext()) {
                it.next().visit(v);
            }
        }
        if (heapExclude != null) {
            result = heapExclude.filter(result);
        }
        return result;
    }

    protected ModVisitor makeModVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis pa, ExtendedHeapModel h) {
        return new ModVisitor(n, result, h, pa);
    }

    public Collection<PointerKey> getMod(CGNode n, ExtendedHeapModel h, PointerAnalysis pa, SSAInstruction s, HeapExclusions hexcl) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        Collection<PointerKey> result = HashSetFactory.make(2);
        ModVisitor v = this.makeModVisitor(n, result, pa, h);
        s.visit(v);
        return hexcl == null ? result : hexcl.filter(result);
    }

    protected RefVisitor makeRefVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis pa, ExtendedHeapModel h) {
        return new RefVisitor(n, result, pa, h);
    }

    public Collection<PointerKey> getRef(CGNode n, ExtendedHeapModel h, PointerAnalysis pa, SSAInstruction s, HeapExclusions hexcl) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        Collection<PointerKey> result = HashSetFactory.make(2);
        RefVisitor v = this.makeRefVisitor(n, result, pa, h);
        s.visit(v);
        return hexcl == null ? result : hexcl.filter(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ModVisitor
    extends SSAInstruction.Visitor {
        private final CGNode n;
        private final Collection<PointerKey> result;
        private final ExtendedHeapModel h;
        private final PointerAnalysis pa;

        protected ModVisitor(CGNode n, Collection<PointerKey> result, ExtendedHeapModel h, PointerAnalysis pa) {
            this.n = n;
            this.result = result;
            this.h = h;
            this.pa = pa;
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            block12: {
                block10: {
                    block11: {
                        if (!instruction.getConcreteType().isArrayType()) break block10;
                        int dim = instruction.getConcreteType().getDimensionality();
                        if (dim <= 1) break block11;
                        int d = 0;
                        while (d < dim - 1) {
                            InstanceKey i = this.h.getInstanceKeyForMultiNewArray(this.n, instruction.getNewSite(), d);
                            if (i != null) {
                                PointerKey pk = this.h.getPointerKeyForArrayContents(i);
                                assert (pk != null);
                                this.result.add(pk);
                                pk = this.h.getPointerKeyForArrayLength(i);
                                assert (pk != null);
                                this.result.add(pk);
                            }
                            ++d;
                        }
                        break block12;
                    }
                    InstanceKey i = this.h.getInstanceKeyForAllocation(this.n, instruction.getNewSite());
                    if (i == null) break block12;
                    PointerKey pk = this.h.getPointerKeyForArrayContents(i);
                    assert (pk != null);
                    this.result.add(pk);
                    pk = this.h.getPointerKeyForArrayLength(i);
                    assert (pk != null);
                    this.result.add(pk);
                    break block12;
                }
                InstanceKey i = this.h.getInstanceKeyForAllocation(this.n, instruction.getNewSite());
                if (i == null) break block12;
                IClass type = i.getConcreteType();
                try {
                    for (IField f : type.getAllInstanceFields()) {
                        PointerKey pk = this.h.getPointerKeyForInstanceField(i, f);
                        assert (pk != null);
                        this.result.add(pk);
                    }
                }
                catch (ClassHierarchyException e) {
                    Assertions.UNREACHABLE();
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getArrayRef());
            for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                this.result.add(this.h.getPointerKeyForArrayContents(i));
            }
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            IField f = this.pa.getClassHierarchy().resolveField(instruction.getDeclaredField());
            if (f != null) {
                if (instruction.isStatic()) {
                    this.result.add(this.h.getPointerKeyForStaticField(f));
                } else {
                    PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getRef());
                    for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                        this.result.add(this.h.getPointerKeyForInstanceField(i, f));
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RefVisitor
    extends SSAInstruction.Visitor {
        private final CGNode n;
        private final Collection<PointerKey> result;
        private final PointerAnalysis pa;
        private final ExtendedHeapModel h;

        protected RefVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis pa, ExtendedHeapModel h) {
            this.n = n;
            this.result = result;
            this.pa = pa;
            this.h = h;
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getArrayRef());
            for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                this.result.add(this.h.getPointerKeyForArrayLength(i));
            }
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getArrayRef());
            for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                this.result.add(this.h.getPointerKeyForArrayContents(i));
            }
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            IField f = this.pa.getClassHierarchy().resolveField(instruction.getDeclaredField());
            if (f != null) {
                if (instruction.isStatic()) {
                    this.result.add(this.h.getPointerKeyForStaticField(f));
                } else {
                    PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getRef());
                    for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                        this.result.add(this.h.getPointerKeyForInstanceField(i, f));
                    }
                }
            }
        }
    }
}

