/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.cfg.cdg.ControlDependenceGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cfg.ExceptionPrunedCFG;
import com.ibm.wala.ipa.modref.DelegatingExtendedHeapModel;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCallee;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCaller;
import com.ibm.wala.ipa.slicer.GetCaughtExceptionStatement;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ipa.slicer.HeapReachingDefs;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCallee;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.ParamCallee;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.PhiStatement;
import com.ibm.wala.ipa.slicer.PiStatement;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ipa.slicer.StatementWithInstructionIndex;
import com.ibm.wala.ipa.slicer.ValueNumberCarrier;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDG
implements NumberedGraph<Statement> {
    private final SlowSparseNumberedGraph<Statement> delegate = SlowSparseNumberedGraph.make();
    public static final boolean IGNORE_ALLOC_HEAP_DEFS = false;
    private static final boolean VERBOSE = false;
    private final CGNode node;
    private Map<SSAInstruction, Integer> instructionIndices;
    private Statement[] paramCalleeStatements;
    private Statement[] returnStatements;
    private final Map<CallSiteReference, Set<Statement>> callerParamStatements = HashMapFactory.make();
    private final Map<CallSiteReference, Set<Statement>> callerReturnStatements = HashMapFactory.make();
    private final HeapExclusions exclusions;
    private final Collection<PointerKey> locationsHandled = HashSetFactory.make();
    private final PointerAnalysis pa;
    private final ExtendedHeapModel heapModel;
    private final Map<CGNode, OrdinalSet<PointerKey>> mod;
    private final Slicer.DataDependenceOptions dOptions;
    private final Slicer.ControlDependenceOptions cOptions;
    private final CallGraph cg;
    private final ModRef modRef;
    private final Map<CGNode, OrdinalSet<PointerKey>> ref;
    private boolean isPopulated = false;

    public PDG(CGNode node, PointerAnalysis pa, Map<CGNode, OrdinalSet<PointerKey>> mod, Map<CGNode, OrdinalSet<PointerKey>> ref, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions, HeapExclusions exclusions, CallGraph cg, ModRef modRef) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        this.cg = cg;
        this.node = node;
        this.heapModel = pa == null ? null : new DelegatingExtendedHeapModel(pa.getHeapModel());
        this.pa = pa;
        this.dOptions = dOptions;
        this.cOptions = cOptions;
        this.mod = mod;
        this.exclusions = exclusions;
        this.modRef = modRef;
        this.ref = ref;
    }

    private void populate() {
        if (!this.isPopulated) {
            this.isPopulated = true;
            this.instructionIndices = PDG.computeInstructionIndices(this.node.getIR());
            this.createNodes(this.ref, this.cOptions);
            this.createScalarEdges(this.cOptions);
        }
    }

    private void createScalarEdges(Slicer.ControlDependenceOptions cOptions) {
        this.createScalarDataDependenceEdges();
        this.createControlDependenceEdges(cOptions);
    }

    public Set<Statement> getCallerParamStatements(SSAAbstractInvokeInstruction call) throws IllegalArgumentException {
        if (call == null) {
            throw new IllegalArgumentException("call == null");
        }
        this.populate();
        return this.callerParamStatements.get(call.getCallSite());
    }

    public Set<Statement> getCallerReturnStatements(SSAAbstractInvokeInstruction call) throws IllegalArgumentException {
        if (call == null) {
            throw new IllegalArgumentException("call == null");
        }
        this.populate();
        return this.callerReturnStatements.get(call.getCallSite());
    }

    private void createControlDependenceEdges(Slicer.ControlDependenceOptions cOptions) {
        IInstruction s;
        if (cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
            return;
        }
        IR ir = this.node.getIR();
        if (ir == null) {
            return;
        }
        ControlFlowGraph<ISSABasicBlock> controlFlowGraph = ir.getControlFlowGraph();
        if (cOptions.equals((Object)Slicer.ControlDependenceOptions.NO_EXCEPTIONAL_EDGES)) {
            if ((controlFlowGraph = (ControlFlowGraph)ExceptionPrunedCFG.make(controlFlowGraph)).getNumberOfNodes() == 0) {
                return;
            }
        } else {
            Assertions.productionAssertion(cOptions.equals((Object)Slicer.ControlDependenceOptions.FULL));
        }
        ControlDependenceGraph<ISSABasicBlock> cdg = new ControlDependenceGraph<ISSABasicBlock>(controlFlowGraph);
        for (ISSABasicBlock bb : cdg) {
            if (bb.isExitBlock()) continue;
            Statement src = null;
            if (bb.isEntryBlock()) {
                src = new MethodEntryStatement(this.node);
            } else {
                s = ir.getInstructions()[bb.getLastInstructionIndex()];
                if (s != null) {
                    src = this.ssaInstruction2Statement((SSAInstruction)s);
                }
            }
            if (src == null) continue;
            Iterator<ISSABasicBlock> succ = cdg.getSuccNodes(bb);
            while (succ.hasNext()) {
                IBasicBlock bb2 = succ.next();
                for (SSAInstruction st : bb2) {
                    if (st == null) continue;
                    Statement dest = this.ssaInstruction2Statement(st);
                    assert (src != null);
                    this.delegate.addEdge(src, dest);
                }
            }
        }
        MethodEntryStatement methodEntry = new MethodEntryStatement(this.node);
        for (ISSABasicBlock bb : cdg) {
            if (cdg.getPredNodeCount(bb) != 0) continue;
            Iterator iterator = bb.iterator();
            while (iterator.hasNext()) {
                IInstruction st = s = (IInstruction)iterator.next();
                Statement dest = this.ssaInstruction2Statement((SSAInstruction)st);
                this.delegate.addEdge(methodEntry, dest);
            }
        }
    }

    private void createScalarDataDependenceEdges() {
        if (this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
            return;
        }
        IR ir = this.node.getIR();
        if (ir == null) {
            return;
        }
        DefUse DU = this.node.getDU();
        SSAInstruction[] instructions = ir.getInstructions();
        if (!this.dOptions.isIgnoreExceptions()) {
            for (ISSABasicBlock bb : ir.getControlFlowGraph()) {
                SSACFG.ExceptionHandlerBasicBlock ehbb;
                if (!bb.isCatchBlock() || (ehbb = (SSACFG.ExceptionHandlerBasicBlock)bb).getCatchInstruction() == null) continue;
                Statement c = this.ssaInstruction2Statement(ehbb.getCatchInstruction());
                for (ISSABasicBlock pb : ir.getControlFlowGraph().getExceptionalPredecessors(ehbb)) {
                    SSAInstruction pi = instructions[pb.getLastInstructionIndex()];
                    assert (pi != null);
                    if (pi instanceof SSAAbstractInvokeInstruction) {
                        this.delegate.addEdge(new ExceptionalReturnCaller(this.node, pb.getLastInstructionIndex()), c);
                        continue;
                    }
                    if (!(pi instanceof SSAAbstractThrowInstruction)) continue;
                    this.delegate.addEdge(this.ssaInstruction2Statement(pi), c);
                }
            }
        }
        block10: for (Statement s : this) {
            switch (s.getKind()) {
                case NORMAL: 
                case PHI: 
                case PI: 
                case CATCH: {
                    SSAInstruction statement = this.statement2SSAInstruction(instructions, s);
                    if (statement instanceof SSAAbstractInvokeInstruction || this.dOptions.isTerminateAtCast() && statement instanceof SSACheckCastInstruction || this.dOptions.isTerminateAtCast() && statement instanceof SSAInstanceofInstruction) continue block10;
                    int i = 0;
                    while (i < statement.getNumberOfDefs()) {
                        int def = statement.getDef(i);
                        Iterator<SSAInstruction> it2 = DU.getUses(def);
                        while (it2.hasNext()) {
                            SSAArrayReferenceInstruction arr;
                            int base;
                            SSAInstruction use = it2.next();
                            if (this.dOptions.isIgnoreBasePtrs() && (use instanceof SSANewInstruction || this.hasBasePointer(use) && (def == (base = this.getBasePointer(use)) || use instanceof SSAArrayReferenceInstruction && def == (arr = (SSAArrayReferenceInstruction)use).getIndex()))) continue;
                            Statement u = this.ssaInstruction2Statement(use);
                            this.delegate.addEdge(s, u);
                        }
                        ++i;
                    }
                    continue block10;
                }
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case EXC_RET_CALLER: {
                    if (this.dOptions.isIgnoreExceptions()) {
                        Assertions._assert(!s.getKind().equals((Object)Statement.Kind.EXC_RET_CALLER));
                    }
                    ValueNumberCarrier a = (ValueNumberCarrier)((Object)s);
                    Iterator<SSAInstruction> it2 = DU.getUses(a.getValueNumber());
                    while (it2.hasNext()) {
                        SSAInstruction use = it2.next();
                        if (this.dOptions.isIgnoreBasePtrs()) {
                            if (use instanceof SSANewInstruction) continue;
                            if (this.hasBasePointer(use)) {
                                int base = this.getBasePointer(use);
                                if (a.getValueNumber() == base) continue;
                                if (use instanceof SSAArrayReferenceInstruction) {
                                    SSAArrayReferenceInstruction arr = (SSAArrayReferenceInstruction)use;
                                    if (a.getValueNumber() == arr.getIndex()) continue;
                                }
                            }
                        }
                        Statement u = this.ssaInstruction2Statement(use);
                        this.delegate.addEdge(s, u);
                    }
                    continue block10;
                }
                case NORMAL_RET_CALLEE: {
                    for (NormalStatement ret : this.computeReturnStatements(ir)) {
                        this.delegate.addEdge(ret, s);
                    }
                    continue block10;
                }
                case EXC_RET_CALLEE: {
                    if (this.dOptions.isIgnoreExceptions()) {
                        Assertions.UNREACHABLE();
                    }
                    IntIterator ii = this.getPEIs(ir).intIterator();
                    while (ii.hasNext()) {
                        int index = ii.next();
                        SSAInstruction pei = ir.getInstructions()[index];
                        if (this.dOptions.isTerminateAtCast() && pei instanceof SSACheckCastInstruction) continue;
                        if (pei instanceof SSAAbstractInvokeInstruction) {
                            ExceptionalReturnCaller st = new ExceptionalReturnCaller(this.node, index);
                            this.delegate.addEdge(st, s);
                            continue;
                        }
                        this.delegate.addEdge(new NormalStatement(this.node, index), s);
                    }
                    continue block10;
                }
                case PARAM_CALLER: {
                    ParamCaller pac = (ParamCaller)s;
                    int vn = pac.getValueNumber();
                    if (vn <= -1) continue block10;
                    if (ir.getSymbolTable().isParameter(vn)) {
                        ParamCallee a = new ParamCallee(this.node, vn);
                        this.delegate.addEdge(a, pac);
                        break;
                    }
                    SSAInstruction d = DU.getDef(vn);
                    if (this.dOptions.isTerminateAtCast() && d instanceof SSACheckCastInstruction || d == null) continue block10;
                    if (d instanceof SSAAbstractInvokeInstruction) {
                        StatementWithInstructionIndex st;
                        SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)d;
                        if (vn == call.getException()) {
                            st = new ExceptionalReturnCaller(this.node, this.instructionIndices.get(d));
                            this.delegate.addEdge(st, pac);
                            break;
                        }
                        st = new NormalReturnCaller(this.node, this.instructionIndices.get(d));
                        this.delegate.addEdge(st, pac);
                        break;
                    }
                    Statement ds = this.ssaInstruction2Statement(d);
                    this.delegate.addEdge(ds, pac);
                    break;
                }
                case HEAP_PARAM_CALLER: 
                case HEAP_PARAM_CALLEE: 
                case HEAP_RET_CALLER: 
                case HEAP_RET_CALLEE: 
                case METHOD_ENTRY: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE(s.toString());
                }
            }
        }
    }

    private void createHeapDataDependenceEdges(final PointerKey pk) {
        if (this.locationsHandled.contains(pk)) {
            return;
        }
        this.locationsHandled.add(pk);
        if (this.dOptions.isIgnoreHeap() || this.exclusions != null && this.exclusions.excludes(pk)) {
            return;
        }
        TypeReference t = HeapExclusions.getType(pk);
        if (t == null) {
            return;
        }
        IR ir = this.node.getIR();
        if (ir == null) {
            return;
        }
        Filter f = new Filter(){

            public boolean accepts(Object o) {
                if (o instanceof HeapStatement) {
                    HeapStatement h = (HeapStatement)o;
                    return h.getLocation().equals(pk);
                }
                return true;
            }
        };
        Collection relevantStatements = Iterator2Collection.toCollection(new FilterIterator(this.iterator(), f));
        Map<Statement, OrdinalSet<Statement>> heapReachingDefs = this.dOptions.isIgnoreHeap() ? null : new HeapReachingDefs(this.modRef).computeReachingDefs(this.node, ir, this.pa, this.mod, relevantStatements, new HeapExclusions(SetComplement.complement(new SingletonSet(t))), this.cg);
        block6: for (Statement st : heapReachingDefs.keySet()) {
            switch (st.getKind()) {
                case NORMAL: 
                case PHI: 
                case PI: 
                case CATCH: {
                    OrdinalSet defs = (OrdinalSet)heapReachingDefs.get(st);
                    if (defs == null) continue block6;
                    for (Statement def : defs) {
                        this.delegate.addEdge(def, st);
                    }
                    continue block6;
                }
                case PARAM_CALLER: 
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case NORMAL_RET_CALLEE: 
                case EXC_RET_CALLER: 
                case EXC_RET_CALLEE: {
                    break;
                }
                case HEAP_PARAM_CALLER: 
                case HEAP_RET_CALLER: 
                case HEAP_RET_CALLEE: {
                    OrdinalSet defs = (OrdinalSet)heapReachingDefs.get(st);
                    if (defs == null) continue block6;
                    for (Statement def : defs) {
                        this.delegate.addEdge(def, st);
                    }
                    continue block6;
                }
                case HEAP_PARAM_CALLEE: 
                case METHOD_ENTRY: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE(st.toString());
                }
            }
        }
    }

    private boolean hasBasePointer(SSAInstruction use) {
        if (use instanceof SSAFieldAccessInstruction) {
            SSAFieldAccessInstruction f = (SSAFieldAccessInstruction)use;
            return !f.isStatic();
        }
        if (use instanceof SSAArrayReferenceInstruction) {
            return true;
        }
        return use instanceof SSAArrayLengthInstruction;
    }

    private int getBasePointer(SSAInstruction use) {
        if (use instanceof SSAFieldAccessInstruction) {
            SSAFieldAccessInstruction f = (SSAFieldAccessInstruction)use;
            return f.getRef();
        }
        if (use instanceof SSAArrayReferenceInstruction) {
            SSAArrayReferenceInstruction a = (SSAArrayReferenceInstruction)use;
            return a.getArrayRef();
        }
        if (use instanceof SSAArrayLengthInstruction) {
            SSAArrayLengthInstruction s = (SSAArrayLengthInstruction)use;
            return s.getArrayRef();
        }
        Assertions.UNREACHABLE("BOOM");
        return -1;
    }

    private Collection<NormalStatement> computeReturnStatements(final IR ir) {
        Filter filter = new Filter(){

            public boolean accepts(Object o) {
                if (o instanceof NormalStatement) {
                    NormalStatement s = (NormalStatement)o;
                    SSAInstruction st = ir.getInstructions()[s.getInstructionIndex()];
                    return st instanceof SSAReturnInstruction;
                }
                return false;
            }
        };
        return Iterator2Collection.toCollection(new FilterIterator(this.iterator(), filter));
    }

    private IntSet getPEIs(IR ir) {
        BitVectorIntSet result = new BitVectorIntSet();
        int i = 0;
        while (i < ir.getInstructions().length) {
            if (ir.getInstructions()[i] != null && ir.getInstructions()[i].isPEI()) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    private Statement ssaInstruction2Statement(SSAInstruction s) {
        return PDG.ssaInstruction2Statement(this.node, s, this.instructionIndices);
    }

    public static synchronized Statement ssaInstruction2Statement(CGNode node, SSAInstruction s, Map<SSAInstruction, Integer> instructionIndices) {
        assert (s != null);
        if (s instanceof SSAPhiInstruction) {
            SSAPhiInstruction phi = (SSAPhiInstruction)s;
            return new PhiStatement(node, phi);
        }
        if (s instanceof SSAPiInstruction) {
            SSAPiInstruction pi = (SSAPiInstruction)s;
            return new PiStatement(node, pi);
        }
        if (s instanceof SSAGetCaughtExceptionInstruction) {
            return new GetCaughtExceptionStatement(node, (SSAGetCaughtExceptionInstruction)s);
        }
        Integer x = instructionIndices.get(s);
        if (x == null) {
            Assertions.UNREACHABLE(String.valueOf(s.toString()) + "\nnot found in map of\n" + node.getIR());
        }
        return new NormalStatement(node, x);
    }

    public static Map<SSAInstruction, Integer> computeInstructionIndices(IR ir) {
        Map result = HashMapFactory.make();
        if (ir != null) {
            SSAInstruction[] instructions = ir.getInstructions();
            int i = 0;
            while (i < instructions.length) {
                SSAInstruction s = instructions[i];
                if (s != null) {
                    result.put(s, new Integer(i));
                }
                ++i;
            }
        }
        return result;
    }

    private SSAInstruction statement2SSAInstruction(SSAInstruction[] instructions, Statement s) {
        SSAInstruction statement = null;
        switch (s.getKind()) {
            case NORMAL: {
                NormalStatement n = (NormalStatement)s;
                statement = instructions[n.getInstructionIndex()];
                break;
            }
            case PHI: {
                PhiStatement p = (PhiStatement)s;
                statement = p.getPhi();
                break;
            }
            case PI: {
                PiStatement ps = (PiStatement)s;
                statement = ps.getPi();
                break;
            }
            case CATCH: {
                GetCaughtExceptionStatement g = (GetCaughtExceptionStatement)s;
                statement = g.getInstruction();
                break;
            }
            default: {
                Assertions.UNREACHABLE(s.toString());
            }
        }
        return statement;
    }

    private void createNodes(Map<CGNode, OrdinalSet<PointerKey>> ref, Slicer.ControlDependenceOptions cOptions) {
        IR ir = this.node.getIR();
        if (ir != null) {
            Collection<SSAInstruction> visited = this.createNormalStatements(ir, ref);
            this.createSpecialStatements(ir, visited);
        }
        this.createCalleeParams(ref);
        this.createReturnStatements();
        if (!cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
            this.delegate.addNode(new MethodEntryStatement(this.node));
        }
    }

    private void createReturnStatements() {
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (!this.node.getMethod().getReturnType().equals(TypeReference.Void)) {
            NormalReturnCallee n = new NormalReturnCallee(this.node);
            this.delegate.addNode(n);
            list.add(n);
        }
        if (!this.dOptions.isIgnoreExceptions()) {
            ExceptionalReturnCallee e = new ExceptionalReturnCallee(this.node);
            this.delegate.addNode(e);
            list.add(e);
        }
        if (!this.dOptions.isIgnoreHeap()) {
            for (PointerKey p : this.mod.get(this.node)) {
                HeapStatement.HeapReturnCallee h = new HeapStatement.HeapReturnCallee(this.node, p);
                this.delegate.addNode(h);
                list.add(h);
            }
        }
        this.returnStatements = new Statement[list.size()];
        list.toArray(this.returnStatements);
    }

    private void createCalleeParams(Map<CGNode, OrdinalSet<PointerKey>> ref) {
        ArrayList<Statement> list = new ArrayList<Statement>();
        int i = 1;
        while (i <= this.node.getMethod().getNumberOfParameters()) {
            ParamCallee s = new ParamCallee(this.node, i);
            this.delegate.addNode(s);
            list.add(s);
            ++i;
        }
        if (!this.dOptions.isIgnoreHeap()) {
            for (PointerKey p : ref.get(this.node)) {
                HeapStatement.HeapParamCallee h = new HeapStatement.HeapParamCallee(this.node, p);
                this.delegate.addNode(h);
                list.add(h);
            }
        }
        this.paramCalleeStatements = new Statement[list.size()];
        list.toArray(this.paramCalleeStatements);
    }

    private void createSpecialStatements(IR ir, Collection<SSAInstruction> visited) {
        Iterator<SSAInstruction> it = ir.iterateAllInstructions();
        while (it.hasNext()) {
            SSAInstruction s = it.next();
            if (s == null || visited.contains(s)) continue;
            visited.add(s);
            if (s instanceof SSAPhiInstruction) {
                this.delegate.addNode(new PhiStatement(this.node, (SSAPhiInstruction)s));
                continue;
            }
            if (s instanceof SSAGetCaughtExceptionInstruction) {
                this.delegate.addNode(new GetCaughtExceptionStatement(this.node, (SSAGetCaughtExceptionInstruction)s));
                continue;
            }
            if (s instanceof SSAPiInstruction) {
                this.delegate.addNode(new PiStatement(this.node, (SSAPiInstruction)s));
                continue;
            }
            Assertions.UNREACHABLE(s.toString());
        }
    }

    private Collection<SSAInstruction> createNormalStatements(IR ir, Map<CGNode, OrdinalSet<PointerKey>> ref) {
        Collection visited = HashSetFactory.make();
        SSAInstruction[] instructions = ir.getInstructions();
        int i = 0;
        while (i < instructions.length) {
            SSAInstruction s = instructions[i];
            if (!(s instanceof SSAGetCaughtExceptionInstruction)) {
                if (s != null) {
                    this.delegate.addNode(new NormalStatement(this.node, i));
                    visited.add(s);
                }
                if (s instanceof SSAAbstractInvokeInstruction) {
                    this.addParamPassingStatements(i, ref);
                }
            }
            ++i;
        }
        return visited;
    }

    private void addParamPassingStatements(int callIndex, Map<CGNode, OrdinalSet<PointerKey>> ref) {
        SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)this.node.getIR().getInstructions()[callIndex];
        Collection params = MapUtil.findOrCreateSet(this.callerParamStatements, call.getCallSite());
        Collection rets = MapUtil.findOrCreateSet(this.callerReturnStatements, call.getCallSite());
        int j = 0;
        while (j < call.getNumberOfUses()) {
            ParamCaller st = new ParamCaller(this.node, callIndex, call.getUse(j));
            this.delegate.addNode(st);
            params.add(st);
            ++j;
        }
        if (!call.getDeclaredResultType().equals(TypeReference.Void)) {
            NormalReturnCaller st = new NormalReturnCaller(this.node, callIndex);
            this.delegate.addNode(st);
            rets.add(st);
        }
        if (!this.dOptions.isIgnoreExceptions()) {
            ExceptionalReturnCaller st = new ExceptionalReturnCaller(this.node, callIndex);
            this.delegate.addNode(st);
            rets.add(st);
        }
        if (!this.dOptions.isIgnoreHeap()) {
            OrdinalSet<PointerKey> uref = this.unionHeapLocations(this.cg, this.node, call, ref);
            for (PointerKey p : uref) {
                HeapStatement.HeapParamCaller st = new HeapStatement.HeapParamCaller(this.node, callIndex, p);
                this.delegate.addNode(st);
                params.add(st);
            }
            OrdinalSet<PointerKey> umod = this.unionHeapLocations(this.cg, this.node, call, this.mod);
            for (PointerKey p : umod) {
                HeapStatement.HeapReturnCaller st = new HeapStatement.HeapReturnCaller(this.node, callIndex, p);
                this.delegate.addNode(st);
                rets.add(st);
            }
        }
    }

    private OrdinalSet<PointerKey> unionHeapLocations(CallGraph cg, CGNode n, SSAAbstractInvokeInstruction call, Map<CGNode, OrdinalSet<PointerKey>> loc) {
        BitVectorIntSet bv = new BitVectorIntSet();
        for (CGNode t : cg.getPossibleTargets(n, call.getCallSite())) {
            bv.addAll(loc.get(t).getBackingSet());
        }
        return new OrdinalSet<PointerKey>(bv, loc.get(n).getMapping());
    }

    public String toString() {
        this.populate();
        StringBuffer result = new StringBuffer("PDG for " + this.node + ":\n");
        result.append(super.toString());
        return result.toString();
    }

    public Statement[] getParamCalleeStatements() {
        this.populate();
        return (Statement[])this.paramCalleeStatements.clone();
    }

    public Statement[] getReturnStatements() {
        this.populate();
        return (Statement[])this.returnStatements.clone();
    }

    public CGNode getCallGraphNode() {
        return this.node;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            return this.node.equals(((PDG)obj).node);
        }
        return false;
    }

    public int hashCode() {
        return 103 * this.node.hashCode();
    }

    @Override
    public int getPredNodeCount(Statement N) throws UnimplementedError {
        this.populate();
        Assertions.UNREACHABLE();
        return this.delegate.getPredNodeCount(N);
    }

    @Override
    public Iterator<? extends Statement> getPredNodes(Statement N) {
        this.populate();
        if (!this.dOptions.isIgnoreHeap()) {
            this.computeIncomingHeapDependencies(N);
        }
        return this.delegate.getPredNodes(N);
    }

    private void computeIncomingHeapDependencies(Statement N) {
        switch (N.getKind()) {
            case NORMAL: {
                NormalStatement st = (NormalStatement)N;
                Collection<PointerKey> ref = this.modRef.getRef(this.node, this.heapModel, this.pa, st.getInstruction(), this.exclusions);
                for (PointerKey pk : ref) {
                    this.createHeapDataDependenceEdges(pk);
                }
                break;
            }
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: 
            case HEAP_RET_CALLEE: {
                HeapStatement h = (HeapStatement)N;
                this.createHeapDataDependenceEdges(h.getLocation());
            }
        }
    }

    private void computeOutgoingHeapDependencies(Statement N) {
        switch (N.getKind()) {
            case NORMAL: {
                NormalStatement st = (NormalStatement)N;
                Collection<PointerKey> mod = this.modRef.getMod(this.node, this.heapModel, this.pa, st.getInstruction(), this.exclusions);
                for (PointerKey pk : mod) {
                    this.createHeapDataDependenceEdges(pk);
                }
                break;
            }
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: 
            case HEAP_RET_CALLEE: {
                HeapStatement h = (HeapStatement)N;
                this.createHeapDataDependenceEdges(h.getLocation());
            }
        }
    }

    @Override
    public int getSuccNodeCount(Statement N) throws UnimplementedError {
        this.populate();
        Assertions.UNREACHABLE();
        return this.delegate.getSuccNodeCount(N);
    }

    @Override
    public Iterator<? extends Statement> getSuccNodes(Statement N) {
        this.populate();
        if (!this.dOptions.isIgnoreHeap()) {
            this.computeOutgoingHeapDependencies(N);
        }
        return this.delegate.getSuccNodes(N);
    }

    @Override
    public boolean hasEdge(Statement src, Statement dst) throws UnimplementedError {
        this.populate();
        return this.delegate.hasEdge(src, dst);
    }

    @Override
    public void removeNodeAndEdges(Statement N) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addNode(Statement n) {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean containsNode(Statement N) {
        this.populate();
        return this.delegate.containsNode(N);
    }

    @Override
    public int getNumberOfNodes() {
        this.populate();
        return this.delegate.getNumberOfNodes();
    }

    @Override
    public Iterator<Statement> iterator() {
        this.populate();
        return this.delegate.iterator();
    }

    @Override
    public void removeNode(Statement n) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addEdge(Statement src, Statement dst) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeAllIncidentEdges(Statement node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeEdge(Statement src, Statement dst) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeIncomingEdges(Statement node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(Statement node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public int getMaxNumber() {
        this.populate();
        return this.delegate.getMaxNumber();
    }

    @Override
    public Statement getNode(int number) {
        this.populate();
        return (Statement)this.delegate.getNode(number);
    }

    @Override
    public int getNumber(Statement N) {
        this.populate();
        return this.delegate.getNumber(N);
    }

    @Override
    public Iterator<Statement> iterateNodes(IntSet s) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(Statement node) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(Statement node) {
        Assertions.UNREACHABLE();
        return null;
    }

    private static class SetComplement
    extends SetOfClasses {
        private final SetOfClasses set;

        SetComplement(SetOfClasses set) {
            this.set = set;
        }

        static SetComplement complement(SetOfClasses set) {
            return new SetComplement(set);
        }

        public void add(IClass klass) {
            Assertions.UNREACHABLE();
        }

        public boolean contains(String klassName) {
            Assertions.UNREACHABLE();
            return false;
        }

        public boolean contains(TypeReference klass) {
            return !this.set.contains(klass);
        }
    }

    private static class SingletonSet
    extends SetOfClasses {
        private final TypeReference t;

        SingletonSet(TypeReference t) {
            this.t = t;
        }

        public void add(IClass klass) {
            Assertions.UNREACHABLE();
        }

        public boolean contains(String klassName) {
            Assertions.UNREACHABLE();
            return false;
        }

        public boolean contains(TypeReference klass) {
            return this.t.equals(klass);
        }
    }
}

