/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCallee;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCaller;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.ISDG;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCallee;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.ParamCallee;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.util.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDG
extends AbstractNumberedGraph<Statement>
implements ISDG {
    private final Nodes nodeMgr = new Nodes();
    private final Edges edgeMgr = new Edges();
    private final CallGraph cg;
    private final PointerAnalysis pa;
    private final Map<CGNode, PDG> pdgMap = HashMapFactory.make();
    private final Slicer.DataDependenceOptions dOptions;
    private final Slicer.ControlDependenceOptions cOptions;
    private final Map<CGNode, OrdinalSet<PointerKey>> mod;
    private final Map<CGNode, OrdinalSet<PointerKey>> ref;
    private final Collection<CGNode> statementsAdded = HashSetFactory.make();
    private final HeapExclusions heapExclude;
    private final ModRef modRef;
    private boolean eagerComputed = false;

    public SDG(CallGraph cg, PointerAnalysis pa, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions) {
        this(cg, pa, ModRef.make(), dOptions, cOptions, null);
    }

    public SDG(CallGraph cg, PointerAnalysis pa, ModRef modRef, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions) {
        this(cg, pa, modRef, dOptions, cOptions, null);
    }

    public SDG(CallGraph cg, PointerAnalysis pa, ModRef modRef, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions, HeapExclusions heapExclude) throws IllegalArgumentException {
        if (dOptions == null) {
            throw new IllegalArgumentException("dOptions must not be null");
        }
        this.modRef = modRef;
        this.cg = cg;
        this.pa = pa;
        this.mod = dOptions.isIgnoreHeap() ? null : modRef.computeMod(cg, pa, heapExclude);
        this.ref = dOptions.isIgnoreHeap() ? null : modRef.computeRef(cg, pa, heapExclude);
        this.dOptions = dOptions;
        this.cOptions = cOptions;
        this.heapExclude = heapExclude;
    }

    @Override
    public String toString() {
        this.eagerConstruction();
        return super.toString();
    }

    private void eagerConstruction() {
        if (!this.eagerComputed) {
            this.eagerComputed = true;
            this.computeAllPDGs();
            for (PDG pdg : this.pdgMap.values()) {
                this.addPDGStatementNodes(pdg.getCallGraphNode());
            }
        }
    }

    private void addPDGStatementNodes(CGNode node) {
        if (!this.statementsAdded.contains(node)) {
            this.statementsAdded.add(node);
            PDG pdg = this.getPDG(node);
            Iterator<Statement> it = pdg.iterator();
            while (it.hasNext()) {
                this.addNode(it.next());
            }
        }
    }

    private void computeAllPDGs() {
        for (CGNode n : this.cg) {
            this.getPDG(n);
        }
    }

    @Override
    public Iterator<? extends Statement> iterateLazyNodes() {
        return this.nodeMgr.iterateLazyNodes();
    }

    @Override
    protected EdgeManager<Statement> getEdgeManager() {
        return this.edgeMgr;
    }

    @Override
    public NodeManager<Statement> getNodeManager() {
        return this.nodeMgr;
    }

    @Override
    public PDG getPDG(CGNode node) {
        PDG result = this.pdgMap.get(node);
        if (result == null) {
            result = new PDG(node, this.pa, this.mod, this.ref, this.dOptions, this.cOptions, this.heapExclude, this.cg, this.modRef);
            this.pdgMap.put(node, result);
        }
        return result;
    }

    @Override
    public Slicer.ControlDependenceOptions getCOptions() {
        return this.cOptions;
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cg.getClassHierarchy();
    }

    public PointerAnalysis getPointerAnalysis() {
        return this.pa;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Edges
    implements NumberedEdgeManager<Statement> {
        private Edges() {
        }

        @Override
        public void addEdge(Statement src, Statement dst) {
            Assertions.UNREACHABLE();
        }

        @Override
        public int getPredNodeCount(Statement N) {
            return IteratorUtil.count(this.getPredNodes(N));
        }

        @Override
        public Iterator<? extends Statement> getPredNodes(Statement N) {
            if (SDG.this.dOptions.isIgnoreExceptions()) {
                Assertions._assert(!N.getKind().equals((Object)Statement.Kind.EXC_RET_CALLEE));
                Assertions._assert(!N.getKind().equals((Object)Statement.Kind.EXC_RET_CALLER));
            }
            SDG.this.addPDGStatementNodes(N.getNode());
            switch (N.getKind()) {
                case NORMAL: 
                case PHI: 
                case PI: 
                case CATCH: 
                case PARAM_CALLER: 
                case NORMAL_RET_CALLEE: 
                case EXC_RET_CALLEE: 
                case HEAP_PARAM_CALLER: 
                case HEAP_RET_CALLEE: {
                    return SDG.this.getPDG(N.getNode()).getPredNodes(N);
                }
                case EXC_RET_CALLER: {
                    ExceptionalReturnCaller nrc = (ExceptionalReturnCaller)N;
                    SSAAbstractInvokeInstruction call = nrc.getInstruction();
                    Collection result = Iterator2Collection.toCollection(SDG.this.getPDG(N.getNode()).getPredNodes(N));
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            ExceptionalReturnCallee s = new ExceptionalReturnCallee(t);
                            SDG.this.addNode(s);
                            result.add(s);
                        }
                    }
                    return result.iterator();
                }
                case NORMAL_RET_CALLER: {
                    NormalReturnCaller nrc = (NormalReturnCaller)N;
                    SSAAbstractInvokeInstruction call = nrc.getInstruction();
                    Collection result = Iterator2Collection.toCollection(SDG.this.getPDG(N.getNode()).getPredNodes(N));
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            NormalReturnCallee s = new NormalReturnCallee(t);
                            SDG.this.addNode(s);
                            result.add(s);
                        }
                    }
                    return result.iterator();
                }
                case HEAP_RET_CALLER: {
                    HeapStatement.HeapReturnCaller r = (HeapStatement.HeapReturnCaller)N;
                    SSAAbstractInvokeInstruction call = r.getCall();
                    Collection result = Iterator2Collection.toCollection(SDG.this.getPDG(N.getNode()).getPredNodes(N));
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            if (!((OrdinalSet)SDG.this.mod.get(t)).contains(r.getLocation())) continue;
                            HeapStatement.HeapReturnCallee s = new HeapStatement.HeapReturnCallee(t, r.getLocation());
                            SDG.this.addNode(s);
                            result.add(s);
                        }
                    }
                    return result.iterator();
                }
                case PARAM_CALLEE: {
                    ParamCallee pac = (ParamCallee)N;
                    int parameterIndex = pac.getValueNumber() - 1;
                    Collection result = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        if (SDG.this.dOptions.isTerminateAtCast() && !pac.getNode().getMethod().isStatic() && pac.getValueNumber() == 1) {
                            return EmptyIterator.instance();
                        }
                        Iterator<CGNode> it = SDG.this.cg.getPredNodes(N.getNode());
                        while (it.hasNext()) {
                            CGNode caller = it.next();
                            Iterator<CallSiteReference> it2 = SDG.this.cg.getPossibleSites(caller, N.getNode());
                            while (it2.hasNext()) {
                                CallSiteReference site = it2.next();
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)ir.getInstructions()[i];
                                    int p = call.getUse(parameterIndex);
                                    ParamCaller s = new ParamCaller(caller, i, p);
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    if (!SDG.this.cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
                        MethodEntryStatement s = new MethodEntryStatement(N.getNode());
                        SDG.this.addNode(s);
                        result.add(s);
                    }
                    return result.iterator();
                }
                case HEAP_PARAM_CALLEE: {
                    HeapStatement.HeapParamCallee hpc = (HeapStatement.HeapParamCallee)N;
                    Collection result = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        Iterator<CGNode> it = SDG.this.cg.getPredNodes(N.getNode());
                        while (it.hasNext()) {
                            CGNode caller = it.next();
                            Iterator<CallSiteReference> it2 = SDG.this.cg.getPossibleSites(caller, N.getNode());
                            while (it2.hasNext()) {
                                CallSiteReference site = it2.next();
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    HeapStatement.HeapParamCaller s = new HeapStatement.HeapParamCaller(caller, i, hpc.getLocation());
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    if (!SDG.this.cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
                        MethodEntryStatement s = new MethodEntryStatement(N.getNode());
                        SDG.this.addNode(s);
                        result.add(s);
                    }
                    return result.iterator();
                }
                case METHOD_ENTRY: {
                    Collection result = HashSetFactory.make(5);
                    if (!SDG.this.cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
                        Iterator<CGNode> it = SDG.this.cg.getPredNodes(N.getNode());
                        while (it.hasNext()) {
                            CGNode caller = it.next();
                            Iterator<CallSiteReference> it2 = SDG.this.cg.getPossibleSites(caller, N.getNode());
                            while (it2.hasNext()) {
                                CallSiteReference site = it2.next();
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    NormalStatement s = new NormalStatement(caller, i);
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    return result.iterator();
                }
            }
            Assertions.UNREACHABLE(N.getKind().toString());
            return null;
        }

        @Override
        public int getSuccNodeCount(Statement N) {
            return IteratorUtil.count(this.getSuccNodes(N));
        }

        @Override
        public Iterator<? extends Statement> getSuccNodes(Statement N) {
            SDG.this.addPDGStatementNodes(N.getNode());
            switch (N.getKind()) {
                case NORMAL: {
                    if (SDG.this.cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
                        return SDG.this.getPDG(N.getNode()).getSuccNodes(N);
                    }
                    NormalStatement ns = (NormalStatement)N;
                    if (ns.getInstruction() instanceof SSAAbstractInvokeInstruction) {
                        HashSet result = HashSetFactory.make();
                        SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)ns.getInstruction();
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            MethodEntryStatement s = new MethodEntryStatement(t);
                            SDG.this.addNode(s);
                            result.add(s);
                        }
                        return new CompoundIterator<Statement>(result.iterator(), SDG.this.getPDG(N.getNode()).getSuccNodes(N));
                    }
                    return SDG.this.getPDG(N.getNode()).getSuccNodes(N);
                }
                case PHI: 
                case PI: 
                case CATCH: 
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case EXC_RET_CALLER: 
                case HEAP_PARAM_CALLEE: 
                case HEAP_RET_CALLER: 
                case METHOD_ENTRY: {
                    return SDG.this.getPDG(N.getNode()).getSuccNodes(N);
                }
                case EXC_RET_CALLEE: {
                    Collection result = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        Iterator<CGNode> it = SDG.this.cg.getPredNodes(N.getNode());
                        while (it.hasNext()) {
                            CGNode caller = it.next();
                            Iterator<CallSiteReference> it2 = SDG.this.cg.getPossibleSites(caller, N.getNode());
                            while (it2.hasNext()) {
                                CallSiteReference site = it2.next();
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    ExceptionalReturnCaller s = new ExceptionalReturnCaller(caller, i);
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    return result.iterator();
                }
                case NORMAL_RET_CALLEE: {
                    Collection result = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        Iterator<CGNode> it = SDG.this.cg.getPredNodes(N.getNode());
                        while (it.hasNext()) {
                            CGNode caller = it.next();
                            Iterator<CallSiteReference> it2 = SDG.this.cg.getPossibleSites(caller, N.getNode());
                            while (it2.hasNext()) {
                                CallSiteReference site = it2.next();
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    NormalReturnCaller s = new NormalReturnCaller(caller, i);
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    return result.iterator();
                }
                case HEAP_RET_CALLEE: {
                    HeapStatement.HeapReturnCallee r = (HeapStatement.HeapReturnCallee)N;
                    Collection result = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        Iterator<CGNode> it = SDG.this.cg.getPredNodes(N.getNode());
                        while (it.hasNext()) {
                            CGNode caller = it.next();
                            Iterator<CallSiteReference> it2 = SDG.this.cg.getPossibleSites(caller, N.getNode());
                            while (it2.hasNext()) {
                                CallSiteReference site = it2.next();
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    HeapStatement.HeapReturnCaller s = new HeapStatement.HeapReturnCaller(caller, i, r.getLocation());
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    return result.iterator();
                }
                case PARAM_CALLER: {
                    ParamCaller pac = (ParamCaller)N;
                    SSAAbstractInvokeInstruction call = pac.getInstruction();
                    Collection result = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            int i = 0;
                            while (i < t.getMethod().getNumberOfParameters()) {
                                if (!(SDG.this.dOptions.isTerminateAtCast() && call.isDispatch() && pac.getValueNumber() == call.getReceiver() || call.getUse(i) != pac.getValueNumber())) {
                                    ParamCallee s = new ParamCallee(t, i + 1);
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                                ++i;
                            }
                        }
                    }
                    return result.iterator();
                }
                case HEAP_PARAM_CALLER: {
                    HeapStatement.HeapParamCaller pc = (HeapStatement.HeapParamCaller)N;
                    SSAAbstractInvokeInstruction call = pc.getCall();
                    Collection result = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            if (!((OrdinalSet)SDG.this.ref.get(t)).contains(pc.getLocation())) continue;
                            HeapStatement.HeapParamCallee s = new HeapStatement.HeapParamCallee(t, pc.getLocation());
                            SDG.this.addNode(s);
                            result.add(s);
                        }
                    }
                    return result.iterator();
                }
            }
            Assertions.UNREACHABLE(N.getKind().toString());
            return null;
        }

        @Override
        public boolean hasEdge(Statement src, Statement dst) {
            SDG.this.addPDGStatementNodes(src.getNode());
            SDG.this.addPDGStatementNodes(dst.getNode());
            switch (src.getKind()) {
                case NORMAL: {
                    if (SDG.this.cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
                        return SDG.this.getPDG(src.getNode()).hasEdge(src, dst);
                    }
                    NormalStatement ns = (NormalStatement)src;
                    if (dst instanceof MethodEntryStatement) {
                        if (ns.getInstruction() instanceof SSAAbstractInvokeInstruction) {
                            SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)ns.getInstruction();
                            return SDG.this.cg.getPossibleTargets(src.getNode(), call.getCallSite()).contains(dst.getNode());
                        }
                        return false;
                    }
                    return SDG.this.getPDG(src.getNode()).hasEdge(src, dst);
                }
                case PHI: 
                case PI: 
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case EXC_RET_CALLER: 
                case HEAP_PARAM_CALLEE: 
                case HEAP_RET_CALLER: 
                case METHOD_ENTRY: {
                    return SDG.this.getPDG(src.getNode()).hasEdge(src, dst);
                }
                case EXC_RET_CALLEE: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (dst.getKind().equals((Object)Statement.Kind.EXC_RET_CALLER)) {
                        ExceptionalReturnCaller r = (ExceptionalReturnCaller)dst;
                        return SDG.this.cg.getPossibleTargets(r.getNode(), r.getInstruction().getCallSite()).contains(src.getNode());
                    }
                    return false;
                }
                case NORMAL_RET_CALLEE: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (dst.getKind().equals((Object)Statement.Kind.NORMAL_RET_CALLER)) {
                        NormalReturnCaller r = (NormalReturnCaller)dst;
                        return SDG.this.cg.getPossibleTargets(r.getNode(), r.getInstruction().getCallSite()).contains(src.getNode());
                    }
                    return false;
                }
                case HEAP_RET_CALLEE: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (dst.getKind().equals((Object)Statement.Kind.HEAP_RET_CALLER)) {
                        HeapStatement.HeapReturnCaller r = (HeapStatement.HeapReturnCaller)dst;
                        HeapStatement h = (HeapStatement)src;
                        return h.getLocation().equals(r.getLocation()) && SDG.this.cg.getPossibleTargets(r.getNode(), r.getCall().getCallSite()).contains(src.getNode());
                    }
                    return false;
                }
                case PARAM_CALLER: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (dst.getKind().equals((Object)Statement.Kind.PARAM_CALLEE)) {
                        ParamCallee callee = (ParamCallee)dst;
                        ParamCaller caller = (ParamCaller)src;
                        return caller.getValueNumber() == callee.getValueNumber() && SDG.this.cg.getPossibleTargets(caller.getNode(), caller.getInstruction().getCallSite()).contains(callee.getNode());
                    }
                    return false;
                }
                case HEAP_PARAM_CALLER: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (dst.getKind().equals((Object)Statement.Kind.HEAP_PARAM_CALLEE)) {
                        HeapStatement.HeapParamCallee callee = (HeapStatement.HeapParamCallee)dst;
                        HeapStatement.HeapParamCaller caller = (HeapStatement.HeapParamCaller)src;
                        return caller.getLocation().equals(callee.getLocation()) && SDG.this.cg.getPossibleTargets(caller.getNode(), caller.getCall().getCallSite()).contains(callee.getNode());
                    }
                    return false;
                }
            }
            Assertions.UNREACHABLE((Object)src.getKind());
            return false;
        }

        @Override
        public void removeAllIncidentEdges(Statement node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeEdge(Statement src, Statement dst) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeIncomingEdges(Statement node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeOutgoingEdges(Statement node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public IntSet getPredNodeNumbers(Statement node) {
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            Iterator<? extends Statement> it = this.getPredNodes(node);
            while (it.hasNext()) {
                Statement s = it.next();
                result.add(SDG.this.getNumber(s));
            }
            return result;
        }

        @Override
        public IntSet getSuccNodeNumbers(Statement node) {
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            Iterator<? extends Statement> it = this.getSuccNodes(node);
            while (it.hasNext()) {
                Statement s = it.next();
                result.add(SDG.this.getNumber(s));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Nodes
    extends SlowNumberedNodeManager<Statement> {
        private Nodes() {
        }

        @Override
        public boolean containsNode(Statement N) {
            SDG.this.eagerConstruction();
            return super.containsNode(N);
        }

        @Override
        public int getMaxNumber() {
            SDG.this.eagerConstruction();
            return super.getMaxNumber();
        }

        @Override
        public Statement getNode(int number) {
            SDG.this.eagerConstruction();
            return (Statement)super.getNode(number);
        }

        @Override
        public int getNumber(Statement s) {
            CGNode n = s.getNode();
            SDG.this.addPDGStatementNodes(n);
            return super.getNumber(s);
        }

        @Override
        public Iterator<Statement> iterateNodes(IntSet s) {
            Assertions.UNREACHABLE();
            return super.iterateNodes(s);
        }

        @Override
        public Iterator<Statement> iterator() {
            SDG.this.eagerConstruction();
            return super.iterator();
        }

        Iterator<? extends Statement> iterateLazyNodes() {
            return super.iterator();
        }

        @Override
        public int getNumberOfNodes() {
            SDG.this.eagerConstruction();
            return super.getNumberOfNodes();
        }
    }
}

