/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.ISDG;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDGView
implements ISDG {
    private final ISDG delegate;
    private final Filter<Statement> notExcluded;

    public SDGView(ISDG sdg, final Collection<Statement> exclusions) {
        this.delegate = sdg;
        this.notExcluded = new Filter<Statement>(){

            @Override
            public boolean accepts(Statement o) {
                return !exclusions.contains(o);
            }
        };
    }

    @Override
    public void addEdge(Statement src, Statement dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNode(Statement n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsNode(Statement N) {
        return this.delegate.containsNode(N);
    }

    @Override
    public int getMaxNumber() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return this.delegate.getMaxNumber();
    }

    @Override
    public Statement getNode(int number) throws UnimplementedError {
        return (Statement)this.delegate.getNode(number);
    }

    @Override
    public int getNumber(Statement N) {
        return this.delegate.getNumber(N);
    }

    @Override
    public int getNumberOfNodes() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return this.delegate.getNumberOfNodes();
    }

    @Override
    public int getPredNodeCount(Statement N) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return this.delegate.getPredNodeCount(N);
    }

    @Override
    public IntSet getPredNodeNumbers(Statement node) {
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        Iterator<? extends Statement> it = this.getPredNodes(node);
        while (it.hasNext()) {
            Statement s = it.next();
            result.add(this.getNumber(s));
        }
        return result;
    }

    @Override
    public Iterator<? extends Statement> getPredNodes(Statement N) {
        return new FilterIterator(this.delegate.getPredNodes(N), this.notExcluded);
    }

    @Override
    public int getSuccNodeCount(Statement N) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return this.delegate.getSuccNodeCount(N);
    }

    @Override
    public IntSet getSuccNodeNumbers(Statement node) {
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        Iterator<? extends Statement> it = this.getSuccNodes(node);
        while (it.hasNext()) {
            Statement s = it.next();
            result.add(this.getNumber(s));
        }
        return result;
    }

    @Override
    public Iterator<? extends Statement> getSuccNodes(Statement N) {
        return new FilterIterator(this.delegate.getSuccNodes(N), this.notExcluded);
    }

    @Override
    public boolean hasEdge(Statement src, Statement dst) {
        if (src instanceof HeapStatement && dst instanceof HeapStatement) {
            HeapStatement hs = (HeapStatement)src;
            HeapStatement hd = (HeapStatement)dst;
            if (!hs.getLocation().equals(hd.getLocation())) {
                return false;
            }
        }
        return this.notExcluded.accepts(dst) && this.notExcluded.accepts(src) && this.delegate.hasEdge(src, dst);
    }

    @Override
    public Iterator<Statement> iterator() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return this.delegate.iterator();
    }

    @Override
    public Iterator<Statement> iterateNodes(IntSet s) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return this.delegate.iterateNodes(s);
    }

    @Override
    public void removeAllIncidentEdges(Statement node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(Statement src, Statement dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeIncomingEdges(Statement node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNode(Statement n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNodeAndEdges(Statement N) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(Statement node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slicer.ControlDependenceOptions getCOptions() {
        return this.delegate.getCOptions();
    }

    @Override
    public PDG getPDG(CGNode node) {
        return this.delegate.getPDG(node);
    }

    @Override
    public Iterator<? extends Statement> iterateLazyNodes() {
        return this.delegate.iterateLazyNodes();
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.delegate.getClassHierarchy();
    }
}

