/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.dataflow.IFDS.BackwardsSupergraph;
import com.ibm.wala.dataflow.IFDS.IFlowFunctionMap;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.dataflow.IFDS.TabulationProblem;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.dataflow.IFDS.TabulationSolver;
import com.ibm.wala.eclipse.util.CancelException;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.ISDG;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.SDGSupergraph;
import com.ibm.wala.ipa.slicer.SDGView;
import com.ibm.wala.ipa.slicer.SliceFunctions;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slicer {
    public static final boolean DEBUG = false;
    public static final boolean VERBOSE = false;
    public static final int BAIL_OUT = -1;

    public static Collection<Statement> computeBackwardSlice(Statement s, CallGraph cg, PointerAnalysis pa, DataDependenceOptions dOptions, ControlDependenceOptions cOptions) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(new SDG(cg, pa, ModRef.make(), dOptions, cOptions), (Collection<Statement>)Collections.singleton(s), true);
    }

    public static Collection<Statement> computeForwardSlice(Statement s, CallGraph cg, PointerAnalysis pa, DataDependenceOptions dOptions, ControlDependenceOptions cOptions) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(new SDG(cg, pa, ModRef.make(), dOptions, cOptions), (Collection<Statement>)Collections.singleton(s), false);
    }

    public static Collection<Statement> computeBackwardSlice(SDG sdg, Statement s) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(sdg, (Collection<Statement>)Collections.singleton(s), true);
    }

    public static Collection<Statement> computeForwardSlice(SDG sdg, Statement s) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(sdg, (Collection<Statement>)Collections.singleton(s), false);
    }

    public static Collection<Statement> computeBackwardSlice(SDG sdg, Collection<Statement> ss) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(sdg, ss, true);
    }

    protected static Collection<Statement> computeSlice(SDG sdg, Collection<Statement> ss, boolean backward) throws CancelException {
        if (sdg == null) {
            throw new IllegalArgumentException("sdg cannot be null");
        }
        return new Slicer().slice(sdg, ss, backward);
    }

    public Collection<Statement> slice(SDG sdg, Collection<Statement> ss, boolean backward) throws CancelException {
        if (sdg == null) {
            throw new IllegalArgumentException("sdg cannot be null");
        }
        Collection rootsConsidered = HashSetFactory.make();
        Stack<Statement> workList = new Stack<Statement>();
        Collection result = HashSetFactory.make();
        for (Statement s : ss) {
            workList.push(s);
        }
        while (!workList.isEmpty()) {
            Statement root = (Statement)workList.pop();
            rootsConsidered.add(root);
            Collection empty = Collections.emptySet();
            SDGView sdgView = new SDGView(sdg, empty);
            SliceProblem p = this.makeSliceProblem(root, sdgView, backward);
            TabulationSolver<Statement, PDG> solver = TabulationSolver.make(p);
            TabulationResult<Statement, PDG> tr = solver.solve();
            Collection<Statement> slice = tr.getSupergraphNodesReached();
            result.addAll(slice);
            Collection<Statement> newRoots = Slicer.computeNewRoots(slice, root, rootsConsidered, sdg, backward);
            for (Statement st : newRoots) {
                workList.push(st);
            }
        }
        return result;
    }

    protected SliceProblem makeSliceProblem(Statement root, ISDG sdgView, boolean backward) {
        return new SliceProblem(root, sdgView, backward);
    }

    public static Collection<Statement> computeNewRoots(Collection<Statement> slice, Statement root, Collection<Statement> rootsConsidered, ISDG sdg, boolean backward) {
        if (backward) {
            return Slicer.computeNewBackwardRoots(slice, root, rootsConsidered, sdg);
        }
        return Slicer.computeNewForwardRoots(slice, root, rootsConsidered, sdg);
    }

    private static Collection<Statement> computeNewForwardRoots(Collection<Statement> slice, Statement root, Collection<Statement> rootsConsidered, ISDG sdg) {
        Collection result = HashSetFactory.make();
        block3: for (Statement st : slice) {
            if (!st.getNode().equals(root.getNode())) continue;
            switch (st.getKind()) {
                case NORMAL_RET_CALLEE: 
                case EXC_RET_CALLEE: 
                case HEAP_RET_CALLEE: {
                    Collection succs = Iterator2Collection.toCollection(sdg.getSuccNodes(st));
                    succs.removeAll(slice);
                    for (Statement s : succs) {
                        if (rootsConsidered.contains(s)) continue;
                        result.add(s);
                    }
                    continue block3;
                }
            }
        }
        return result;
    }

    private static Collection<Statement> computeNewBackwardRoots(Collection<Statement> slice, Statement root, Collection<Statement> rootsConsidered, ISDG sdg) {
        Collection result = HashSetFactory.make();
        block3: for (Statement st : slice) {
            if (!st.getNode().equals(root.getNode())) continue;
            switch (st.getKind()) {
                case PARAM_CALLEE: 
                case HEAP_PARAM_CALLEE: 
                case METHOD_ENTRY: {
                    Collection preds = Iterator2Collection.toCollection(sdg.getPredNodes(st));
                    preds.removeAll(slice);
                    for (Statement p : preds) {
                        if (rootsConsidered.contains(p)) continue;
                        result.add(p);
                    }
                    continue block3;
                }
            }
        }
        return result;
    }

    public static Collection<Statement> computeBackwardSlice(Statement s, CallGraph cg, PointerAnalysis pointerAnalysis) throws IllegalArgumentException, CancelException {
        return Slicer.computeBackwardSlice(s, cg, pointerAnalysis, DataDependenceOptions.FULL, ControlDependenceOptions.FULL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ControlDependenceOptions {
        FULL("full"),
        NONE("none"),
        NO_EXCEPTIONAL_EDGES("no_exceptional_edges");

        private final String name;

        private ControlDependenceOptions(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataDependenceOptions {
        FULL("full", false, false, false, false),
        NO_BASE_PTRS("no_base_ptrs", true, false, false, false),
        NO_BASE_NO_HEAP("no_base_no_heap", true, true, false, false),
        NO_BASE_NO_EXCEPTIONS("no_base_no_exceptions", true, false, false, true),
        NO_BASE_NO_HEAP_NO_EXCEPTIONS("no_base_no_heap_no_exceptions", true, true, false, true),
        NO_HEAP("no_heap", false, true, false, false),
        NONE("none", true, true, true, true),
        REFLECTION("no_base_no_heap_no_cast", true, true, true, true);

        private final String name;
        private final boolean ignoreBasePtrs;
        private final boolean ignoreHeap;
        private final boolean terminateAtCast;
        private final boolean ignoreExceptions;

        private DataDependenceOptions(String name, boolean ignoreBasePtrs, boolean ignoreHeap, boolean terminateAtCast, boolean ignoreExceptions) {
            this.name = name;
            this.ignoreBasePtrs = ignoreBasePtrs;
            this.ignoreHeap = ignoreHeap;
            this.terminateAtCast = terminateAtCast;
            this.ignoreExceptions = ignoreExceptions;
        }

        public final boolean isIgnoreBasePtrs() {
            return this.ignoreBasePtrs;
        }

        public final boolean isIgnoreHeap() {
            return this.ignoreHeap;
        }

        public final boolean isIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public final boolean isTerminateAtCast() {
            return this.terminateAtCast;
        }

        public final String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SliceProblem
    implements TabulationProblem<Statement, PDG> {
        private final Statement src;
        private final ISupergraph<Statement, PDG> supergraph;
        private final IFlowFunctionMap<Statement> f;

        public SliceProblem(Statement s, ISDG sdg, boolean backward) {
            this.src = s;
            SDGSupergraph forwards = new SDGSupergraph(sdg, this.src, backward);
            this.supergraph = backward ? (ISupergraph)BackwardsSupergraph.make(forwards) : forwards;
            this.f = new SliceFunctions();
        }

        @Override
        public TabulationDomain getDomain() {
            Assertions.UNREACHABLE();
            return null;
        }

        @Override
        public IFlowFunctionMap<Statement> getFunctionMap() {
            return this.f;
        }

        @Override
        public IMergeFunction getMergeFunction() {
            return null;
        }

        @Override
        public SparseIntSet getReachableOnEntry() {
            return SparseIntSet.singleton(0);
        }

        @Override
        public ISupergraph<Statement, PDG> getSupergraph() {
            return this.supergraph;
        }
    }
}

