/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.analysis.reflection.Malleable;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ClassTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.BypassSyntheticClass;
import com.ibm.wala.ipa.summaries.BypassSyntheticClassLoader;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BypassClassTargetSelector
implements ClassTargetSelector {
    private static final boolean DEBUG = false;
    private final Set<TypeReference> allocatableTypes;
    private final IClassHierarchy cha;
    private final ClassTargetSelector parent;
    private final BypassSyntheticClassLoader bypassLoader;

    public BypassClassTargetSelector(ClassTargetSelector parent, Set<TypeReference> allocatableTypes, IClassHierarchy cha, IClassLoader bypassLoader) throws IllegalArgumentException {
        if (bypassLoader == null) {
            throw new IllegalArgumentException("bypassLoader == null");
        }
        if (!(bypassLoader instanceof BypassSyntheticClassLoader)) {
            Assertions._assert(false, "unexpected bypass loader: " + bypassLoader.getClass());
        }
        this.allocatableTypes = allocatableTypes;
        this.bypassLoader = (BypassSyntheticClassLoader)bypassLoader;
        this.parent = parent;
        this.cha = cha;
    }

    @Override
    public IClass getAllocatedTarget(CGNode caller, NewSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        TypeReference nominalRef = site.getDeclaredType();
        if (Malleable.isMalleable(nominalRef)) {
            return null;
        }
        IClass realType = this.cha.lookupClass(nominalRef);
        if (realType == null) {
            return this.parent.getAllocatedTarget(caller, site);
        }
        TypeReference realRef = realType.getReference();
        if (this.allocatableTypes.contains(realRef)) {
            if (realType.isAbstract() || realType.isInterface()) {
                TypeName syntheticName = BypassSyntheticClass.getName(realRef);
                IClass result = this.bypassLoader.lookupClass(syntheticName);
                if (result != null) {
                    return result;
                }
                BypassSyntheticClass x = new BypassSyntheticClass(realType, this.bypassLoader, this.cha);
                this.bypassLoader.registerClass(syntheticName, x);
                return x;
            }
            return realType;
        }
        return this.parent.getAllocatedTarget(caller, site);
    }
}

