/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyMethodTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BypassMethodTargetSelector
implements MethodTargetSelector {
    static final boolean DEBUG = false;
    private final Map<MethodReference, MethodSummary> methodSummaries;
    private final Set<Atom> ignoredPackages;
    private final IClassHierarchy cha;
    private final MethodTargetSelector parent;
    private final HashMap<MethodReference, SummarizedMethod> syntheticMethods = HashMapFactory.make();

    public BypassMethodTargetSelector(MethodTargetSelector parent, Map<MethodReference, MethodSummary> methodSummaries, Set<Atom> ignoredPackages, IClassHierarchy cha) {
        this.methodSummaries = methodSummaries;
        this.ignoredPackages = ignoredPackages;
        this.parent = parent;
        this.cha = cha;
    }

    @Override
    public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass dispatchType) {
        IMethod target;
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        MethodReference ref = site.getDeclaredTarget();
        IMethod resolved = null;
        if (ClassHierarchyMethodTargetSelector.feasibleChaResolution(this.cha, site, dispatchType)) {
            if (site.isVirtual() || site.isInterface()) {
                if (dispatchType != null) {
                    resolved = this.cha.resolveMethod(dispatchType, ref.getSelector());
                }
            } else {
                IClass computedDispatchType = this.cha.lookupClass(site.getDeclaredTarget().getDeclaringClass());
                if (computedDispatchType != null) {
                    resolved = this.cha.resolveMethod(computedDispatchType, ref.getSelector());
                }
            }
        }
        IMethod iMethod = target = resolved == null ? this.findOrCreateSyntheticMethod(ref, site.isStatic()) : this.getBypassInternal(resolved, site.isStatic());
        if (target != null) {
            return target;
        }
        if (this.canIgnore(site.getDeclaredTarget())) {
            return null;
        }
        target = this.parent.getCalleeTarget(caller, site, dispatchType);
        if (target != null) {
            SyntheticMethod bypassTarget = this.getBypassInternal(target, site.isStatic());
            return bypassTarget == null ? target : bypassTarget;
        }
        return target;
    }

    private SyntheticMethod getBypassInternal(IMethod m, boolean isStatic) {
        return this.findOrCreateSyntheticMethod(m, isStatic);
    }

    private SyntheticMethod findOrCreateSyntheticMethod(MethodReference m, boolean isStatic) {
        IClass C;
        TypeReference T;
        if (this.syntheticMethods.containsKey(m)) {
            return this.syntheticMethods.get(m);
        }
        MethodSummary summ = null;
        if (this.canIgnore(m)) {
            T = m.getDeclaringClass();
            C = this.cha.lookupClass(T);
            if (C == null) {
                this.syntheticMethods.put(m, null);
                return null;
            }
            summ = this.generateNoOp(m, isStatic);
        } else {
            summ = this.findSummary(m);
        }
        if (summ != null) {
            T = m.getDeclaringClass();
            C = this.cha.lookupClass(T);
            if (C == null) {
                this.syntheticMethods.put(m, null);
                return null;
            }
            SummarizedMethod n = new SummarizedMethod(m, summ, C);
            this.syntheticMethods.put(m, n);
            return n;
        }
        this.syntheticMethods.put(m, null);
        return null;
    }

    private SyntheticMethod findOrCreateSyntheticMethod(IMethod m, boolean isStatic) {
        MethodReference ref = m.getReference();
        if (this.syntheticMethods.containsKey(ref)) {
            return this.syntheticMethods.get(ref);
        }
        MethodSummary summ = null;
        summ = this.canIgnore(ref) ? this.generateNoOp(ref, isStatic) : this.findSummary(ref);
        if (summ != null) {
            SummarizedMethod n = new SummarizedMethod(ref, summ, m.getDeclaringClass());
            this.syntheticMethods.put(ref, n);
            return n;
        }
        this.syntheticMethods.put(ref, null);
        return null;
    }

    private MethodSummary generateNoOp(MethodReference m, boolean isStatic) {
        return new NoOpSummary(m, isStatic);
    }

    protected boolean canIgnore(MemberReference m) {
        TypeReference T = m.getDeclaringClass();
        TypeName n = T.getName();
        Atom p = n.getPackage();
        return this.ignoredPackages.contains(p);
    }

    private MethodSummary findSummary(MemberReference m) {
        MethodSummary result = this.methodSummaries.get(m);
        if (result != null) {
            return result;
        }
        TypeReference t = m.getDeclaringClass();
        result = this.methodSummaries.get(t);
        if (result != null) {
            return result;
        }
        if (t.isArrayType()) {
            return null;
        }
        Atom p = t.getName().getPackage();
        result = this.methodSummaries.get(p);
        if (result != null) {
            return result;
        }
        return result;
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public boolean mightReturnSyntheticMethod(CGNode caller, CallSiteReference site) {
        if (this.parent.mightReturnSyntheticMethod(caller, site)) {
            return true;
        }
        IMethod resolved = this.cha.resolveMethod(site.getDeclaredTarget());
        if (resolved == null) {
            return true;
        }
        return this.findOrCreateSyntheticMethod(resolved.getReference(), resolved.isStatic()) != null;
    }

    @Override
    public boolean mightReturnSyntheticMethod(MethodReference declaredTarget) {
        if (this.parent.mightReturnSyntheticMethod(declaredTarget)) {
            return true;
        }
        IMethod resolved = this.cha.resolveMethod(declaredTarget);
        if (resolved == null) {
            return true;
        }
        return this.findOrCreateSyntheticMethod(resolved.getReference(), resolved.isStatic()) != null;
    }

    private static class NoOpSummary
    extends MethodSummary {
        public NoOpSummary(MethodReference method, boolean isStatic) {
            super(method);
            this.setStatic(isStatic);
        }

        public SSAInstruction[] getStatements() {
            if (this.getReturnType().equals(TypeReference.Void)) {
                return NO_STATEMENTS;
            }
            int nullValue = this.getNumberOfParameters() + 1;
            SSAInstruction[] result = new SSAInstruction[]{new SSAReturnInstruction(nullValue, this.getReturnType().isPrimitiveType())};
            return result;
        }
    }
}

