/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.SetType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionSummary {
    private final Map<Integer, Set<TypeReference>> map = HashMapFactory.make();

    public void addType(int bcIndex, TypeReference T) {
        Set<TypeReference> S = this.findOrCreateSetForBCIndex(bcIndex);
        S.add(T);
    }

    private Set<TypeReference> findOrCreateSetForBCIndex(int bcIndex) {
        Integer I = new Integer(bcIndex);
        Set result = this.map.get(I);
        if (result == null) {
            result = HashSetFactory.make(10);
            this.map.put(I, result);
        }
        return result;
    }

    public TypeAbstraction getTypeForNewInstance(int bcIndex, IClassHierarchy cha) {
        Set<TypeReference> S = this.map.get(new Integer(bcIndex));
        if (S == null) {
            return null;
        }
        PointType[] p = new PointType[S.size()];
        Iterator<TypeReference> it = S.iterator();
        int i = 0;
        while (i < p.length) {
            TypeReference T = it.next();
            IClass klass = cha.lookupClass(T);
            if (klass == null) {
                Assertions._assert(klass != null, "null type for " + T);
            }
            p[i] = new PointType(klass);
            ++i;
        }
        return new SetType(p);
    }

    public Set getTypesForProgramLocation(int bcIndex) {
        return this.map.get(new Integer(bcIndex));
    }
}

