/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.ReflectionSpecification;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.ReflectionSummary;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReflectionReader
implements BytecodeConstants,
ReflectionSpecification {
    static final boolean DEBUG = false;
    private final AnalysisScope scope;
    private final HashMap<MethodReference, ReflectionSummary> summaries = HashMapFactory.make();
    private static final int E_CLASSLOADER = 0;
    private static final int E_METHOD = 1;
    private static final int E_CLASS = 2;
    private static final int E_PACKAGE = 3;
    private static final int E_REFLECTION_SPEC = 4;
    private static final int E_NEW_INSTANCE = 5;
    private static final int E_TYPE = 6;
    private static final Map<String, Integer> elementMap = HashMapFactory.make(7);
    private static final String A_NAME = "name";
    private static final String A_DESCRIPTOR = "descriptor";
    private static final String A_BCINDEX = "bcIndex";

    static {
        elementMap.put("classloader", new Integer(0));
        elementMap.put("method", new Integer(1));
        elementMap.put("class", new Integer(2));
        elementMap.put("package", new Integer(3));
        elementMap.put("reflectionSpec", new Integer(4));
        elementMap.put("newInstance", new Integer(5));
        elementMap.put("type", new Integer(6));
    }

    public XMLReflectionReader(InputStream xmlFile, AnalysisScope scope) {
        Assertions.productionAssertion(xmlFile != null, "XMLMethodSummaryReader given null xmlFile");
        this.scope = scope;
        try {
            this.readXML(xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    private void readXML(InputStream xml) throws SAXException, IOException, ParserConfigurationException {
        SAXHandler handler = new SAXHandler();
        Assertions._assert(xml != null, "Null xml stream");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.newSAXParser().parse(new InputSource(xml), (DefaultHandler)handler);
    }

    public Map<MethodReference, ReflectionSummary> getSummaries() {
        return this.summaries;
    }

    @Override
    public TypeAbstraction getTypeForNewInstance(MemberReference method, int bcIndex, IClassHierarchy cha) {
        ReflectionSummary summary = this.summaries.get(method);
        if (summary != null) {
            return summary.getTypeForNewInstance(bcIndex, cha);
        }
        return null;
    }

    public ReflectionSummary getSummary(MemberReference m) {
        return this.summaries.get(m);
    }

    private class SAXHandler
    extends DefaultHandler {
        private ClassLoaderReference governingLoader = null;
        private ReflectionSummary governingMethod = null;
        private TypeReference governingClass = null;
        private Atom governingPackage = null;
        private int bcIndex = -1;

        private SAXHandler() {
        }

        public void startElement(String uri, String name, String qName, Attributes atts) {
            Integer element = (Integer)elementMap.get(qName);
            if (element == null) {
                Assertions.UNREACHABLE("Invalid element: " + qName);
            }
            switch (element) {
                case 0: {
                    String clName = atts.getValue(XMLReflectionReader.A_NAME);
                    this.governingLoader = this.classLoaderName2Ref(clName);
                    break;
                }
                case 1: {
                    this.startMethod(atts);
                    break;
                }
                case 2: {
                    String cname = atts.getValue(XMLReflectionReader.A_NAME);
                    this.startClass(cname);
                    break;
                }
                case 6: {
                    String tName = atts.getValue(XMLReflectionReader.A_NAME);
                    this.processType(tName);
                    break;
                }
                case 5: {
                    String bcIndexString = atts.getValue(XMLReflectionReader.A_BCINDEX);
                    this.bcIndex = Integer.parseInt(bcIndexString);
                    break;
                }
                case 3: {
                    this.governingPackage = Atom.findOrCreateUnicodeAtom(atts.getValue(XMLReflectionReader.A_NAME).replace('.', '/'));
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE("Unexpected element: " + name);
                }
            }
        }

        private void processType(String tName) {
            TypeReference T = this.className2Ref(tName);
            this.governingMethod.addType(this.bcIndex, T);
        }

        private void startClass(String cname) {
            String clName = "L" + this.governingPackage + "." + cname;
            this.governingClass = this.className2Ref(clName);
        }

        public void endElement(String uri, String name, String qName) {
            Integer element = (Integer)elementMap.get(qName);
            if (element == null) {
                Assertions.UNREACHABLE("Invalid element: " + name);
            }
            switch (element) {
                case 0: {
                    this.governingLoader = null;
                    break;
                }
                case 1: {
                    this.governingMethod = null;
                    break;
                }
                case 2: {
                    this.governingClass = null;
                    break;
                }
                case 5: {
                    this.bcIndex = -1;
                    break;
                }
                case 3: {
                    this.governingPackage = null;
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE("Unexpected element: " + name);
                }
            }
        }

        private void startMethod(Attributes atts) {
            String methodName = atts.getValue(XMLReflectionReader.A_NAME);
            Atom mName = Atom.findOrCreateUnicodeAtom(methodName);
            String descString = atts.getValue(XMLReflectionReader.A_DESCRIPTOR).replace('.', '/');
            Descriptor D = Descriptor.findOrCreateUTF8(descString);
            MethodReference ref = MethodReference.findOrCreate(this.governingClass, mName, D);
            this.governingMethod = new ReflectionSummary();
            XMLReflectionReader.this.summaries.put(ref, this.governingMethod);
        }

        private ClassLoaderReference classLoaderName2Ref(String clName) {
            return XMLReflectionReader.this.scope.getLoader(Atom.findOrCreateUnicodeAtom(clName));
        }

        private TypeReference className2Ref(String clName) {
            clName = clName.replace('.', '/');
            return TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(clName));
        }
    }
}

